/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : CommsAction.cpp
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.19 $
//
// Description      : CommsAction.cpp contains the implementation of the 
//                    CSCPTextCommsAction class.  This action is derived from 
//                    Core::CIOAction.  Its purpose is to distribute a 
//                    value to a graphical element in its OnUpdate 
//                    member.  This member is called from 
//                    CCommsSystemInterface::UpdateComms().  
//                    CCommsSystemInterface keeps track of all 
//                    CSCPTextCommsAction instances so that it may update all 
//                    of them.  Each CSCPTextCommsAction instance shares a 
//                    single CVariant instance.  Thus, many graphical 
//                    elements may want the value of a variable and 
//                    each graphical element will have an instance of a 
//                    CSCPTextCommsAction to read that variable.  However, the 
//                    value will be read from simulation once and 
//                    placed in the shared CVariant.  CSCPTextCommsAction will 
//                    also update simulation variable in OnLButtonUp.  
//                    This member will be called whenever an action 
//                    occurs on a graphical element.  The action might 
//                    be clicking a button or pressing the 
//                    enter/carriage return key while in an editbox.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : Core::CIOAction, Core::CWidget, Comms::CCommsShared, 
//                    Core::CVariant, _FSI_STL::string, _FSI_STL::list, _FSI_STL::map, 
//                    _FSI_STL::vector, Comms::CCommsSystemInterface, 
//                    Core::CChangeValue, Core::CRange.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 4
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log$
/////////////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#include "SCPTextCommsAction.h"

#include "..\core\DataConversion.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

/////////////////////////////////////////////////////////////////////////////
//
// CSCPTextCommsAction::CSCPTextCommsAction
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Default constructor.  Sets the name of the widget.
//                    Adds the CSCPTextCommsActionPage to the list of widget
//                    property pages.
/////////////////////////////////////////////////////////////////////////////
CSCPTextCommsAction::CSCPTextCommsAction()
{
    m_stlStrWidgetName = _FSI_STL::string("SCP_Text_Comms");
}

/////////////////////////////////////////////////////////////////////////////
//
// CSCPTextCommsAction::~CSCPTextCommsAction
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Default destructor.  If a CCommsSystemInterface derived
//                    class has been instaniated, then an attempt is made to
//                    remove this instance of CSCPTextCommsAction from the list of
//                    CSCPTextCommsAction instances managed by the 
//                    CCommsSystemInterface derived class.
//
/////////////////////////////////////////////////////////////////////////////
CSCPTextCommsAction::~CSCPTextCommsAction()
{
}

/////////////////////////////////////////////////////////////////////////////
//
// void CSCPTextCommsAction::Initialize()
//
// Inputs           : CXMLWidget*& rpXMLWidget - pointer to return a new 
//                                               instance of a CXMLWidget.
//                    CWnd* pWnd - the parent of this widget.
//                    const long lId - the control ID.
//                    bool bEditMode - whether this widget is being created 
//                                     in the editor or the runtime.
//
// Return Values    : None.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Initialize() is a common framework method that must be
//                    implemented by each CWidget derived class.  Besides 
//                    standard initialization code for a CAction and CWidget
//                    derived class, the CCommsSystemInterface derived class
//                    is started if it has not already been started. 
//
/////////////////////////////////////////////////////////////////////////////
void CSCPTextCommsAction::Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                                const long lId, bool bEditMode)
{
    if (m_pCommsSystemInterface != NULL && lId != 0)
    {
        // Start comms if it hasn't been started and we're not editing.
        if (m_pCommsSystemInterface->Started() == false && m_bEditing == false)
        {
            m_pCommsSystemInterface->Start();
        }
    }

    // Set the help text.
    if (rpXMLWidget == NULL)
    {
        m_stlStrName = "SCPTextComms ";
    }

    // Call the base class.
    CWidget::Initialize(rpXMLWidget,pWnd, lId, bEditMode);

    // Set the action and widget pointers.
    m_pAction = this;
    m_pWidget = (CWidget*)this;

    if (rpXMLWidget != NULL)
    {
        m_pIOActionXMLWidget = m_pXMLWidget;
        ResetProperties();
    }

    m_bInitialized = true;
}

/////////////////////////////////////////////////////////////////////////////
//
// CWidget* CSCPTextCommsAction::CreateObject()
//
// Inputs           : None.
//
// Return Values    : Address of a new instance of CSCPTextCommsAction.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : CreateObject() is a common framework method that must be
//                    implemented by each CWidget derived class.  The main
//                    application associates the name of this widget with this
//                    static CreateObject method so that a new object can be
//                    created without linking against the library that contains
//                    this class.
//
/////////////////////////////////////////////////////////////////////////////
CWidget* CSCPTextCommsAction::CreateObject()
{
    return new CSCPTextCommsAction();
}

/////////////////////////////////////////////////////////////////////////////
//
// void CSCPTextCommsAction::ResetProperties()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : ResetProperties() is a common framework method that 
//                    should be implemented by each CWidget derived class.  
//                    ResetProperties is called when a new instance is created
//                    as well as when the widget props dialog is used to change
//                    properties. 
//
/////////////////////////////////////////////////////////////////////////////
void CSCPTextCommsAction::ResetProperties()
{
    CWidget::ResetProperties();
    CIOAction::ResetProperties();
    CCommsAction::ResetProperties();
    
    // May need to parse more.  If not, then delete this method.
}

/////////////////////////////////////////////////////////////////////////////
//
// enum LButtonUpReturn CSCPTextCommsAction::OnLButtonUp()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : OnLButtonUp() is a common framework method for CAction
//                    derived classes.  Its purpose is to perform a action 
//                    based on some user interaction with the graphical 
//                    element to which the instance of this class is attached.
//                    In this case, OnLButtonUp is used to get a value from
//                    the graphical element to then write to simulation.
//
/////////////////////////////////////////////////////////////////////////////
enum LButtonUpReturn CSCPTextCommsAction::OnLButtonUp()
{
    m_sync.Lock();

    if (m_bCanWrite == false)
    {
        m_sync.Unlock();
        return LBU_CAN_NOT_WRITE;
    }

    if (m_bDeleting == true)
    {
        // Since memory is going away, the parent is probably
        // going away as well.  Let the parent think that
        // everything went ok.  Or, no write can take place
        m_sync.Unlock();
        return LBU_OK;
    }

    if (m_pCommsSystemInterface == NULL)
    {
        m_sync.Unlock();
        return LBU_NO_COMMS;
    }

    CVariableData* pVarData = NULL;

    if (m_pCommsSystemInterface->m_mapVarName2Data.find(m_stlStrVariableToWatch) !=
        m_pCommsSystemInterface->m_mapVarName2Data.end())
    {
        // Get the variable data to change the type.
        pVarData = 
            m_pCommsSystemInterface->m_mapVarName2Data[m_stlStrVariableToWatch];

        if (pVarData == NULL)
        {
            m_sync.Unlock();
            return LBU_OK;
        }
    }
    else
    {
        m_sync.Unlock();
        return LBU_OK;
    }

    CVariant variant(m_variant);
    // Perform range check before data conversion because the parent widget
    // will have a high and low in terms of the convert type if a conversion
    // was desired.
    if (!m_vectRanges.empty())
    {
        variant.LimitFloating(m_bLimitFloating);
        variant.Precision(m_ucPrecision);
        if (m_pParentWidget->RangeLow(m_stlStrElementVar) > variant  ||
            m_pParentWidget->RangeHigh(m_stlStrElementVar) < variant)
        {
            m_stlStrError = (_FSI_STL::string)variant + " is not a valid entry.\n" 
                            "For the variable " +
                            m_stlStrVariableToWatch +
                            ", the valid range is " + 
                            (_FSI_STL::string)m_pParentWidget->RangeLow(m_stlStrElementVar) +
                            " to " +
                            (_FSI_STL::string)m_pParentWidget->RangeHigh(m_stlStrElementVar);
            AfxBeginThread(MsgThread, (LPVOID)0);

            m_sync.Unlock();
            return LBU_NOT_IN_RANGE;
        }
    }

    // See the parent widget is using a converted data value.  If so,
    // then convert it back to the format in which it came form the host.
    if (m_lDataFormat != m_lInitialDataFormat &&
        m_lDataFormat != Generic_No_Conversions)
    {
        variant = CDataConversion::Convert(variant, 
                                           (DATA_FORMATS)m_lDataFormat,
                                           (DATA_FORMATS)m_lInitialDataFormat);
    }

    unsigned long ulOffset = pVarData->ArrayOffset();
    pVarData->ArrayOffset(m_lElement);

    // Call the instantiated CCommsSystemInterface derived class' 
    // WriteData member to update simulation.
    m_pCommsSystemInterface->WriteData(&variant, pVarData);

    pVarData->ArrayOffset(ulOffset);

    m_sync.Unlock();

    return LBU_OK;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CSCPTextCommsAction::OnUpdate()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : OnUpdate() is a common framework method for CAction
//                    derived classes.  Its purpose is to send a new value
//                    to its parent graphical widget.  OnUpdate should 
//                    generally be called by some other class than the parent 
//                    graphical element.
//
/////////////////////////////////////////////////////////////////////////////
void CSCPTextCommsAction::OnUpdate()
{
    m_sync.Lock();

    if (m_bDeleting == true)
    {
        m_sync.Unlock();
        return;
    }

    // Make sure there is a Variant will a value to send to the parent
    // graphical widget.
    if (m_pVariant == NULL)
    {
        m_sync.Unlock();
        return;
    }

    // Depending on the read_mode--read always, read changed, read never, 
    // or read_once-- update the parent graphical widget.  Also, if a read
    // has not been performed once and the read_mode is not read never, then
    // go ahead and get an initial value. 
    if (((m_bReadOnce    == true  && m_bRead == false) || 
         (m_bReadChanged == true  && m_pVariant->WasChanged(m_lElement) == true) || 
         (m_bReadAlways  == true) || 
         (m_bInitialRead == true)) && 
        (m_bReadOnce == true || m_bReadChanged == true || m_bReadAlways == true))
    {
        CString strElementVar   = CString(m_stlStrElementVar.c_str());
        CVariant variant        = (*m_pVariant)[m_lElement];

        // Run through any attached ranges to see if the current value is
        // in one of the ranges.
        int nRangeSize = m_vectRanges.size();
        if (nRangeSize > 0 && m_bUseGenericRange == true)
        {
            int nRangeStep = 0;
            bool bDone = false;
            while (nRangeStep < nRangeSize && bDone == false)
            {
                // Evaluate the range for the value pointed to by m_pVariant.
                if (m_vectRanges[nRangeStep]->Evaluate(variant) == true)
                {
                    // The range evaluated to true.  Reset m_ChangeValue to 
                    // match the range that was true.
                    m_ChangeValue.Text(m_vectRanges[nRangeStep]->TextTrue());
                    m_ChangeValue.Background(m_vectRanges[nRangeStep]->BackgroundTrue());
                    m_ChangeValue.Foreground(m_vectRanges[nRangeStep]->ForegroundTrue());
                    m_ChangeValue.TrueOrFalseValue(true);
                    bDone = true;
                }

                nRangeStep++;
            }

            if (bDone == false)
            {
                m_ChangeValue.TrueOrFalseValue(false);
            }
        }
        else if (m_bUseSpecificRange == true && m_pRange != NULL)
        {
            if (m_pRange->Evaluate(variant) == true)
            {
                // The range evaluated to true.  Reset m_ChangeValue to 
                // match the range that was true.
                m_ChangeValue.Text(m_pRange->TextTrue());
                m_ChangeValue.Background(m_pRange->BackgroundTrue());
                m_ChangeValue.Foreground(m_pRange->ForegroundTrue());
                m_ChangeValue.TrueOrFalseValue(true);
            }
            else
            {
                // The range evaluated to true.  Reset m_ChangeValue to 
                // match the range that was true.
                m_ChangeValue.Text(m_pRange->TextFalse());
                m_ChangeValue.Background(m_pRange->BackgroundFalse());
                m_ChangeValue.Foreground(m_pRange->ForegroundFalse());
                m_ChangeValue.TrueOrFalseValue(false);
            }
        }

        // Send the new value to the parent graphical widget.
        // m_bUseRange will tell the parent whether to use the m_pVariant
        // value of the data for colors and text.
        m_ChangeValue.Variant(&variant);
        m_ChangeValue.UseRange(m_bUseRange);

        CVariant varConverted;

        if (m_lElement > -1)
        {
            if (m_lDataFormat != m_lInitialDataFormat &&
                m_lDataFormat != Generic_No_Conversions)
            {
                varConverted = CDataConversion::Convert(variant, 
                                                        (DATA_FORMATS)m_lInitialDataFormat,
                                                        (DATA_FORMATS)m_lDataFormat);
                m_ChangeValue.Variant(&varConverted);
            }
        }

        bool bLimitFloating         = m_ChangeValue.Variant()->LimitFloating();
        unsigned char ucPrecision   = m_ChangeValue.Variant()->Precision();

        m_ChangeValue.Variant()->LimitFloating(m_bLimitFloating);
        m_ChangeValue.Variant()->Precision(m_ucPrecision);

        if (m_ChangeValue.UseRange() == true)
        {
            int size = __min(strlen(m_ChangeValue.Text().c_str()), 
                             m_SCPMain.m_nRowLength - m_exPtUpperLeft.X());

            memcpy(&m_SCPMain.m_cScreen[m_exPtUpperLeft.Y() * m_SCPMain.m_nRowLength + m_exPtUpperLeft.X()], 
                    m_ChangeValue.Text().c_str(), 
                    size);
        }
        else
        {
            int size = __min(strlen(((_FSI_STL::string)(*m_ChangeValue.Variant())).c_str()), 
                             m_SCPMain.m_nRowLength - m_exPtUpperLeft.X());

            memcpy(&m_SCPMain.m_cScreen[m_exPtUpperLeft.Y() * m_SCPMain.m_nRowLength + m_exPtUpperLeft.X()], 
                    ((_FSI_STL::string)(*m_ChangeValue.Variant())).c_str(), 
                    size);
        }

        // Reset the variant back to its previous state.
        m_ChangeValue.Variant()->LimitFloating(bLimitFloating);
        m_ChangeValue.Variant()->Precision(ucPrecision);

        // If this is a read once initializer, then mark as being read.
        if (m_bReadOnce == true)
        {
            m_bRead = true;
        }

        m_bInitialRead = false;
    }

    m_sync.Unlock();
}

void CSCPTextCommsAction::Value(const _FSI_STL::string& stlStrValue)
{
    m_variant.Value(stlStrValue);
}
