// SCPMain.h: interface for the SCPMain class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(_SCPMAIN_H_)
#define _SCPMAIN_H_

//#include "..\core\XMLParser5.h"
#include "XMLArchive.h"
#include "DataTransferInterface.h"
#include "SerialPortManager.h"
#include "ScpWidget.h"
#include "ScpImage.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

typedef std::map<int, std::string> int_to_str;


typedef std::pair<const std::string, const scp_event*> str_to_se_pair;
typedef std::multimap<const std::string, const scp_event*> str_to_se_multimap;
typedef str_to_se_multimap::iterator str_to_se_multimap_iter;

class SCPMain  
{
private:

	static int m_nRefreshRate;

//	static scp_dialog*	m_psdDialogHandler;

	static bool m_bDialogueActive;

	static int m_nDialogueCount;

	static int m_nDialogueOffset;

	static double m_dDialogueMax;
	
	static double m_dDialogueMin;

	static bool m_bDialogueRangeExists;

	static std::string m_strDialogueEntry;

	static serial_port_manager*		m_pspmSerialIO;

    static HANDLE           m_hPipeWrite;
    static HANDLE           m_hPipeRead;

    unsigned long int       m_ulRate;

    CWinThread*             m_pSCPThread;

    static UINT             ThreadFunc(LPVOID lParam);

	bool                    m_bStarted;

	static std::string m_strPageName;

	static std::string m_strPageNameN1;

	static std::string m_strPagePath;

	static sw_vec  m_psw_vecCurrentPageWidgets;

	//static std::map<std::string, sw_vec> m_str2psw_mapPageCache;

	static st_vec m_stvPageDomainText;

	static str_to_se_multimap m_semPageDomainSerialEvents;

	static str_to_st_map m_sttstmPageDomainDynamicText;

	static scp_image m_siCurrentImage;

	static std::string m_strCurrentTxImage;

	static int_to_str m_int_to_strButtonMap;

//	static str_vec m_strCommsWrite;

	static std::string m_strCurrentDialogueSymbol;

	static str_vec SCPMain::m_strvecDialogueCommands;

public:

	SCPMain();
	
	virtual ~SCPMain();

	void Stop();

    void Start();

	void MapButtonLabels(void);

	static void GetXMLArchive(std::string strPageName);

	static void VisitNestedScpWidgets(CXMLArchive& ar, CXMLNode* pNode);

	static void ScpPageSerialization(CXMLArchive& ar, CXMLNode* pNode);

	static void ScpWidgetSerialization(CXMLArchive& ar, CXMLNode* pNode);

	static void GetCommsDependancies(scp_text* pText, CXMLArchive& ar, CXMLNode* pNode);

	static void GetCommsDialogues(scp_event* pEvent, CXMLArchive& ar, CXMLNode* pNode);

	static void GetToggles(scp_event* pEvent, CXMLArchive& ar, CXMLNode* pNode);

	static void GetCommands(scp_event* pEvent, CXMLArchive& ar, CXMLNode* pNode);

	static void GetSelects(scp_event* pEvent, CXMLArchive& ar, CXMLNode* pNode);

	static void UpdateScreen(std::string strPageName);

	static void RefreshScreen(void);

	static void DialogueMode(void);

	static bool SerialPortInitialize(std::string strSerialPort, std::string strBaudRate, std::string strByteSize, std::string strParity, std::string strStopBits, std::string strBufferSize);

	static bool PageSettingInitialize(std::string strPagePath, std::string strFirstPage);

	static void SetRefreshRate(const int nRefreshRate);
};

#endif // !defined(_SCPMAIN_H_)
