/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : SCPMain.cpp
//
// Date             : 1 November 1999
//
// Engineer         : Michael F Lawson
//
// Revision         :
//
// Description      : 

// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : None.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3
//                                          Microsoft Windows NT 5.0
//
//                    Compiler(s) - Visual C++ 5.0 with VisC++ service pack 3
//                                  Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#include "SCPMain.h"
#include "SCPWidget.h"
#include "DataTransferinterface.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

HANDLE           SCPMain::m_hPipeWrite;
HANDLE           SCPMain::m_hPipeRead;

//IXMLDOMDocument *SCPMain::m_pXMLDoc;
//CXMLPage*        SCPMain::m_pXMLPage            = NULL;

//Pointer to serial port configuration and Read/Write wrapper.
serial_port_manager* SCPMain::m_pspmSerialIO=NULL;

sw_vec SCPMain::m_psw_vecCurrentPageWidgets;

st_vec SCPMain::m_stvPageDomainText;

str_to_se_multimap SCPMain::m_semPageDomainSerialEvents;

str_to_st_map SCPMain::m_sttstmPageDomainDynamicText;

scp_image SCPMain::m_siCurrentImage;

std::string SCPMain::m_strCurrentTxImage;

std::string SCPMain::m_strPagePath;

std::string SCPMain::m_strPageName;

std::string SCPMain::m_strPageNameN1;

int SCPMain::m_nRefreshRate;

//static scp_dialog*	m_psdDialogHandler=NULL;


bool SCPMain::m_bDialogueActive = false;

std::string SCPMain::m_strDialogueEntry = "";

int SCPMain::m_nDialogueCount = 0;

int SCPMain::m_nDialogueOffset = 0;

double SCPMain::m_dDialogueMax;

double SCPMain::m_dDialogueMin;

bool SCPMain::m_bDialogueRangeExists;

std::string SCPMain::m_strCurrentDialogueSymbol;

str_vec SCPMain::m_strvecDialogueCommands;

int_to_str SCPMain::m_int_to_strButtonMap;

SCPMain::SCPMain()
{
    m_pSCPThread    = NULL;
    m_bStarted      = false;
    m_ulRate        = 5;

    // Could create problems if more than one scpmain is created as
    // m_pXMLDoc is static.

    CoInitialize(NULL);
    //
    // Create an empty XML document
    //
/*    if (CoCreateInstance(CLSID_DOMDocument, NULL, CLSCTX_INPROC_SERVER,
                                IID_IXMLDOMDocument, (void**)&m_pXMLDoc) != S_OK)
    {
        m_pXMLDoc->Release(); 
        m_pXMLDoc = NULL;
        CoUninitialize();
    }
*/
    VARIANT_BOOL vb = VARIANT_FALSE;
/*
    if (m_pXMLDoc->put_validateOnParse(vb) != S_OK)
    {
        m_pXMLDoc->Release(); 
        m_pXMLDoc = NULL;
        CoUninitialize();
    }

    if (m_pXMLDoc->put_resolveExternals(vb) != S_OK)
    {
        m_pXMLDoc->Release(); 
        m_pXMLDoc = NULL;
        CoUninitialize();
    }

    if (m_pXMLDoc->put_async(vb) != S_OK)
    {
        m_pXMLDoc->Release(); 
        m_pXMLDoc = NULL;
        CoUninitialize();
    }
*/
	
	MapButtonLabels();
}

SCPMain::~SCPMain()
{
    // Clean up old file.
/*    if (m_pXMLPage != NULL)
    {
        delete m_pXMLPage;
        m_pXMLPage = NULL;
    }

    if (m_pXMLDoc != NULL)
    {
        m_pXMLDoc->Release(); 
        m_pXMLDoc = NULL;
        CoUninitialize();
    }
*/
	//clear comms. memory
	gbl_dtxiCommsIO.ClearPageVariables();

	//delete any pointers back to widgets
	m_stvPageDomainText.clear();
	m_semPageDomainSerialEvents.clear();
	m_sttstmPageDomainDynamicText.clear();

	//clear current page widgets from memory
	for(sw_vec_iter swviIter = m_psw_vecCurrentPageWidgets.begin();
					swviIter != m_psw_vecCurrentPageWidgets.end();
					swviIter++)
	{
		if(swviIter)delete *swviIter;
	}
	//clear pointers to current page widgets from memory
	m_psw_vecCurrentPageWidgets.clear();

	CoUninitialize();
}


void SCPMain::Start()
{
    m_pSCPThread = AfxBeginThread(ThreadFunc, 
                                  (LPVOID)m_ulRate,
                                  THREAD_PRIORITY_LOWEST,
                                  0, CREATE_SUSPENDED);

    CreatePipe(&m_hPipeRead, &m_hPipeWrite, NULL, 0);


    if (m_pSCPThread != NULL)
    {
        m_pSCPThread->m_bAutoDelete = false;

        m_pSCPThread->ResumeThread();

        m_bStarted = true;
    }
}

UINT SCPMain::ThreadFunc(LPVOID lParam)
{
	DWORD dwData = NULL;
	DWORD dwBytesRead = NULL;
	DWORD dwBytesLeft = NULL;
	DWORD dwBytesLeftMsg = NULL;
	DWORD dwDelay = 1000;

	if(m_nRefreshRate>0 && m_nRefreshRate<=10)
		dwDelay = dwDelay/m_nRefreshRate;
	else
		dwDelay = dwDelay/5;

	//initial page load and screen paint
	GetXMLArchive(m_strPagePath + m_strPageName);

	//if vector of widgets has a length
	if(m_psw_vecCurrentPageWidgets.size() > 0)
	{
		UpdateScreen(m_strPageName);
	}
	else
	{
		dwData=1;
		ASSERT(0);
	}

	// Central most update loop, looks for serial and/or comms. update triggers and calls appropriate
	// event handler.  Also receives shutdown message from "main app." via named pipe msg.
	for(;dwData!=1;)
    {
		// Check the pipe to see if a shutdown has been sent.
        PeekNamedPipe(m_hPipeRead, &dwData, sizeof(dwData), &dwBytesRead, &dwBytesLeft, &dwBytesLeftMsg);

		//buffer to put serial i/o in
		std::string strReadString;
		std::string strPageToLoad;
		
		//flag for new page load
		bool bUpdateScreenRequired(false);

		//Comport Read for SerialIO triggered event or dialog input
		if(m_pspmSerialIO->Read(strReadString))
		{
			if(!m_bDialogueActive)
			{
				int i((int)((const char)strReadString[0]));
				if(i>0)
				{
					//translate integer read from comport into search key
					if(m_int_to_strButtonMap.find(i) != m_int_to_strButtonMap.end())
					{
						std::string strKey = m_int_to_strButtonMap[i];

						//look up corresponding event in event map
						if(m_semPageDomainSerialEvents.find(strKey) != m_semPageDomainSerialEvents.end())
						{
							
							bool bDialogueRequired(false);

							// for all events with that key set flags and initialize screen actions
							// immediately take comms actions
							for(str_to_se_multimap_iter semmIter = m_semPageDomainSerialEvents.find(strKey);
														semmIter != m_semPageDomainSerialEvents.upper_bound(strKey);
														semmIter++)
							{
								scp_event* pEvent = (scp_event*)(*semmIter).second;
								
								if((pEvent)->HasPageLink())
								{
									strPageToLoad = pEvent->SerialKeyUpdate();
									bUpdateScreenRequired=true;
									//UpdateScreen(strPageToLoad);
								}
								else if(pEvent->HasDialogue())
								{
									m_strvecDialogueCommands = pEvent->BuildDialogueDrawCommands();
									
									//m_psdDialogHandler = new scp_dialog(pEvent->GetTitle(), pEvent->GetMax(), pEvent->GetMin());

									m_strCurrentDialogueSymbol = pEvent->GetSymbolName();
									m_dDialogueMax = pEvent->GetMax();
									m_dDialogueMin = pEvent->GetMin();
									if(m_dDialogueMax<m_dDialogueMin)
									{
										double dTemp = m_dDialogueMax;
										m_dDialogueMax = m_dDialogueMin;
										m_dDialogueMin = dTemp;
									}

									m_bDialogueRangeExists=false;
									if(m_dDialogueMax-m_dDialogueMin>0)
									{
										m_bDialogueRangeExists = true;
									}

									strPageToLoad = m_strPageName;
									
									bUpdateScreenRequired=true;
									//UpdateScreen(strPageToLoad);
									
									bDialogueRequired=true;
									//DialogueMode();
								}
								else if(pEvent->HasToggle())
								{
									std::string strSymbolToToggle(pEvent->GetSymbolName());
									std::string strVal;
									if(gbl_dtxiCommsIO.Read(strSymbolToToggle, strVal))
									{
										std::string strOn("1");
										std::string strOff("0");

                              const int nOn(1);
                              const int nOff(0);

                              int nVal(atol(strVal.c_str()));
										
										/*if(strVal==strOff)
										{
											gbl_dtxiCommsIO.Write(pEvent->GetSymbolName(), strOn);
										}
										else if(strVal==strOn)
										{
											gbl_dtxiCommsIO.Write(pEvent->GetSymbolName(), strOff);
										}*/

                              switch(nVal){
                                 case nOn:{
                                    gbl_dtxiCommsIO.Write(pEvent->GetSymbolName(), strOff);
                                 }break;

                                 case nOff:{
                                    gbl_dtxiCommsIO.Write(pEvent->GetSymbolName(), strOn);
                                 }break;
                              }
									}
								}
								else if(pEvent->HasSelect())
								{
									std::string strSymbolToCommand(pEvent->GetSymbolName());
									std::string strValueToWrite(pEvent->GetCommandValue());
									gbl_dtxiCommsIO.Write(strSymbolToCommand, strValueToWrite);
									
									if(pEvent->IsModal())
									{
										strPageToLoad=m_strPageName;
										bUpdateScreenRequired=true;
										//UpdateScreen(strPageToLoad);
									}
									else	
									{
										strPageToLoad=m_strPageNameN1;
										bUpdateScreenRequired=true;
										//UpdateScreen(strPageToLoad);
									}

								}
								else if(pEvent->HasCommand())
								{
									std::string strSymbolToCommand(pEvent->GetSymbolName());
									std::string strValueToWrite(pEvent->GetCommandValue());
									gbl_dtxiCommsIO.Write(strSymbolToCommand, strValueToWrite);
								}
							}//end for

							//perform screen update actions
							if(bUpdateScreenRequired)
							{
								UpdateScreen(strPageToLoad);
							}

							if(bDialogueRequired)
							{
								DialogueMode();
							}
						}
						else
						{
							//numeric entry unsupported on this page ... but exists in command map
							//UpdateScreen(m_strPageName);
							strPageToLoad = m_strPageName;

							if(bUpdateScreenRequired)
							{
								UpdateScreen(strPageToLoad);
							}
						}
					}
					else
					{
						//entry unsupported by current command map
						UpdateScreen(m_strPageName);
					}
					
				}
				else
				{
					//non-numeric bogus entry
					UpdateScreen(m_strPageName);
				}
			}
			else
			{
				//let dialog handler deal with input
				//m_psdDialogHandler->Update(strReadString);

				int nCurrentInput = (int)((const char)strReadString[0]);
				switch(nCurrentInput)
				{
					case 13://ok
					{
						m_bDialogueActive=false;
						
				
						if(m_nDialogueCount>0)
						{
							double dTemp = atof(m_strDialogueEntry.c_str());
							if(dTemp>=m_dDialogueMin && dTemp<=m_dDialogueMax)
							{
								gbl_dtxiCommsIO.Write(m_strCurrentDialogueSymbol, m_strDialogueEntry);
							}
						}
						
						m_nDialogueCount=0;
						m_strDialogueEntry="";
						m_strCurrentDialogueSymbol="";
						m_strvecDialogueCommands.clear();

						UpdateScreen(m_strPageName);			
					}
					break;

					case 88://.
					{
						if(m_nDialogueCount < m_strDialogueEntry.length())
						{
							m_strDialogueEntry.insert(m_nDialogueCount, ".");
						}
						else
						{
							m_strDialogueEntry += strReadString;
						}
						
						m_nDialogueCount = m_strDialogueEntry.length();
					}
					break;

					case 89://apply
					case 34:
					{
						
						if(m_nDialogueCount>0)
						{
							double dTemp = atof(m_strDialogueEntry.c_str());
							if(dTemp>=m_dDialogueMin && dTemp<=m_dDialogueMax)
							{
								gbl_dtxiCommsIO.Write(m_strCurrentDialogueSymbol, m_strDialogueEntry);
							}
						}
						
						m_nDialogueCount=0;
						m_strDialogueEntry="";
						DialogueMode();
					}
					break;

					case 27:
					case 90://cancel
					{
						m_bDialogueActive=false;
						m_nDialogueCount=0;
						m_strDialogueEntry="";
						m_strCurrentDialogueSymbol="";
						m_strvecDialogueCommands.clear();
						
						UpdateScreen(m_strPageName);
					}
					break;

					case 32://backspace
					{
						if(m_nDialogueCount>0)
						{
							m_nDialogueCount--;
							
							if(m_nDialogueCount < m_strDialogueEntry.length())
							{
								std::string strTemp = m_strDialogueEntry.substr(0, m_nDialogueCount);
								strTemp += m_strDialogueEntry.substr(m_nDialogueCount + 1, m_strDialogueEntry.length());
								m_strDialogueEntry = strTemp;
							}
							else
							{
								m_strDialogueEntry = m_strDialogueEntry.substr(0, m_strDialogueEntry.length() - 1);
							}
							DialogueMode();
						}
					}
					break;

					case 72:
					case 70:// H or F interpreted as -
					{
						if(m_strDialogueEntry.length()==0)
						{
							m_strDialogueEntry = "-";
							m_nDialogueCount++;
						}
					}
					break;

					//left
					case 60:
					case 68:
					{
						if(m_strDialogueEntry.length()>0 && m_nDialogueCount>0)
						{
							m_nDialogueCount--;
						}
					}
					break;

					//right
					case 62:
					case 69:
					{
						if(m_strDialogueEntry.length()>0)
						{
							m_nDialogueCount++;
						}
					}
					break;

					default://alphanumeric
					{
						if(m_nDialogueCount < m_strDialogueEntry.length())
						{
							m_strDialogueEntry.insert(m_nDialogueCount, strReadString);
						}
						else
						{
							m_strDialogueEntry += strReadString;
							m_nDialogueCount = m_strDialogueEntry.length();
						}
					}
					break;
				}
			}
		}
		else if(m_bDialogueActive)
		{
			//dialog is active so refresh dialog on the screen
			std::string strTemp;
			//m_psdDialogHandler->Refresh(strTemp);
			strTemp = "\033[16;0H\033[4t";
			std::string strOffset = "          >";
			m_nDialogueOffset = strOffset.length() + 1;
			strTemp += strOffset;
			strTemp += m_strDialogueEntry;			
		
			m_pspmSerialIO->Write(strTemp.c_str());			
		}

		//refresh comms dependant widget text on screen (irrespective of dialog and event triggers)
		RefreshScreen();
		
		//refresh rate delay
		Sleep(dwDelay);

    }//end of for

    CloseHandle(m_hPipeRead);

    return 0;
}

void SCPMain::Stop()
{
    // Stop listening/reading.
    if (m_pSCPThread != NULL)
    {
        // The comms thread will not auto delete itself because it should
        // run until the comms library is unloaded.  Thus, the comms thread
        // must be deleted.
        DWORD dwData = 1;
        DWORD dwBytesWritten;

        WriteFile(m_hPipeWrite, &dwData, sizeof(dwData), &dwBytesWritten, NULL);
        CloseHandle(m_hPipeWrite);

        WaitForSingleObject(m_pSCPThread->m_hThread, INFINITE);
        delete m_pSCPThread;
    }

	//delete the serial io manager after this thread is quiet.
	delete m_pspmSerialIO;


    m_bStarted = false;
}

void SCPMain::MapButtonLabels(void)
{
	//1-9
	char szTemp[10];
	szTemp[9]='\0';
	
	for(int n=0; n<10; n++)
	{
		itoa(n, szTemp, 10);
		m_int_to_strButtonMap[n+48] = szTemp;
	}

	//F1-F5
	m_int_to_strButtonMap[17]="F1";
	m_int_to_strButtonMap[18]="F2";
	m_int_to_strButtonMap[19]="F3";
	m_int_to_strButtonMap[20]="F4";
	m_int_to_strButtonMap[21]="F5";
}

void SCPMain::GetXMLArchive(std::string strPageName)
{
	CXMLArchive ar(strPageName.c_str(), CArchive::load);

	if (! ar.LoadDocument())
	{
		return;
	}
		
	CXMLNode *pRoot = ar.SelectNode(NULL, L"ScpPage");
	
	std::string strTitle;
	ar  >> CNamedAttribute<std::string>(*pRoot, L"Title", strTitle);
	m_siCurrentImage.m_strCurrentPageTitle = strTitle;

	VisitNestedScpWidgets(ar, pRoot);

	delete pRoot;
}

void SCPMain::VisitNestedScpWidgets(CXMLArchive& ar, CXMLNode* pNode)
{
	CXMLNodeList listNestedNodes(pNode);
	int nNumNestedNodes = listNestedNodes.Length();

	for(int j=0; j < nNumNestedNodes; j++)
	{
		CXMLNode *pAttr = listNestedNodes[j];
		//serialize ScpWidget nodes
		ScpPageSerialization(ar, pAttr);
		delete pAttr;
	}
}

void SCPMain::ScpPageSerialization(CXMLArchive& ar, CXMLNode* pNode)
{
	_bstr_t bsNodeName;

	if(pNode->GetName(bsNodeName))
	{
		std::string csNodeName(bsNodeName);

		if(csNodeName == "ScpWidget")
		{
			ScpWidgetSerialization(ar, pNode);	
		}
	}
}

void SCPMain::ScpWidgetSerialization(CXMLArchive& ar, CXMLNode* pNode)
{
	CXMLNodeList listNestedNodes(pNode);
	int nNumNestedNodes = listNestedNodes.Length();
	bool bTextSerialized=true;
	bool bEventSerialized=true;
	
	scp_widget* pscpwNewScpWidget = new scp_widget();

	for(int j=0; j < nNumNestedNodes; j++)
	{
		//Add text params to widget
		CXMLNode *pAttr = listNestedNodes[j];
		_bstr_t bsSubNodeName;
		if(pAttr->GetName(bsSubNodeName))
		{
			std::string csSubNodeName(bsSubNodeName);

			if		(csSubNodeName == "ScpText")
			{
				bTextSerialized=false;
				std::string strx;
				std::string stry;
				std::string strX;
				std::string strY;
				std::string strFormatString;
				std::string strStaticText;
				std::string strType;
				std::string strWidth;
				std::string strPrecision;

				ar  >> CNamedAttribute<std::string>(*pAttr, L"x", strx)
					>> CNamedAttribute<std::string>(*pAttr, L"y", stry)
					>> CNamedAttribute<std::string>(*pAttr, L"X", strX)
					>> CNamedAttribute<std::string>(*pAttr, L"Y", strY) 
					>> CNamedAttribute<std::string>(*pAttr, L"StaticText", strStaticText)
					>> CNamedAttribute<std::string>(*pAttr, L"Type", strType)
					>> CNamedAttribute<std::string>(*pAttr, L"Width", strWidth)
					>> CNamedAttribute<std::string>(*pAttr, L"Precision", strPrecision); 

				scp_text* pNewText = new scp_text(atoi(strx.c_str()), atoi(stry.c_str()), atoi(strX.c_str()), atoi(strY.c_str()), strStaticText, strType, strWidth, strPrecision);
				
				//look for comms. dependancies
				GetCommsDependancies(pNewText, ar, pAttr);
					
				bTextSerialized = pscpwNewScpWidget->AddText(pNewText);
				delete pNewText;
			}
			else if	(csSubNodeName == "ScpEvent")
			{
				bEventSerialized=false;

				std::string strButtonLabel;
				std::string strType;
				std::string strName;
				std::string strScope;

				//Add text params to widget
				ar  >> CNamedAttribute<std::string>(*pAttr, L"Scope", strScope)
					>> CNamedAttribute<std::string>(*pAttr, L"Type", strType)
					>> CNamedAttribute<std::string>(*pAttr, L"Name", strName)
					>> CNamedAttribute<std::string>(*pAttr, L"ButtonLabel", strButtonLabel);


				//Add event params to widget
				scp_event* pNewEvent = new scp_event(strScope, strType, strName, strButtonLabel);
				
				//look for dialogues
				GetCommsDialogues(pNewEvent, ar, pAttr);

				//look for comms. 
				GetToggles(pNewEvent, ar, pAttr);

				//look for commands
				GetCommands(pNewEvent, ar, pAttr);

				GetSelects(pNewEvent, ar, pAttr);

				bEventSerialized = pscpwNewScpWidget->AddEvent(pNewEvent);
				delete pNewEvent;
			}
		}
		
		delete pAttr;
	}

	//per widget if a text or event tries first and fails don't load it ...
	if(bTextSerialized && bEventSerialized)
	{
		m_psw_vecCurrentPageWidgets.push_back(pscpwNewScpWidget);
	}
	else
	{
		delete pscpwNewScpWidget;
	}
}

void SCPMain::GetCommsDependancies(scp_text* pText, CXMLArchive& ar, CXMLNode* pNode)
{
	CXMLNodeList listNestedNodes(pNode);
	int nNumNestedNodes = listNestedNodes.Length();

	for(int j=0; j < nNumNestedNodes; j++)
	{
		//Add text params to widget
		CXMLNode *pAttr = listNestedNodes[j];
		_bstr_t bsSubNodeName;
		if(pAttr->GetName(bsSubNodeName))
		{
			std::string csSubNodeName(bsSubNodeName);

			if		(csSubNodeName == "CommsDisplay")
			{
				std::string strSymbolName;
				ar >>  CNamedAttribute<std::string>(*pAttr, L"Name", strSymbolName);

				//make this an actual typecast to comms dependent display text
				gbl_dtxiCommsIO.RegisterPageVariable(strSymbolName, pText->GetDatatype());
				
				pText->AddCommsDisplay(strSymbolName);
			}
		}
	
		delete pAttr;
	}
}

void SCPMain::GetCommsDialogues(scp_event* pEvent, CXMLArchive& ar, CXMLNode* pNode)
{
	CXMLNodeList listNestedNodes(pNode);
	int nNumNestedNodes = listNestedNodes.Length();

	for(int j=0; j < nNumNestedNodes; j++)
	{
		//Add text params to widget
		CXMLNode *pAttr = listNestedNodes[j];
		_bstr_t bsSubNodeName;
		if(pAttr->GetName(bsSubNodeName))
		{
			std::string csSubNodeName(bsSubNodeName);

			std::string strTitle;
			std::string strRangeMin;
			std::string strRangeMax;
			std::string strSymbolName;
			std::string strType;

			if(csSubNodeName == "CommsDialogue")
			{
				std::string strSymbolName;
				ar	>>  CNamedAttribute<std::string>(*pAttr, L"Title", strTitle)
					>>  CNamedAttribute<std::string>(*pAttr, L"Symbol", strSymbolName)
					>>  CNamedAttribute<std::string>(*pAttr, L"Min", strRangeMin)
					>>  CNamedAttribute<std::string>(*pAttr, L"Max", strRangeMax)
					>>  CNamedAttribute<std::string>(*pAttr, L"Type", strType);
				
				gbl_dtxiCommsIO.RegisterWriteVariable(strSymbolName, atol(strType.c_str()));
				pEvent->AddDialogue(strTitle, strSymbolName, strRangeMin, strRangeMax, strType);
			}
		}
	
		delete pAttr;
	}
}

void SCPMain::GetToggles(scp_event* pEvent, CXMLArchive& ar, CXMLNode* pNode)
{
	CXMLNodeList listNestedNodes(pNode);
	int nNumNestedNodes = listNestedNodes.Length();

	for(int j=0; j < nNumNestedNodes; j++)
	{
		//Add text params to widget
		CXMLNode *pAttr = listNestedNodes[j];
		_bstr_t bsSubNodeName;
		if(pAttr->GetName(bsSubNodeName))
		{
			std::string csSubNodeName(bsSubNodeName);
			std::string strSymbolName;

			if(csSubNodeName == "Toggle")
			{
				std::string strSymbolName;
				std::string strType("4");
				
				ar	>>  CNamedAttribute<std::string>(*pAttr, L"Symbol", strSymbolName);

				gbl_dtxiCommsIO.RegisterWriteVariable(strSymbolName, atoi(strType.c_str()));
				gbl_dtxiCommsIO.RegisterPageVariable(strSymbolName, atoi(strType.c_str()));
				pEvent->AddToggle(strSymbolName, strType);
			}
		}
	
		delete pAttr;
	}
}

void SCPMain::GetCommands(scp_event* pEvent, CXMLArchive& ar, CXMLNode* pNode)
{
	CXMLNodeList listNestedNodes(pNode);
	int nNumNestedNodes = listNestedNodes.Length();

	for(int j=0; j < nNumNestedNodes; j++)
	{
		//Add text params to widget
		CXMLNode *pAttr = listNestedNodes[j];
		_bstr_t bsSubNodeName;
		if(pAttr->GetName(bsSubNodeName))
		{
			std::string csSubNodeName(bsSubNodeName);
			std::string strSymbolName;

			if(csSubNodeName == "Command")
			{
				std::string strSymbolName;
				std::string strValue;
				std::string strDataType("4");
				std::string strMode;
				
				ar	>>  CNamedAttribute<std::string>(*pAttr, L"Symbol", strSymbolName)
					>>  CNamedAttribute<std::string>(*pAttr, L"Value", strValue)
					>>  CNamedAttribute<std::string>(*pAttr, L"Type", strDataType);

				gbl_dtxiCommsIO.RegisterWriteVariable(strSymbolName, atoi(strDataType.c_str()));
				pEvent->AddCommand(strSymbolName, strValue, strDataType);
			}
		}
	
		delete pAttr;
	}
}

void SCPMain::GetSelects(scp_event* pEvent, CXMLArchive& ar, CXMLNode* pNode)
{
	CXMLNodeList listNestedNodes(pNode);
	int nNumNestedNodes = listNestedNodes.Length();

	for(int j=0; j < nNumNestedNodes; j++)
	{
		//Add text params to widget
		CXMLNode *pAttr = listNestedNodes[j];
		_bstr_t bsSubNodeName;
		if(pAttr->GetName(bsSubNodeName))
		{
			std::string csSubNodeName(bsSubNodeName);
			std::string strSymbolName;

			if(csSubNodeName == "Select")
			{
				std::string strSymbolName;
				std::string strValue;
				std::string strDataType("4");
				std::string strModal;
				
				ar	>>  CNamedAttribute<std::string>(*pAttr, L"Symbol", strSymbolName)
					>>  CNamedAttribute<std::string>(*pAttr, L"Value", strValue)
					>>  CNamedAttribute<std::string>(*pAttr, L"Type", strDataType)
					>>  CNamedAttribute<std::string>(*pAttr, L"Modal", strModal);

				gbl_dtxiCommsIO.RegisterWriteVariable(strSymbolName, atoi(strDataType.c_str()));
				pEvent->AddSelect(strSymbolName, strValue, strDataType, strModal);
			}
		}
	
		delete pAttr;
	}
}

void SCPMain::UpdateScreen(std::string strPageName)
{ 
	for(sw_vec_iter swviIter = m_psw_vecCurrentPageWidgets.begin();
					swviIter != m_psw_vecCurrentPageWidgets.end();
					swviIter++)
	{
		if(swviIter)delete *swviIter;
	}
	m_psw_vecCurrentPageWidgets.clear();

	gbl_dtxiCommsIO.ClearPageVariables();
	//load default scp page as vector of widgets
	GetXMLArchive(m_strPagePath + strPageName);

	//if vector of widgets has a length
	if(m_psw_vecCurrentPageWidgets.size() > 0)
	{
		m_strPageNameN1 = m_strPageName;
		m_strPageName = strPageName;
	}
	else
	{
		//load default scp page as vector of widgets
		gbl_dtxiCommsIO.ClearPageVariables();
		GetXMLArchive(m_strPagePath + m_strPageName);

		if(m_psw_vecCurrentPageWidgets.size()<0)
		{
			ASSERT(0);
		}
	}
		
	m_stvPageDomainText.clear();
	m_semPageDomainSerialEvents.clear();
	m_sttstmPageDomainDynamicText.clear();
	
	//Use the new vector of scp_widgets to populate the scp_event vector and scp_text vector.
	for(swviIter = m_psw_vecCurrentPageWidgets.begin(); 
		swviIter != m_psw_vecCurrentPageWidgets.end(); 
		swviIter++)
	{
		// If this widget has an scp_text member loaded, 
		if((*swviIter)->HasText())
		{
			m_stvPageDomainText.push_back((*swviIter)->GetText());

			// Use text scp_text vector elements to populate a map of "comms event" 
			// dependant scp_text instances.
			if(m_stvPageDomainText[m_stvPageDomainText.size()-1]->IsCommsDependant())
			{
				std::string strKey(m_stvPageDomainText[m_stvPageDomainText.size()-1]->GetCommsKey());
				if(strKey.length())
				{
					m_sttstmPageDomainDynamicText[strKey] = m_stvPageDomainText[m_stvPageDomainText.size()-1];
				}
				else
				{
					ASSERT(0);
				}
			}
		}

		// If this widget has an scp_event member loaded,
		scp_event* pEvent = (*swviIter)->GetEvent();
		if(	pEvent->HasPageLink() || 
			pEvent->HasDialogue() ||
			pEvent->HasToggle()	||
			pEvent->HasCommand() ||
			pEvent->HasSelect()
			)
		{
			//create a pair to put in the multimap
			std::string strKey = pEvent->GetSerialEventKey();
			str_to_se_pair semmPair(strKey, pEvent);
			
			//this iterator will hint to put the next insert as the last of this key
			str_to_se_multimap_iter semmIter = m_semPageDomainSerialEvents.upper_bound(strKey);
			m_semPageDomainSerialEvents.insert(semmIter, semmPair);

			//m_semPageDomainSerialEvents[strKey] = (*swviIter)->GetEvent();
		}
	}

	//convert parsed widgets into image
	m_siCurrentImage.AddWidgetVector(m_psw_vecCurrentPageWidgets);

	//get vector of write strings (one string per widget on current page)
	std::vector<std::string> strvecTemp = m_siCurrentImage.GetAsSerialTxBuffer();
	
	//move cursor to last pixel // and turn off blink 
	std::string strNoBlink("\033[16;10f\033[5t");
	strvecTemp.push_back(strNoBlink);

	//iterate through vector of write strings and send them to scp
	for(std::vector<std::string>::iterator	strvecIter = strvecTemp.begin();
											strvecIter != strvecTemp.end();
											strvecIter++)
	{
		m_strCurrentTxImage = *strvecIter;
		m_pspmSerialIO->Write(m_strCurrentTxImage.c_str());
	}
}

void SCPMain::RefreshScreen(void)
{
	std::string strFormattedValue;
	int i=0;

	//for all scp_text instances on the current screen,
	for(st_vec_iter stvIter = m_stvPageDomainText.begin(); 
					stvIter != m_stvPageDomainText.end(); 
					stvIter++)
	{
		if((*stvIter)->IsCommsDependant())
		{
			std::string strVarName((*stvIter)->GetCommsKey());
			char chSwitchKey = (*stvIter)->GetDatatype();
			strFormattedValue="";
			std::string strVal;

			if(gbl_dtxiCommsIO.Read(strVarName, strVal))
			{
				if(strVal.length() > 0)
				{
					switch(chSwitchKey)
					{	
						case 'a'://this will associate string to string eg: 0=Off,1=On,n=N
						{
							strFormattedValue = (*stvIter)->GetAssociatedText(strVal);
						}
						break;

						case 'h'://this will check for active state and highlight widget
						{
							strFormattedValue = (*stvIter)->Highlight(strVal);
						}
						break;

						case 'f':
						{
							CString csTemp;
							std::string strTemp;
							
							std::string strWidth;
							(*stvIter)->GetWidth(strWidth);
														
							std::string strPrecision;
							(*stvIter)->GetPrecision(strPrecision);
							
							strTemp += "%" + strWidth + "." + strPrecision + "f";
										
							csTemp.Format(strTemp.c_str() , atof(strVal.c_str()));
							strFormattedValue = csTemp;
						}
						break;


						case 'd':
						{
							CString csTemp;
							std::string strTemp;
							
							std::string strWidth;
							(*stvIter)->GetWidth(strWidth);
							
							strTemp = "%" + strWidth + "d";

							csTemp.Format(strTemp.c_str() , atol(strVal.c_str()));	
							strFormattedValue = csTemp;
						}
						break;

						case 's':
						{
							strFormattedValue += strVal;
						}
						break;

						default:
						{
							strFormattedValue += strVal;
						}
						break;

					}

					// if some data was read and formatted
					if(strFormattedValue.length() >= 1)
					{
						std::string strTemp;
						char szTemp[10];

						int nLeft, nTop, nRight, nBottom;

						(*stvIter)->GetTopLeft(nLeft, nTop);
						(*stvIter)->GetBottomRight(nRight, nBottom);

						//determine x cursor position
						int nWidth;
						int nJustifiedX;

						switch(chSwitchKey)
						{
							case 'f':
							{
								nWidth = (*stvIter)->GetWidth() + (*stvIter)->GetPrecision() + 1;
								
								if(strFormattedValue.length() >= nWidth)
								{
									nJustifiedX = nRight - nWidth;
								}
								else
								{
									nJustifiedX = nRight - nWidth + (nWidth - strFormattedValue.length());
								}
							}
							break;

							case 's':
							{
								nJustifiedX = (nRight - strFormattedValue.length()) + 1;
							}
							break;

							case 'd':
							{
								nJustifiedX = nRight - (*stvIter)->GetWidth();
							}
							break;

							case 'a':
							case 'h':
							{
								nJustifiedX = nRight - strFormattedValue.length();
							}
							break;
						}

						//clip string if necessary
						int nDifference = (nRight - strFormattedValue.length()) - nJustifiedX;
						if(nDifference>0)
						{
							std::string strTemp = strFormattedValue.substr(0, strFormattedValue.length() - nDifference);
							strFormattedValue = strTemp;
						}

						itoa(nJustifiedX, szTemp, 10);
						std::string strX(szTemp);

						//determine y cursor position
						itoa(nTop, szTemp, 10);
						std::string strY(szTemp);

						//position cursor string + filtered data
						strTemp = "\033[" + strY + ";" + strX + "f" + strFormattedValue;

						//write to serial port
						m_pspmSerialIO->Write(strTemp.c_str());
					}
				}
			}
		}
		i++;
	}

	if(m_bDialogueActive)
	{
		//move cursor to current data input location and turn on blink
		char szTemp[] = {'\0'};
	
		itoa(m_nDialogueCount + m_nDialogueOffset, szTemp, 10);
		std::string strXOffset(szTemp);
		std::string strDialogueCursor;
		strDialogueCursor = "\033[16;" + strXOffset + "f\033[4t";
		m_pspmSerialIO->Write(strDialogueCursor.c_str());
	}
	else
	{
		//move cursor to last pixel and turn off blink
		std::string strNoBlink("\033[16;0f\033[5t");
		m_pspmSerialIO->Write(strNoBlink.c_str());
	}
}

void SCPMain::DialogueMode(void)
{
	int i=0;

	std::string strTemp("\033[14;0H\033[J");
	//erase bottom 3 lines to make room for dialogue
	m_pspmSerialIO->Write(strTemp.c_str());

	for(str_vec_iter sviIter = m_strvecDialogueCommands.begin(); sviIter != m_strvecDialogueCommands.end(); sviIter++)
	{
		std::string strTemp;
		if(i==0)
		{
			strTemp = "\033[14;3H";
		}
		else if(i==1)
		{
			strTemp = "\033[15;3H";
		}
		else if(i==2)
		{
			strTemp = "\033[16;3H\033[4t";			
		}

		strTemp	+= *sviIter;
		m_pspmSerialIO->Write(strTemp.c_str());
		i++;
	}

	m_bDialogueActive=true;
	//m_psdDialogHandler = new scp_dialog();
}

bool SCPMain::PageSettingInitialize(std::string strPagePath, std::string strPageName)
{
	m_strPagePath=strPagePath;

	m_strPageName=strPageName;

	if(strPagePath.substr(strPagePath.length(), strPagePath.length()) != "\\")
	{
		strPagePath += "\\";
	}

	std::string strFirstPageTest = strPagePath + strPageName;

	FILE * fpFirstPageTest=NULL;
	fpFirstPageTest = fopen(strFirstPageTest.c_str(), "r");
	if(fpFirstPageTest)
	{
		m_strPagePath = strPagePath;
		fclose(fpFirstPageTest);
		return true;
	}

	return false;
}

bool SCPMain::SerialPortInitialize(std::string strSerialPort, std::string strBaudRate, std::string strByteSize, std::string strParity, std::string strStopBits, std::string strBufferSize)
{
	m_pspmSerialIO = new serial_port_manager(strSerialPort, strBaudRate, strByteSize, strParity, strStopBits, strBufferSize);
	return m_pspmSerialIO->Initialize();
}

void SCPMain::SetRefreshRate(const int nRefreshRate)
{
	m_nRefreshRate = nRefreshRate;
}