/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : SCPComponentInterface.h
//
// Date             : 19 October 1998
//
// Engineer         : Billy Baker
//
// Revision         :
//
// Description      : SCPComponentInterface.h contains the definition 
//                    of the CSCPComponentInterface class.  Also, it 
//                    implements the ComponentInterface method which is 
//                    exported so that the framework may get a pointer 
//                    to an instance of the class derived from 
//                    CComponentInterface.  
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : None.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3
//                                          Microsoft Windows NT 5.0
//
//                    Compiler(s) - Visual C++ 5.0 with VisC++ service pack 3
//                                  Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _SCPCOMPONENTINTERFACE_H_
#define _SCPCOMPONENTINTERFACE_H_

#include "..\core\ComponentInterface.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class SCPMain;

class CSCPComponentInterface : public CComponentInterface  
{
private:
    static const char m_cRevisionDate[];
    static const char m_cRevisionTime[];
protected:
    SCPMain*          m_pSCPMain;
    virtual void      InitializeComponentConfig();

public:
    explicit CSCPComponentInterface(_FSI_STL::string stlStrPathName = 
                                                   _FSI_STL::string("Unknown"));
    virtual ~CSCPComponentInterface();

	virtual std::string GetRegistryString(const HKEY hKey, const std::string strQueryName);

    virtual void CleanComponentResources();
};

#ifdef __cplusplus
extern "C"
{
#endif // __cplusplus

/////////////////////////////////////////////////////////////////////////////
//
// __declspec(dllexport) bool ComponentInterface()
//
// Inputs           : CComponentInterface*& rpCI - a reference to a 
//                    pointer to a CComponentInterface instance or an 
//                    instance of a class derived from CComponentInterface.
//
// Return Values    : true - the instance of the component interface 
//                           was created.
//                    false - the instance of the component interface was
//                            not created.
//
// Date             : 19 October 1998
//
// Engineer         : Billy Baker
//
// Description      : ComponetInterface is the lone exported function 
//                    from the DLL.  Its purpose is to create an 
//                    instance of the class derived from 
//                    CComponentInterface that is implemented in the 
//                    library that contains this ComponentInterface 
//                    method.  The return value indicates the success 
//                    or failure of the new operation.
//
/////////////////////////////////////////////////////////////////////////////
__declspec(dllexport) bool ComponentInterface(CComponentInterface*& rpCI,
                                              _FSI_STL::string stlStrPathName)
{
    bool bRetVal = true;
    rpCI = new CSCPComponentInterface(stlStrPathName);

    if (rpCI == NULL)
        bRetVal = false;
    
    return bRetVal;
}

#ifdef __cplusplus
}
#endif // __cplusplus

#endif // #ifndef _MALFEDITORCOMPONENTINTERFACE_H_
