/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : SCPComponentInterface.cpp
//
// Date             : 19 October 1998
//
// Engineer         : Billy Baker
//
// Revision         :
//
// Description      : CSCPComponentInterface is derived from 
//                    CComponentInterface.  CComponentInterface is the 
//                    contract that all plugin components to the 
//                    framework must implement in the form of a derived 
//                    class.  See the information in 
//                    CComponentInterface for more information.  
//                    CSCPComponentInterface is used for the Sortieunction
//                    editor library of controls and option pages.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : None.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3
//                                          Microsoft Windows NT 5.0
//
//                    Compiler(s) - Visual C++ 5.0 with VisC++ service pack 3
//                                  Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
//4-20-2000 Adding Comms function availability functions based on similar
//			implementation in "Autotest class".
/////////////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#include "SCPComponentInterface.h"
#include "SCPConfigPage.h"
#include "SCPMain.h"
#include "..\fsisuite\product_version.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// The following static members contain the date and time of the last
// compilation of this class.
const char CSCPComponentInterface::m_cRevisionDate[] = __DATE__;
const char CSCPComponentInterface::m_cRevisionTime[] = __TIME__;

#include "DataTransferInterface.h"
data_transfer_interface gbl_dtxiCommsIO;

//CALLBACK per comms cycle calls into data transfer interface class
void UpdateDTI()
{
	gbl_dtxiCommsIO.Update();
}

/////////////////////////////////////////////////////////////////////////////
//
// CSCPComponentInterface::CSCPComponentInterface()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 19 October 1998
//
// Engineer         : Billy Baker
//
// Description      : This is the default constuctor for this class.  It 
//                    initializes the map of option pages, initializes 
//                    the string with the date and time of compilation, 
//                    and initializes the name of the component.
//
/////////////////////////////////////////////////////////////////////////////
CSCPComponentInterface::CSCPComponentInterface(_FSI_STL::string stlStrPathName) :
                    CComponentInterface(_FSI_STL::string("Simulation Control Panel"),
                                        stlStrPathName)
{
    _FSI_STL::string stlStrDate(m_cRevisionDate);
    _FSI_STL::string stlStrTime(m_cRevisionTime);

    m_stlStrDate = stlStrDate + " " + stlStrTime;

//    m_listPropPages.push_back(CSCPConfigPage::CreateObject);

    m_pSCPMain = NULL;
}

/////////////////////////////////////////////////////////////////////////////
//
// CSCPComponentInterface::~CSCPComponentInterface()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 19 October 1998
//
// Engineer         : Billy Baker
//
// Description      : This is the default destructor for this class.  It 
//                    does not need to delete the option pages since 
//                    they are attached to a window when they are 
//                    created and will be delete when that window is 
//                    destroyed.  The pointers in the map, though, are 
//                    freed with a call to the map clear() method in the
//                    base class destructor.
//
/////////////////////////////////////////////////////////////////////////////
CSCPComponentInterface::~CSCPComponentInterface()
{
}

std::string CSCPComponentInterface::GetRegistryString(const HKEY hKey, const std::string strQueryName)
{
	std::string strReturnString;
    CString strValue;
	DWORD dwType, dwCount;
	LONG lResult = RegQueryValueEx(hKey, _T(strQueryName.c_str()), 
                                   NULL, &dwType, NULL, &dwCount);
	if (lResult == ERROR_SUCCESS)
	{
		ASSERT(dwType == REG_SZ);
        lResult = RegQueryValueEx(hKey, _T(strQueryName.c_str()), 
                                  NULL, &dwType,
				 (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                  &dwCount);

		strReturnString = strValue;
		strValue.ReleaseBuffer();
	}

	return strReturnString;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CInstrumentsComponentInterface::InitializeComponentConfig()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Description      : InitializeComponentConfig() is a common framework method
//                    used to read the configuration data for this DLL from
//                    the registry.
//
/////////////////////////////////////////////////////////////////////////////
void CSCPComponentInterface::InitializeComponentConfig()
{
   CComponentInterface::InitializeComponentConfig();

   m_pSCPMain = new SCPMain;  // instantiate the SCP

   if (m_pSCPMain == NULL)
   {
       return;
   }

   HKEY hKey;
   RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\") + CString(m_stlStrComponentName.c_str()), 0, KEY_READ, &hKey);

	if (hKey != NULL)
	{
		std::string strSerialPort(GetRegistryString(hKey, "SerialPort"));
		std::string strBaudRate(GetRegistryString(hKey, "BaudRate"));
		std::string strByteSize(GetRegistryString(hKey, "ByteSize"));
		std::string strStopBits(GetRegistryString(hKey, "StopBits"));
		std::string strParity(GetRegistryString(hKey, "Parity"));
		std::string strMainPageFile(GetRegistryString(hKey, "MainPageFile"));
		std::string strPagePath(GetRegistryString(hKey, "PagePath"));
		std::string strBufferSize(GetRegistryString(hKey, "BufferSize"));
		std::string strRefreshRate(GetRegistryString(hKey, "RefreshRate"));
		bool bSerialPortUp = m_pSCPMain->SerialPortInitialize(strSerialPort, strBaudRate, strByteSize, strParity, strStopBits, strBufferSize);
		bool bPageSettingsInitialized = m_pSCPMain->PageSettingInitialize(strPagePath, strMainPageFile);
		
		m_pSCPMain->SetRefreshRate(atoi(strRefreshRate.c_str()));

		if(bSerialPortUp && bPageSettingsInitialized)
		{
			CCommsShared::AddUpdateCallback(UpdateDTI);
			m_pSCPMain->Start();
		}
		else
		{
			if(!bSerialPortUp)
				ASSERT(0);

			if(!bPageSettingsInitialized)
				ASSERT(0);

			CleanComponentResources();
		}
	} 
}

/////////////////////////////////////////////////////////////////////////////
//
// void CSCPComponentInterface::CleanComponentResources()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 10 November 1999
//
// Engineer         : Billy Baker
//
// Description      : CleanComponentResources() is a common framework method
//                    used to cleanup any resources that were probably created
//                    in InitializeComponentConfig().
//
/////////////////////////////////////////////////////////////////////////////
void CSCPComponentInterface::CleanComponentResources()
{
    if (m_pSCPMain != NULL)
    {
        m_pSCPMain->Stop();

        delete m_pSCPMain;

        m_pSCPMain = NULL;
    }
}
