///////////////////////////////////////////////////////////////////////////
// XMLArchiveEx.cpp

//
// This file contains implementations of the less-generic template instantiations of
// CXMLArchive-related templates.  The intent is to keep XMLArchive.cpp as a minimal
// CXMLArchive implementation so that it can easily be used in other contexts.
// Thus, it contains no dependency on MFC; all MFC-dependent archiving should be
// done here or in other application code.
// 

#include "..\core\stdafx.h"
#include "Afxtempl.h"
#include "XMLArchive.h"
#include <vector>



CXMLArchive& operator<<(CXMLArchive& rArchive, const CNamedData<CString> & namedData)
{
	ASSERT(rArchive.IsStoring());
	CXMLNode *pNode = rArchive.InsertNewTextElement(namedData.m_pParent, namedData.m_bsName, namedData.m_tVal);
	delete pNode;

	return rArchive;
}

CXMLArchive& operator>>(CXMLArchive& rArchive, CNamedData<CString> & namedData)
{
	ASSERT(!rArchive.IsStoring());
	CXMLNode *pNode = rArchive.SelectNode(namedData.m_pParent, namedData.m_bsName);
	if (pNode)
	{
		BSTR bs;
		pNode->GetNode()->get_text(&bs);
		namedData.m_tVal = bs;
		delete pNode;
	}

	return rArchive;
}

CXMLArchive& operator<<(CXMLArchive& rArchive, const CNamedCData<CString> & namedCData)
{
	ASSERT(rArchive.IsStoring());
	CXMLNode *pNode = rArchive.InsertNewElement(namedCData.m_pParent, namedCData.m_bsName);
	rArchive.InsertNewCData(pNode, namedCData.m_tVal);
	delete pNode;

	return rArchive;
}

CXMLArchive& operator>>(CXMLArchive& rArchive, CNamedCData<CString> & namedCData)
{
	ASSERT(!rArchive.IsStoring());
	CXMLNode *pNode = rArchive.SelectNode(namedCData.m_pParent, namedCData.m_bsName);
	if (pNode)
	{
		_bstr_t bsTemp;
		rArchive.RetrieveCData(pNode, bsTemp);
		namedCData.m_tVal = (char *)bsTemp;
		delete pNode;
	}

	return rArchive;
}




CXMLArchive& operator<<(CXMLArchive& rArchive, const CNamedAttribute<CString> & namedAttr)
{
	ASSERT(rArchive.IsStoring());
	namedAttr.m_pParent->SetAttribute(namedAttr.m_bsName, namedAttr.m_tVal);
	return rArchive;
}

CXMLArchive& operator>>(CXMLArchive& rArchive, CNamedAttribute<CString> & namedAttr)
{
	ASSERT(!rArchive.IsStoring());
	_bstr_t bsVal;
	namedAttr.m_pParent->GetAttribute(namedAttr.m_bsName, bsVal);
	namedAttr.m_tVal = (char *)bsVal;
	return rArchive;
}


///////////////////////////////////////////////////////////////////////////
// This set of functions serializes collection classes
///////////////////////////////////////////////////////////////////////////
CXMLArchive& operator<<(CXMLArchive& rArchive, CNamedData<CList<CString, CString&> > & namedData)
{
	ASSERT(rArchive.IsStoring());
	POSITION pos = namedData.m_tVal.GetHeadPosition();
	while (pos)
	{
		CString& csStr = namedData.m_tVal.GetNext(pos);
		rArchive << CNamedData<CString>(*namedData.m_pParent, namedData.m_bsName, csStr);
	}
	return rArchive;
}

CXMLArchive& operator>>(CXMLArchive& rArchive, CNamedData<CList<CString, CString&> > & namedData)
{
	ASSERT(!rArchive.IsStoring());
	CXMLNodeList listItems(namedData.m_pParent, namedData.m_bsName);
	int nLen = listItems.Length();
	for(int i = 0; i < nLen; i++)
	{
		BSTR bs;
		CXMLNode *pNode = listItems[i];
		pNode->GetNode()->get_text(&bs);
		delete pNode;
		namedData.m_tVal.AddTail(CString(bs));
	}
	return rArchive;
}

CXMLArchive& operator<<(CXMLArchive& rArchive, CNamedData<CArray<CString, CString&> > & namedData)
{
	ASSERT(rArchive.IsStoring());
	for (int i = 0; i < namedData.m_tVal.GetSize(); i++)
	{
		rArchive << CNamedData<CString>(*namedData.m_pParent, namedData.m_bsName, namedData.m_tVal[i]);
	}
	return rArchive;
}

CXMLArchive& operator>>(CXMLArchive& rArchive, CNamedData<CArray<CString, CString&> > & namedData)
{
	ASSERT(!rArchive.IsStoring());
	CXMLNodeList listItems(namedData.m_pParent, namedData.m_bsName);
	int nLen = listItems.Length();
	for(int i = 0; i < nLen; i++)
	{
		BSTR bs;
		CXMLNode *pNode = listItems[i];
		pNode->GetNode()->get_text(&bs);
		delete pNode;
		namedData.m_tVal.Add(CString(bs));
	}
	return rArchive;
}

CXMLArchive& operator<<(CXMLArchive& rArchive, CNamedData<std::vector<std::string> > & namedData)
{
	ASSERT(rArchive.IsStoring());
	CXMLNode *pItems = rArchive.InsertNewElement(namedData.m_pParent, namedData.m_bsName);
	for (size_t i = 0; i < namedData.m_tVal.size(); i++)
	{
		rArchive << CNamedData<std::string>(*pItems, L"Item", namedData.m_tVal[i]);
	}
	delete pItems;
#ifdef NOT_NOW
	for (int i = 0; i < namedData.m_tVal.size(); i++)
	{
		rArchive << CNamedData<std::string>(namedData.m_pParent, namedData.m_bsName, namedData.m_tVal[i]);
	}
#endif
	return rArchive;
}

CXMLArchive& operator>>(CXMLArchive& rArchive, CNamedData<std::vector<std::string> > & namedData)
{
	ASSERT(!rArchive.IsStoring());
	CXMLNode *pItems = rArchive.SelectNode(namedData.m_pParent, namedData.m_bsName);
	CXMLNodeList listItems(pItems);
	int nLen = listItems.Length();
	for(int i = 0; i < nLen; i++)
	{
		BSTR bs;
		CXMLNode *pNode = listItems[i];
		pNode->GetNode()->get_text(&bs);
		delete pNode;
		std::string sTemp = (const char *)CString(bs);
		namedData.m_tVal.push_back(sTemp);
	}
	delete pItems;
	return rArchive;
}

