#ifndef IOS_SERIAL_DEVICE_MANAGER_H
#define IOS_SERIAL_DEVICE_MANAGER_H

#include "XMLArchive.h"

class serial_port_manager
{
private:
	int  m_nStatus;
	char* m_szBuffer;
	bool m_bFirstPass;
	bool m_bHardwareFailure;
	bool m_bFailedIO;
	bool m_bFailedI;

	HRESULT m_hr;
	DWORD	m_dwEvtMask;

	HANDLE  m_hCom;
	DCB*	m_pdcbNew;
	DCB*	m_pdcbPrevious;
	
	COMMTIMEOUTS	m_ctPreviousCommTimeouts;
	COMMTIMEOUTS	m_ctNewCommTimeouts;

	bool m_bComportInitialized;

	//serial port info
	_FSI_STL::string m_csSerialPortName;
	_FSI_STL::string m_csBaud; 
	_FSI_STL::string m_csParity; 
	long m_nByteSize;
	_FSI_STL::string m_csStopBits;
	_FSI_STL::string m_csStartBits;

	//start/stop transmission flags
	char m_chStartTransmission;
	char m_chStopTransmission;

	//serial buffer info.
	long m_nReadIntervalTimeout; 
	long m_nReadTotalTimeoutConstant;
	long m_nReadTotalTimeoutMultiplier;
	long m_nWriteTotalTimeoutConstant;
	long m_nWriteTotalTimeoutMultiplier;
	long m_nMaximumReadAttempts;
	long m_nBufferSize;

	//event flag info.
	_FSI_STL::string m_csEventDetectionMode;
	int	m_nEventDetectionMode;
	char m_chEventFlag;

	FILE* m_fDebug;

public:

	void	AddSerialPort(_FSI_STL::string csName, 
						  _FSI_STL::string csBaud, 
						  _FSI_STL::string csParity,
						  _FSI_STL::string csByteSize,
						  _FSI_STL::string csStartBits,
						  _FSI_STL::string csStopBits);

	void	AddSerialBuffer(
							_FSI_STL::string csReadIntervalTimeout, 
							_FSI_STL::string csReadTotalTimeoutConstant,
							_FSI_STL::string csReadTotalTimeoutMultiplier,
							_FSI_STL::string csWriteTotalTimeoutConstant,
							_FSI_STL::string csWriteTotalTimeoutMultiplier, 
							_FSI_STL::string csEventType,
							_FSI_STL::string csEventFlagValue, 
							_FSI_STL::string csMaximumReadAttempts,
							_FSI_STL::string csBufferSize);
	
	void	AddMaskTable(CXMLArchive& ar, CXMLNode* pNode);
	
	void	AddMask(_FSI_STL::string csName, _FSI_STL::string csCharValue);

	bool	ClearError(void);



	virtual bool Status(void);

public:

	virtual bool XMLSerialize(CXMLArchive& ar, CXMLNode *pNode);

	virtual void VisitNestedXMLNodes(CXMLArchive& ar, CXMLNode *pNode);

	serial_port_manager(void);

	serial_port_manager(const std::string csPortName);

	serial_port_manager(const std::string csPortName, const std::string stdBaud, const std::string stdByteSize, const std::string stdParity, const std::string stdStopBits, const std::string stdBufferSize);

	serial_port_manager(serial_port_manager* p);
	
	serial_port_manager(serial_port_manager& x);

	serial_port_manager& operator=(const serial_port_manager& rhs);

	serial_port_manager& operator=(const serial_port_manager* rhs);

	virtual ~serial_port_manager(void);

	virtual bool Initialize(void);

	virtual void SetBufferSize(const int);

	virtual bool Read(std::string&);

	virtual bool Write(const std::string);
};

#endif