#include "..\core\stdafx.h"
#include "SerialPortManager.h"
#include "XMLArchive.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

serial_port_manager::serial_port_manager(void)
:
m_csSerialPortName("COM2"),
m_bFirstPass(true),
m_bComportInitialized(false),
m_csBaud("19200"),
m_csParity("No"),
m_nByteSize(8),
m_csStopBits("1"),
m_csStartBits("1"),
m_nReadIntervalTimeout(1), 
m_nReadTotalTimeoutConstant(1),
m_nReadTotalTimeoutMultiplier(1),
m_nWriteTotalTimeoutConstant(1),
m_nWriteTotalTimeoutMultiplier(1),
m_chStartTransmission('\n'),
m_chStopTransmission('\n'),
m_nBufferSize(256),
m_szBuffer(NULL),
m_hCom(NULL),
m_bHardwareFailure(false),
m_dwEvtMask(EV_RXCHAR),
m_bFailedIO(false)
{
	m_szBuffer = new char[m_nBufferSize];
		
	m_pdcbNew = new DCB();
	m_pdcbPrevious = new DCB();
}

serial_port_manager::serial_port_manager(const std::string csPortName)
:
m_csSerialPortName(csPortName),
m_bFirstPass(true),
m_bComportInitialized(false),
m_csBaud("19200"),
m_csParity("No"),
m_nByteSize(8),
m_csStopBits("1"),
m_csStartBits("1"),
m_nReadIntervalTimeout(1), 
m_nReadTotalTimeoutConstant(1),
m_nReadTotalTimeoutMultiplier(1),
m_nWriteTotalTimeoutConstant(1),
m_nWriteTotalTimeoutMultiplier(1),
m_chStartTransmission('\n'),
m_chStopTransmission('\n'),
m_nBufferSize(256),
m_szBuffer(NULL),
m_hCom(NULL),
m_bHardwareFailure(false),
m_dwEvtMask(EV_RXCHAR),
m_bFailedIO(false)
{
	m_szBuffer = new char[m_nBufferSize];

	m_pdcbNew = new DCB();
	m_pdcbPrevious = new DCB();
}

serial_port_manager::serial_port_manager(const std::string csPortName, const std::string stdBaud, const std::string stdByteSize, const std::string stdParity, const std::string stdStopBits, const std::string stdBufferSize)
:
m_csSerialPortName(csPortName),
m_bFirstPass(true),
m_bComportInitialized(false),
m_csBaud(stdBaud),
m_csParity(stdParity),
m_nByteSize(atoi(stdByteSize.c_str())),
m_csStopBits(stdStopBits),
m_csStartBits("1"),
m_nReadIntervalTimeout(1), 
m_nReadTotalTimeoutConstant(1),
m_nReadTotalTimeoutMultiplier(1),
m_nWriteTotalTimeoutConstant(1),
m_nWriteTotalTimeoutMultiplier(1),
m_chStartTransmission('\n'),
m_chStopTransmission('\n'),
m_nBufferSize(256),
m_szBuffer(NULL),
m_hCom(NULL),
m_bHardwareFailure(false),
m_dwEvtMask(EV_RXCHAR),
m_bFailedIO(false)
{
	m_szBuffer = new char[m_nBufferSize];

	m_pdcbNew = new DCB();
	m_pdcbPrevious = new DCB();

	m_fDebug = fopen("c:\\temp\\spc_debug.txt", "wt");
}

serial_port_manager::serial_port_manager(serial_port_manager& x)
{
	m_bFirstPass = x.m_bFirstPass;
	m_bComportInitialized = x.m_bComportInitialized;
	m_csBaud = x.m_csBaud;
	m_csParity = x.m_csParity;
	m_nByteSize = x.m_nByteSize;
	m_csStopBits = x.m_csStopBits;
	m_csStartBits = x.m_csStartBits;
	m_nReadIntervalTimeout = x.m_nReadIntervalTimeout;
	m_nReadTotalTimeoutConstant = x.m_nReadTotalTimeoutConstant;
	m_nReadTotalTimeoutMultiplier = x.m_nReadTotalTimeoutMultiplier;
	m_nWriteTotalTimeoutConstant = x.m_nWriteTotalTimeoutConstant;
	m_nWriteTotalTimeoutMultiplier = x.m_nWriteTotalTimeoutMultiplier;
	m_chStartTransmission = x.m_chStartTransmission;
	m_chStopTransmission = x.m_chStopTransmission;
	m_nBufferSize = x.m_nBufferSize;
	m_szBuffer = x.m_szBuffer;
	m_hCom = x.m_hCom;
	m_bHardwareFailure = x.m_bHardwareFailure;
	m_dwEvtMask = x.m_dwEvtMask;
	m_bFailedIO = x.m_bFailedIO;
	m_szBuffer = x.m_szBuffer;
}

serial_port_manager::serial_port_manager(serial_port_manager* p)
{
	m_bFirstPass = p->m_bFirstPass;
	m_bComportInitialized = p->m_bComportInitialized;
	m_csBaud = p->m_csBaud;
	m_csParity = p->m_csParity;
	m_nByteSize = p->m_nByteSize;
	m_csStopBits = p->m_csStopBits;
	m_csStartBits = p->m_csStartBits;
	m_nReadIntervalTimeout = p->m_nReadIntervalTimeout;
	m_nReadTotalTimeoutConstant = p->m_nReadTotalTimeoutConstant;
	m_nReadTotalTimeoutMultiplier = p->m_nReadTotalTimeoutMultiplier;
	m_nWriteTotalTimeoutConstant = p->m_nWriteTotalTimeoutConstant;
	m_nWriteTotalTimeoutMultiplier = p->m_nWriteTotalTimeoutMultiplier;
	m_chStartTransmission = p->m_chStartTransmission;
	m_chStopTransmission = p->m_chStopTransmission;
	m_nBufferSize = p->m_nBufferSize;
	m_szBuffer = p->m_szBuffer;
	m_hCom = p->m_hCom;
	m_bHardwareFailure = p->m_bHardwareFailure;
	m_dwEvtMask = p->m_dwEvtMask;
	m_bFailedIO = p->m_bFailedIO;
	m_szBuffer = p->m_szBuffer;
}

serial_port_manager& serial_port_manager::operator=(const serial_port_manager& rhs)
{
	if(this == &rhs)return *this;

	m_bFirstPass = rhs.m_bFirstPass;
	m_bComportInitialized = rhs.m_bComportInitialized;
	m_csBaud = rhs.m_csBaud;
	m_csParity = rhs.m_csParity;
	m_nByteSize = rhs.m_nByteSize;
	m_csStopBits = rhs.m_csStopBits;
	m_csStartBits = rhs.m_csStartBits;
	m_nReadIntervalTimeout = rhs.m_nReadIntervalTimeout;
	m_nReadTotalTimeoutConstant = rhs.m_nReadTotalTimeoutConstant;
	m_nReadTotalTimeoutMultiplier = rhs.m_nReadTotalTimeoutMultiplier;
	m_nWriteTotalTimeoutConstant = rhs.m_nWriteTotalTimeoutConstant;
	m_nWriteTotalTimeoutMultiplier = rhs.m_nWriteTotalTimeoutMultiplier;
	m_chStartTransmission = rhs.m_chStartTransmission;
	m_chStopTransmission = rhs.m_chStopTransmission;
	m_nBufferSize = rhs.m_nBufferSize;
	m_szBuffer = rhs.m_szBuffer;
	m_hCom = rhs.m_hCom;
	m_bHardwareFailure = rhs.m_bHardwareFailure;
	m_dwEvtMask = rhs.m_dwEvtMask;
	m_bFailedIO = rhs.m_bFailedIO;
	m_szBuffer = rhs.m_szBuffer;

	return *this;
}

serial_port_manager& serial_port_manager::operator=(const serial_port_manager* rhs)
{
	if(this == rhs)return *this;

	m_bFirstPass = rhs->m_bFirstPass;
	m_bComportInitialized = rhs->m_bComportInitialized;
	m_csBaud = rhs->m_csBaud;
	m_csParity = rhs->m_csParity;
	m_nByteSize = rhs->m_nByteSize;
	m_csStopBits = rhs->m_csStopBits;
	m_csStartBits = rhs->m_csStartBits;
	m_nReadIntervalTimeout = rhs->m_nReadIntervalTimeout;
	m_nReadTotalTimeoutConstant = rhs->m_nReadTotalTimeoutConstant;
	m_nReadTotalTimeoutMultiplier = rhs->m_nReadTotalTimeoutMultiplier;
	m_nWriteTotalTimeoutConstant = rhs->m_nWriteTotalTimeoutConstant;
	m_nWriteTotalTimeoutMultiplier = rhs->m_nWriteTotalTimeoutMultiplier;
	m_chStartTransmission = rhs->m_chStartTransmission;
	m_chStopTransmission = rhs->m_chStopTransmission;
	m_nBufferSize = rhs->m_nBufferSize;
	m_szBuffer = rhs->m_szBuffer;
	m_hCom = rhs->m_hCom;
	m_bHardwareFailure = rhs->m_bHardwareFailure;
	m_dwEvtMask = rhs->m_dwEvtMask;
	m_bFailedIO = rhs->m_bFailedIO;
	m_szBuffer = rhs->m_szBuffer;
	return *this;
}

serial_port_manager::~serial_port_manager(void)
{
	//delete dyn. decld. read buffer
	delete [] m_szBuffer;

	SetCommTimeouts(m_hCom, &m_ctPreviousCommTimeouts);

	//return dcb to previous state. (i.e. pre-execution)
	SetCommState(m_hCom, m_pdcbPrevious);

	if(m_hCom)
	{
		CloseHandle(m_hCom);	
	}

	//delete the dyn. decld. DCBs
	delete m_pdcbNew;	
	delete m_pdcbPrevious;
}

void	serial_port_manager::AddSerialPort(
										_FSI_STL::string csSerialPortName, 
										_FSI_STL::string csBaud, 
										_FSI_STL::string csParity, 
										_FSI_STL::string csByteSize, 
										_FSI_STL::string csStartBits,
										_FSI_STL::string csStopBits)
{
	m_csSerialPortName = csSerialPortName;
	m_csBaud = csBaud; 
	m_csParity = csParity; 
	m_nByteSize = atol(csByteSize.c_str());
	m_csStartBits = csStartBits;
	m_csStopBits = csStopBits;
}

void	serial_port_manager::AddSerialBuffer(
										  _FSI_STL::string csReadIntervalTimeout, 
										  _FSI_STL::string csReadTotalTimeoutConstant,
										  _FSI_STL::string csReadTotalTimeoutMultiplier,
										  _FSI_STL::string csWriteTotalTimeoutConstant,
										  _FSI_STL::string csWriteTotalTimeoutMultiplier, 
										  _FSI_STL::string csEventDetectionMode,
										  _FSI_STL::string csEventFlagValue, 
										  _FSI_STL::string csMaximumReadAttempts,
										  _FSI_STL::string csBufferSize)
{
	m_nReadIntervalTimeout = atol(csReadIntervalTimeout.c_str()); 
	m_nReadTotalTimeoutConstant = atol(csReadTotalTimeoutConstant.c_str()); 
	m_nReadTotalTimeoutMultiplier = atol(csReadTotalTimeoutMultiplier.c_str()); 
	m_nWriteTotalTimeoutConstant = atol(csWriteTotalTimeoutConstant.c_str()); 
	m_nWriteTotalTimeoutMultiplier = atol(csWriteTotalTimeoutMultiplier.c_str()); 
	
	m_csEventDetectionMode = csEventDetectionMode;

	if(m_csEventDetectionMode=="Flag" || m_csEventDetectionMode=="flag")
		m_chEventFlag = (char)atol(csEventFlagValue.c_str());
	else
		m_chEventFlag = m_chStartTransmission;

	m_nMaximumReadAttempts = atol(csMaximumReadAttempts.c_str()); 
	m_nBufferSize = atol(csBufferSize.c_str());
}

void	serial_port_manager::AddMaskTable(CXMLArchive& ar, CXMLNode* pNode)
{	
	CXMLNodeList listNestedNodes(pNode);
	int nNumNestedNodes = listNestedNodes.Length();

	VisitNestedXMLNodes(ar, pNode);
}

void	serial_port_manager::AddMask(_FSI_STL::string csName, _FSI_STL::string csValue)
{
	if(csName=="StartSerialString")
		m_chStartTransmission = (char)atol(csValue.c_str());
	else if(csName=="StopSerialString")
		m_chStopTransmission = (char)atol(csValue.c_str());
}

bool serial_port_manager::Initialize(void)
{
	if(m_bFirstPass)
	{
		m_hCom = ::CreateFile( 
							m_csSerialPortName.c_str(),
							GENERIC_READ | GENERIC_WRITE,
							0,    // comm devices must be opened w/exclusive-access 
							NULL, // no security attributes 
							OPEN_EXISTING, // comm devices must use OPEN_EXISTING 
							0,    // not overlapped I/O 
							NULL  // hTemplate must be NULL for comm devices 
							); 

		//failed to allocate file handle
		if(m_hCom == INVALID_HANDLE_VALUE)
			return false;

		m_bFirstPass = false;
	}

	// detect pre iosrt dcb setttings for this comport
	if(!::GetCommState(m_hCom, m_pdcbNew))
	{
		m_hr = GetLastError();

		if(!ClearError())
		{
			m_bHardwareFailure=true;
			return false;
		}
	}

	//		fill this dcb to be used prior to terminating execution to 
	//		set the comm state back to the previous settings.
	if(!::GetCommState(m_hCom, m_pdcbPrevious))
	{
		m_hr = GetLastError();
		if(!ClearError())
		{
			m_bHardwareFailure=true;
			return false;
		}
	}

/*
#define CBR_110             110
#define CBR_300             300
#define CBR_600             600
#define CBR_1200            1200
#define CBR_2400            2400
#define CBR_4800            4800
#define CBR_9600            9600
#define CBR_14400           14400
#define CBR_19200           19200
#define CBR_38400           38400
#define CBR_56000           56000
#define CBR_57600           57600
#define CBR_115200          115200
#define CBR_128000          128000
#define CBR_256000          256000		
*/
	if		(m_csBaud=="110")
		m_pdcbNew->BaudRate = CBR_110; 
	else if	(m_csBaud=="300")
		m_pdcbNew->BaudRate = CBR_300;
	else if	(m_csBaud=="600")
		m_pdcbNew->BaudRate = CBR_600;
	else if	(m_csBaud=="1200")
		m_pdcbNew->BaudRate = CBR_1200;
	else if (m_csBaud=="2400")
		m_pdcbNew->BaudRate = CBR_2400;
	else if	(m_csBaud=="4800")
		m_pdcbNew->BaudRate = CBR_4800;
	else if	(m_csBaud=="9600")
		m_pdcbNew->BaudRate = CBR_9600;
	else if	(m_csBaud=="14400")
		m_pdcbNew->BaudRate = CBR_14400;
	else if (m_csBaud=="19200")
		m_pdcbNew->BaudRate = CBR_19200;
	else if	(m_csBaud=="38400")
		m_pdcbNew->BaudRate = CBR_38400;
	else if	(m_csBaud=="56000")
		m_pdcbNew->BaudRate = CBR_56000;
	else if (m_csBaud=="57600")
		m_pdcbNew->BaudRate = CBR_57600;
	else if	(m_csBaud=="115200")
		m_pdcbNew->BaudRate = CBR_115200;
	else if	(m_csBaud=="128000")
		m_pdcbNew->BaudRate = CBR_128000;
	else if (m_csBaud=="256000")
		m_pdcbNew->BaudRate = CBR_256000;

	//constraints info. from WINBASE.H
	if(m_nByteSize>3 && m_nByteSize<9)
		m_pdcbNew->ByteSize = m_nByteSize;

/* WINBASE.H
#define NOPARITY            0
#define ODDPARITY           1
#define EVENPARITY          2
#define MARKPARITY          3
#define SPACEPARITY         4
*/
	if		(m_csParity=="No")
		m_pdcbNew->Parity = NOPARITY; 
	else if	(m_csParity=="Odd")
		m_pdcbNew->Parity = ODDPARITY;
	else if	(m_csParity=="Even")
		m_pdcbNew->Parity = EVENPARITY;
	else if	(m_csParity=="Mark")
		m_pdcbNew->Parity = MARKPARITY;
	else if (m_csParity=="Space")
		m_pdcbNew->Parity = SPACEPARITY;

/* WINBASE.H
#define ONESTOPBIT          0
#define ONE5STOPBITS        1
#define TWOSTOPBITS         2
*/
	if		(m_csStopBits=="One")
		m_pdcbNew->StopBits = ONESTOPBIT; 
	else if	(m_csStopBits=="OneFive")
		m_pdcbNew->StopBits = ONE5STOPBITS;
	else if	(m_csStopBits=="Two")
		m_pdcbNew->StopBits = TWOSTOPBITS;

	m_pdcbNew->EvtChar = m_chEventFlag;
	m_pdcbNew->fBinary = TRUE;
	m_pdcbNew->fAbortOnError = TRUE;


/* WINBASE.H
#define EV_RXCHAR           0x0001  // Any Character received
#define EV_RXFLAG           0x0002  // Received certain character
#define EV_TXEMPTY          0x0004  // Transmitt Queue Empty
#define EV_CTS              0x0008  // CTS changed state
#define EV_DSR              0x0010  // DSR changed state
#define EV_RLSD             0x0020  // RLSD changed state
#define EV_BREAK            0x0040  // BREAK received
#define EV_ERR              0x0080  // Line status error occurred
#define EV_RING             0x0100  // Ring signal detected
#define EV_PERR             0x0200  // Printer error occured
#define EV_RX80FULL         0x0400  // Receive buffer is 80 percent full
#define EV_EVENT1           0x0800  // Provider specific event 1
#define EV_EVENT2           0x1000  // Provider specific event 2
*/
	if		(m_csEventDetectionMode =="Character")
		m_dwEvtMask = EV_RXCHAR; 
	else if	(m_csEventDetectionMode =="Flag")
		m_dwEvtMask = EV_RXFLAG;
	else if	(m_csEventDetectionMode =="Empty")
		m_dwEvtMask = EV_TXEMPTY;
	else if	(m_csEventDetectionMode =="CTS")
		m_dwEvtMask = EV_CTS;
	else if	(m_csEventDetectionMode =="DSR")
		m_dwEvtMask = EV_DSR;
	else if	(m_csEventDetectionMode =="RLSD")
		m_dwEvtMask = EV_RLSD;
	else if	(m_csEventDetectionMode =="Break")
		m_dwEvtMask = EV_BREAK;
	else if	(m_csEventDetectionMode =="Error")
		m_dwEvtMask = EV_ERR;
	else if	(m_csEventDetectionMode =="Ring")
		m_dwEvtMask = EV_RING;
	else if	(m_csEventDetectionMode =="Printer Error")
		m_dwEvtMask = EV_PERR;
	else if	(m_csEventDetectionMode =="80% Full")
		m_dwEvtMask = EV_RX80FULL;
	else if	(m_csEventDetectionMode =="Event 1")
		m_dwEvtMask = EV_EVENT1;
	else if	(m_csEventDetectionMode =="Event 2")
		m_dwEvtMask = EV_EVENT2;


	m_dwEvtMask |= EV_ERR;
	m_dwEvtMask |= EV_BREAK;

	if(!::GetCommTimeouts(m_hCom, &m_ctPreviousCommTimeouts))
	{
		m_hr =  GetLastError();
		if(!ClearError())
		{
			m_bHardwareFailure=true;
			return false;
		}
	}
	else
	{
		m_ctNewCommTimeouts.ReadIntervalTimeout	= m_nReadIntervalTimeout;
		m_ctNewCommTimeouts.ReadTotalTimeoutConstant = m_nReadTotalTimeoutConstant;
		m_ctNewCommTimeouts.ReadTotalTimeoutMultiplier = m_nReadTotalTimeoutMultiplier;
		m_ctNewCommTimeouts.WriteTotalTimeoutConstant = m_nWriteTotalTimeoutConstant;
		m_ctNewCommTimeouts.WriteTotalTimeoutMultiplier	= m_nWriteTotalTimeoutMultiplier;

		if(!SetCommTimeouts(m_hCom, &m_ctNewCommTimeouts))
		{
			m_hr = ::GetLastError();
			if(!ClearError())
			{
				m_bHardwareFailure=true;
				return false;
			}
		}

		//set mask to detect char received
		if(!SetCommMask(m_hCom, m_dwEvtMask))
		{
			m_hr = ::GetLastError();
			if(!ClearError())
			{
				m_bHardwareFailure=true;
				return false;
			}
		}

		// set comm state with the modified settings
		if(!SetCommState(m_hCom, m_pdcbNew))
		{
			m_hr =  ::GetLastError();
			if(!ClearError())
			{
				m_bHardwareFailure=true;
				return false; 
			}
		}
	}//end else (ie successfully got comm timeouts)

	if(m_szBuffer==NULL)
	{
		m_szBuffer = new char[(const)m_nBufferSize];
	}

	return true;
}

bool serial_port_manager::ClearError(void)
{
	COMSTAT comStat;
    DWORD   dwErrors;
    BOOL    fOOP, fOVERRUN, fPTO, fRXOVER, fRXPARITY, fTXFULL, 
			fBREAK, fDNS, fFRAME, fIOE, fMODE, bErrorSum=FALSE;
	bool bReturn = true;

    // Get and clear current errors on the port.
    if (!::ClearCommError(m_hCom, &dwErrors, &comStat))
	{// Report error in ClearCommError.
		bReturn = false;
	}

    // Get error flags.
    fDNS = dwErrors & CE_DNS;
	bErrorSum |= fDNS;

    fIOE = dwErrors & CE_IOE;
	bErrorSum |= fIOE;
    
	fOOP = dwErrors & CE_OOP;
	bErrorSum |= fOOP;
    
	fPTO = dwErrors & CE_PTO;
	bErrorSum |= fPTO;
    
	fMODE = dwErrors & CE_MODE;
	bErrorSum |= fMODE;
    
	fBREAK = dwErrors & CE_BREAK;
	bErrorSum |= fBREAK;
    
	fFRAME = dwErrors & CE_FRAME;
	bErrorSum |= fFRAME;
    
	fRXOVER = dwErrors & CE_RXOVER;
	bErrorSum |= fRXOVER;
    
	fTXFULL = dwErrors & CE_TXFULL;
	bErrorSum |= fTXFULL;
    
	fOVERRUN = dwErrors & CE_OVERRUN;
	bErrorSum |= fOVERRUN;
    
	fRXPARITY = dwErrors & CE_RXPARITY;
	bErrorSum |= fRXPARITY;

return bReturn;
}

void serial_port_manager::SetBufferSize(const int nSize)
{
	m_nBufferSize = nSize;
}

void serial_port_manager::VisitNestedXMLNodes(CXMLArchive& ar, CXMLNode *pNode)
{
	CXMLNodeList listNestedNodes(pNode);
	int nNumNestedNodes = listNestedNodes.Length();

	for(int j=0; j < nNumNestedNodes; j++)
	{
		//serialize nodes at this level
		XMLSerialize(ar, listNestedNodes[j]);
	}
}

bool serial_port_manager::XMLSerialize(CXMLArchive& ar, CXMLNode *pNode)
{
	_bstr_t nodeName;
	
	if(pNode->GetName(nodeName))
	{
		_FSI_STL::string csNodeName(nodeName);

		if	(csNodeName == "SerialPort")
		{
			_FSI_STL::string csName;
			_FSI_STL::string csBaud;
			_FSI_STL::string csParity;
			_FSI_STL::string csByteSize;
			_FSI_STL::string csStartBits;
			_FSI_STL::string csStopBits;
			
			ar >> CNamedAttribute<_FSI_STL::string>(*pNode, L"Name", csName)
				 >> CNamedAttribute<_FSI_STL::string>(*pNode, L"Baud", csBaud)
				 >> CNamedAttribute<_FSI_STL::string>(*pNode, L"Parity", csParity)
				 >> CNamedAttribute<_FSI_STL::string>(*pNode, L"ByteSize", csByteSize)
				 >> CNamedAttribute<_FSI_STL::string>(*pNode, L"StopBits", csStartBits)
				 >> CNamedAttribute<_FSI_STL::string>(*pNode, L"StopBits", csStopBits);

			AddSerialPort(csName, csBaud, csParity, csByteSize, csStopBits, csStartBits);
			return true;
		}
		else if	(csNodeName == "SerialBuffer")
		{
			_FSI_STL::string csMode;
			_FSI_STL::string csReadIntervalTimeout;
			_FSI_STL::string csReadTotalTimeoutConstant;
			_FSI_STL::string csReadTotalTimeoutMultiplier;
			_FSI_STL::string csWriteTotalTimeoutConstant;
			_FSI_STL::string csWriteTotalTimeoutMultiplier;
			_FSI_STL::string csEventType;
			_FSI_STL::string csEventFlagValue;
			_FSI_STL::string csMaximumReadAttempts;
			_FSI_STL::string csBufferSize;
			_FSI_STL::string csIOMode;
			
			ar   >> CNamedAttribute<_FSI_STL::string>(*pNode, L"Mode", csMode)
				 >> CNamedAttribute<_FSI_STL::string>(*pNode, L"ReadIntervalTimeout", csReadIntervalTimeout)
				 >> CNamedAttribute<_FSI_STL::string>(*pNode, L"ReadTotalTimeoutConstant", csReadTotalTimeoutConstant)
				 >> CNamedAttribute<_FSI_STL::string>(*pNode, L"ReadTotalTimeoutMultiplier", csReadTotalTimeoutMultiplier)
				 >> CNamedAttribute<_FSI_STL::string>(*pNode, L"WriteTotalTimeoutConstant", csWriteTotalTimeoutConstant)
				 >> CNamedAttribute<_FSI_STL::string>(*pNode, L"WriteTotalTimeoutMultiplier", csWriteTotalTimeoutMultiplier)
				 >> CNamedAttribute<_FSI_STL::string>(*pNode, L"EventType", csEventType)
				 >> CNamedAttribute<_FSI_STL::string>(*pNode, L"EventFlagValue", csEventFlagValue)
				 >> CNamedAttribute<_FSI_STL::string>(*pNode, L"MaximumReadAttempts", csMaximumReadAttempts)
				 >> CNamedAttribute<_FSI_STL::string>(*pNode, L"BufferSize", csBufferSize)
				 >> CNamedAttribute<_FSI_STL::string>(*pNode, L"IOMode", csIOMode);

			AddSerialBuffer(
							 csReadIntervalTimeout,
							 csReadTotalTimeoutConstant,
							 csReadTotalTimeoutMultiplier,
							 csWriteTotalTimeoutConstant,
							 csWriteTotalTimeoutMultiplier,
							 csEventType,
							 csEventFlagValue,
							 csMaximumReadAttempts,
							 csBufferSize);
			return true;
		}
		else if	(csNodeName == "SerialBufferMaskTable")
		{
			AddMaskTable(ar, pNode);
			return true;
		}
		else if	(csNodeName == "SerialBufferMask")
		{
			_FSI_STL::string csName;
			_FSI_STL::string csValue;
			
			ar	>> CNamedAttribute<_FSI_STL::string>(*pNode, L"Name", csName)
				>> CNamedAttribute<_FSI_STL::string>(*pNode, L"IntegerValue", csValue);

			AddMask(csName, csValue);
			return true;
		}
		else
		{
			return false;
		}
	}
	else
	{
		//error processing node
		return false;
	}
}

bool serial_port_manager::Status(void)
{
    m_nStatus = 0;
	DWORD dwModemStatus;
	BOOL  fCTS, fDSR, fRING, fRLSD;

	if (!::GetCommModemStatus(m_hCom, &dwModemStatus))
	{
		m_hr = GetLastError();

		if(!ClearError())
		{
			m_bHardwareFailure = true;
			return false;
		}
	}
	
	fCTS = MS_CTS_ON & dwModemStatus;
	fDSR = MS_DSR_ON & dwModemStatus;
	fRING = MS_RING_ON & dwModemStatus;
	fRLSD = MS_RLSD_ON & dwModemStatus;

	m_nStatus |= fCTS;
	m_nStatus |= fDSR;
	m_nStatus |= fRING;
	m_nStatus |= fRLSD;

	if(m_nStatus)
	{
		//only report fix if signal is now fixed
		if(m_bFailedIO)
		{
			//report resumed signal to log
			//no failure now
			m_bFailedIO=false;
		}

		//valid signal 
		return true;
	}
	else
	{
		if(!m_bFailedIO)
		{
			m_bFailedIO=true;
		}

		//invalid signal on line
		return false;
	}
}

bool serial_port_manager::Read(_FSI_STL::string& csReadString)
{
	DWORD dwLength;

	int i;
	int nCount = 0;
	bool bDoneReading = false;

	//null out buffer 
	for(i=0;i<m_nBufferSize;i++)
	{
		m_szBuffer[i] = '\0';
	}

	//get buffer until ReadFile doesn't get data or end of buffer range is reached
	while(!bDoneReading && nCount<m_nBufferSize)
	{
		::ReadFile(m_hCom, m_szBuffer, sizeof(m_szBuffer[nCount]), &dwLength, NULL);
		
		if(dwLength==sizeof(m_szBuffer[nCount]))
		{
			nCount++;
		}
		else
		{
			Status();
			bDoneReading = true;
		}
	}

	i=0;
	//filter out STX, ETX, and obviously corrupt chars to form clean reply packet(s)
	while(i<nCount)
	{
		if((m_szBuffer[i] != m_chStartTransmission) 
		&& (m_szBuffer[i] != m_chStopTransmission)
		&& (m_szBuffer[i] > char(10)))
		{	
			csReadString += m_szBuffer[i];
		}

		i++;
	}

	if(csReadString.length())
		return true;

return false;
}


bool serial_port_manager::Write(const _FSI_STL::string csWriteString)
{
	DWORD nWritten;
	int nFileSuccess = -1;

	DWORD dwStringLength = csWriteString.length();	

	nFileSuccess = ::WriteFile(m_hCom, csWriteString.c_str(), dwStringLength, &nWritten, NULL);
//----------------------------------------
//	std::string strDebugHdr = "|start|";
//	std::string strDebugEnd = "|stop|";
//	int nDebugSuccess = fprintf(m_fDebug, "%s\t%s\t%s\n", strDebugHdr.c_str(), csWriteString.c_str(), strDebugEnd.c_str());
//-----------------------------------------
	if (nFileSuccess)
	{
		m_hr = S_OK;
		
		// If this is the first successful write after
		// having had failed on IO, reset FailedIO flag false.
		if(m_bFailedIO)
			m_bFailedIO = false;
		
		return true;
	}
	else
	{
		m_hr = GetLastError();
		ClearError();
		return false;
	}
}