// ScpWidget.h: interface for the ScpWidget class.
//
//////////////////////////////////////////////////////////////////////

#ifndef SCP_WIDGET_H
#define SCP_WIDGET_H


#include "ScpText.h"
#include "ScpEvent.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class scp_widget  
{
private:
	scp_text	m_stText;
	scp_event	m_seEvent;

	bool m_bHasEvent;
	bool m_bHasText;

public:
	scp_widget();

	scp_widget(scp_text* pText, scp_event* pEvent);

	scp_widget(scp_widget* p);

	scp_widget(scp_widget& x);

	scp_widget& operator=(const scp_widget* rhs);

	scp_widget& operator=(const scp_widget& rhs);

	bool operator==(const scp_widget& rhs);

	bool operator==(scp_widget* rhs);

	virtual ~scp_widget();
	
	bool AddText(scp_text* pNewText);

	bool AddEvent(scp_event* pNewEvent);

	bool HasText(void);

	scp_event* GetEvent(void);

	scp_text* GetText(void);

	std::string BuildDrawCommand(void);
};

typedef std::vector<scp_widget*> sw_vec;
typedef std::vector<scp_widget> scp_widget_vec;
typedef sw_vec::iterator sw_vec_iter;

typedef std::map<int, scp_widget*> int_to_sw_map;
typedef int_to_sw_map::iterator int_to_sw_map_iter;

typedef std::map<std::string, scp_widget*> string_to_sw_map;
typedef string_to_sw_map::iterator str_to_sw_map_iter;


#endif 
