// ScpWidget.cpp: implementation of the ScpWidget class.
//
//////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#include "ScpWidget.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

scp_widget::scp_widget()
:
m_bHasEvent(false),
m_bHasText(false),
m_stText(),
m_seEvent()
{
}

scp_widget::scp_widget(scp_text* pText, scp_event* pEvent)
:
m_bHasEvent(true),
m_bHasText(true),
m_stText(pText),
m_seEvent(pEvent)
{
}

scp_widget::scp_widget(scp_widget* p)
:
m_bHasEvent(p->m_bHasEvent),
m_bHasText(p->m_bHasText),
m_stText(p->m_stText),
m_seEvent(p->m_seEvent)
{
}

scp_widget::scp_widget(scp_widget& x)
:
m_bHasEvent(x.m_bHasEvent),
m_bHasText(x.m_bHasText),
m_stText(x.m_stText),
m_seEvent(x.m_seEvent)
{
}

scp_widget& scp_widget::operator=(const scp_widget* rhs)
{
	if(this == rhs)return *this;

	m_bHasEvent = rhs->m_bHasEvent;
	m_bHasText = rhs->m_bHasText;
	m_stText = rhs->m_stText;
	m_seEvent = rhs->m_seEvent;

	return *this;
}

scp_widget& scp_widget::operator=(const scp_widget& rhs)
{
	if(this == &rhs)return *this;

	m_bHasEvent = rhs.m_bHasEvent;
	m_bHasText = rhs.m_bHasText;
	m_stText = rhs.m_stText;
	m_seEvent = rhs.m_seEvent;	

	return *this;
}

bool scp_widget::operator==(const scp_widget& rhs)
{
	if( 
		m_bHasEvent == rhs.m_bHasEvent &&
		m_bHasText == rhs.m_bHasText &&
		m_stText == rhs.m_stText &&
		m_seEvent == rhs.m_seEvent)
		return true;
	
	return false;
}

bool scp_widget::operator==(scp_widget* rhs)
{
	if( 
		m_bHasEvent == rhs->m_bHasEvent &&
		m_bHasText == rhs->m_bHasText &&
		m_stText == rhs->m_stText &&
		m_seEvent == rhs->m_seEvent)
		return true;
	
	return false;
}

scp_widget::~scp_widget()
{
}

bool scp_widget::AddText(scp_text* pNewText)
{
	if(pNewText!=NULL)
	{
		m_stText = pNewText;
		m_bHasText = true;
		return true;
	}

	return false;
}

bool scp_widget::AddEvent(scp_event* pNewEvent)
{
	if(pNewEvent)
	{
		m_seEvent = pNewEvent;
		m_bHasEvent = true;
		return true;
	}

	return false;
}

scp_event* scp_widget::GetEvent(void)
{
	return &m_seEvent;
}

scp_text* scp_widget::GetText(void)
{
	return &m_stText;
}

bool scp_widget::HasText(void)
{
	return m_bHasText;
}

std::string scp_widget::BuildDrawCommand(void)
{
	std::string strTemp;

	char szTemp[10];
	int nX, nY;
	m_stText.GetTopLeft(nX, nY);

	itoa(nX, szTemp, 10);
	std::string strX(szTemp);

	itoa(nY, szTemp, 10);
	std::string strY(szTemp);

	strTemp += "\033[" + strY + ";" + strX + "H";

	//invert color for label text
	strTemp += "\033[7;m";
	
	strTemp += m_seEvent.GetButtonLabel();

	//revert color ... and for the time being space off draw
	strTemp += "\033[0;m";
	
	if(m_seEvent.HasDialogue())
		strTemp += " ? ";
	else if(m_seEvent.HasToggle())
		strTemp += " + ";
	else if(m_seEvent.HasPageLink())
		strTemp += "-> ";
	else if(m_seEvent.HasSelect())
		strTemp += " + ";
	else if(m_seEvent.HasCommand())
		strTemp += " + ";
	else 
		strTemp += "   ";

	strTemp += m_stText.GetStaticDraw();

	return strTemp;
}


