// ScpText.h: interface for the ScpText class.
//
//////////////////////////////////////////////////////////////////////

#ifndef SCP_TEXT_H
#define SCP_TEXT_H

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <vector>
#include <map>
#include <string>

typedef std::vector<std::string> str_vec;
typedef str_vec::iterator str_vec_iter; 

class scp_text  
{
private:
	
	bool m_bCommsDependant;
	std::string m_strCommsKey;

	int m_nMinX;
	int m_nMinY;
	int m_nMaxX;
	int m_nMaxY;

	std::string m_strStaticText;

	std::string m_strType;
	std::string m_strWidth;
	std::string m_strPrecision;

public:
	//ctors,dtors
	scp_text();
	scp_text(const int i, const int j, const int I, const int J, const std::string strStaticText, const std::string strType, const std::string strWidth, const std::string strPrecision);
	scp_text(const scp_text* p);
	scp_text(const scp_text& x);
	scp_text& operator=(const scp_text* rhs);
	scp_text& operator=(const scp_text& rhs);
	bool operator==(const scp_text& rhs);
	bool operator==(scp_text* rhs);
	virtual ~scp_text();

	//API
	void AddCommsDisplay(std::string strCommsKey);

	std::string GetCommsKey(void);

	bool IsCommsDependant(void);

	bool UpdateDraw(std::string strTemp);

	char GetDatatype(void);

	void SetDatatype(const char chType);

	void GetTopLeft(int& nX, int& nY);

	void GetBottomRight(int& nX, int& nY);

	void SetPrecision(int nPrecision);

	int GetPrecision(void);


	void GetPrecision(std::string& strPrecision);


	int GetWidth(void);


	void GetWidth(std::string& strWidth);

	std::string GetStaticDraw(void);

	std::string GetAssociatedText(std::string strVal);

	std::string Highlight(std::string strVal);
};

typedef std::vector<scp_text*> st_vec;
typedef st_vec::iterator st_vec_iter;

typedef std::map<int, scp_text*> int_to_st_map;
typedef int_to_st_map::iterator int_to_st_map_iter;

typedef std::map<std::string, scp_text*> str_to_st_map;
typedef str_to_st_map::iterator str_to_st_map_iter;

#endif
