// ScpText.cpp: implementation of the ScpText class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"

#include "ScpText.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

scp_text::scp_text()
:m_nMinX(0)
,m_nMinY(0)
,m_nMaxX(1)
,m_nMaxY(1)
,m_bCommsDependant(false)
{
}

scp_text::scp_text(const int i, const int j, const int I, const int J, const std::string strStaticText, const std::string strType, const std::string strWidth, const std::string strPrecision)
:m_nMinX(i)
,m_nMinY(j)
,m_nMaxX(I)
,m_nMaxY(J)
,m_strStaticText(strStaticText)
,m_bCommsDependant(false)
,m_strType(strType)
,m_strPrecision(strPrecision)
,m_strWidth(strWidth)
{
}

scp_text::scp_text(const scp_text* p)
:m_nMinX(p->m_nMinX)
,m_nMinY(p->m_nMinY)
,m_nMaxX(p->m_nMaxX)
,m_nMaxY(p->m_nMaxY)
,m_strStaticText(p->m_strStaticText)
,m_bCommsDependant(p->m_bCommsDependant)
,m_strCommsKey(p->m_strCommsKey)
,m_strType(p->m_strType)
,m_strPrecision(p->m_strPrecision)
,m_strWidth(p->m_strWidth)
{
}

scp_text::scp_text(const scp_text& x)
:m_nMinX(x.m_nMinX)
,m_nMinY(x.m_nMinY)
,m_nMaxX(x.m_nMaxX)
,m_nMaxY(x.m_nMaxY)
,m_strStaticText(x.m_strStaticText)
,m_bCommsDependant(x.m_bCommsDependant)
,m_strCommsKey(x.m_strCommsKey)
,m_strType(x.m_strType)
,m_strPrecision(x.m_strPrecision)
,m_strWidth(x.m_strWidth)
{
}

scp_text& scp_text::operator=(const scp_text* rhs)
{
	if(this == rhs)return *this;

	m_nMinX = rhs->m_nMinX;
	m_nMinY = rhs->m_nMinY;
	m_nMaxX = rhs->m_nMaxX;
	m_nMaxY = rhs->m_nMaxY;
	
	m_strStaticText = rhs->m_strStaticText;

	m_bCommsDependant = rhs->m_bCommsDependant;
	m_strCommsKey = rhs->m_strCommsKey;

	m_strType = rhs->m_strType;
	m_strPrecision = rhs->m_strPrecision;
	m_strWidth = rhs->m_strWidth;

	return *this;
}

scp_text& scp_text::operator=(const scp_text& rhs)
{
	if(this == &rhs)return *this;

	m_nMinX = rhs.m_nMinX;
	m_nMinY = rhs.m_nMinY;
	m_nMaxX = rhs.m_nMaxX;
	m_nMaxY = rhs.m_nMaxY;

	m_strStaticText = rhs.m_strStaticText;
	
	m_bCommsDependant = rhs.m_bCommsDependant;
	m_strCommsKey = rhs.m_strCommsKey;
	
	
	m_strType = rhs.m_strType;
	m_strPrecision = rhs.m_strPrecision;
	m_strWidth = rhs.m_strWidth;
	
	return *this;
}

bool scp_text::operator==(const scp_text& rhs)
{
	if(	
		m_nMinX == rhs.m_nMinX && 
		m_nMinY == rhs.m_nMinY &&
		m_nMaxX == rhs.m_nMaxX && 
		m_nMaxY == rhs.m_nMaxY && 
		m_strStaticText == rhs.m_strStaticText &&
		m_bCommsDependant == rhs.m_bCommsDependant &&
		m_strCommsKey == rhs.m_strCommsKey &&
		m_strType == rhs.m_strType &&
		m_strWidth == rhs.m_strWidth &&
		m_strPrecision == rhs.m_strPrecision
		)

		return true;
	
	return false;
}

bool scp_text::operator==(scp_text* rhs)
{
	if(	
		m_nMinX == rhs->m_nMinX && 
		m_nMinY == rhs->m_nMinY &&
		m_nMaxX == rhs->m_nMaxX && 
		m_nMaxY == rhs->m_nMaxY && 
		m_strStaticText == rhs->m_strStaticText &&
		m_bCommsDependant == rhs->m_bCommsDependant &&
		m_strCommsKey == rhs->m_strCommsKey &&
		m_strType == rhs->m_strType &&
		m_strWidth == rhs->m_strWidth &&
		m_strPrecision == rhs->m_strPrecision
		)
		return true;
	
	return false;
}

scp_text::~scp_text()
{
//	m_vrtvecCommsVariants.clear();
}


std::string scp_text::GetCommsKey(void)
{
	return m_strCommsKey;
}

bool scp_text::IsCommsDependant(void)
{
	return m_bCommsDependant;
}

void scp_text::AddCommsDisplay(std::string strCommsKey)
{
	m_bCommsDependant=true;
	m_strCommsKey = strCommsKey;
}

char scp_text::GetDatatype(void)
{
	return m_strType[0];
}

void scp_text::GetTopLeft(int& nX, int& nY)
{
	nX = m_nMinX;
	nY = m_nMinY;
}

void scp_text::GetBottomRight(int& nX, int& nY)
{
	nX = m_nMaxX;
	nY = m_nMaxY;
}

int scp_text::GetPrecision(void)
{
	return atoi(m_strPrecision.c_str());
}

void scp_text::GetPrecision(std::string& strPrecision)
{
	strPrecision  = m_strPrecision;
}

int scp_text::GetWidth(void)
{
	return atoi(m_strWidth.c_str());
}

void scp_text::GetWidth(std::string& strWidth)
{
	strWidth = m_strWidth;
}

std::string scp_text::GetAssociatedText(std::string strVal)
{
	std::map<std::string, std::string> str2strAssocMap;
	
	std::string csBuffer = m_strWidth;

	str_vec csvParameters;

	int nStartGoodData=0, nEndGoodData=0, nBufferLength = csBuffer.length();
	char chBufferSentinels[] = {','};				
		
	if(nBufferLength > 0)
	{
		while(nStartGoodData >= 0)
		{
			nEndGoodData = csBuffer.find_first_of(chBufferSentinels, nStartGoodData, sizeof(chBufferSentinels));
			
			std::string csTemp = csBuffer;
			csvParameters.push_back(csTemp.substr(nStartGoodData, (nEndGoodData - nStartGoodData)));

			nStartGoodData = csBuffer.find_first_not_of(chBufferSentinels, nEndGoodData, sizeof(chBufferSentinels));
		}
	}

	for(str_vec_iter sviIter = csvParameters.begin(); sviIter != csvParameters.end(); sviIter++)
	{
		std::string csParameter;
		std::string csValue;

		int nIndex;
		char chSentinels[] = {'='};
		
		nIndex = (*sviIter).find_first_of(chSentinels, 0, sizeof(chSentinels));

		if(nIndex)
		{
			csValue = (*sviIter).substr(0, nIndex);
			csParameter = (*sviIter).substr(++nIndex, (*sviIter).length());						
		
			if(str2strAssocMap.find(csValue) == str2strAssocMap.end())
			{
				str2strAssocMap[csValue] = csParameter;
			}
		}

	}

	std::string strClean;

	if(str2strAssocMap.find(strVal) != str2strAssocMap.end())
	{
		std::string strTemp;
		strTemp = str2strAssocMap[strVal];
		
		for(int c=0; c<(GetPrecision() - strTemp.length());c++)
			strClean += " ";

		strClean += strTemp;
	}
	else
	{
		for(int c=0; c<GetPrecision();c++)
			strClean += " ";
	}

	return strClean;
}

std::string scp_text::Highlight(std::string strVal)
{
	std::map<std::string, std::string> str2strAssocMap;
	
		std::string csBuffer(m_strWidth);

		str_vec csvParameters;

		int nStartGoodData=0, nEndGoodData=0, nBufferLength = csBuffer.length();
		char chBufferSentinels[] = {','};				
			
		if(nBufferLength > 0)
		{
			while(nStartGoodData >= 0)
			{
				nEndGoodData = csBuffer.find_first_of(chBufferSentinels, nStartGoodData, sizeof(chBufferSentinels));
				
				std::string csTemp = csBuffer;
				csvParameters.push_back(csTemp.substr(nStartGoodData, (nEndGoodData - nStartGoodData)));

				nStartGoodData = csBuffer.find_first_not_of(chBufferSentinels, nEndGoodData, sizeof(chBufferSentinels));
			}
		}
		else
		{
			std::string strClean;
			for(int c=0; c<GetPrecision();c++)
				strClean += " ";
		}

		std::string strClean;
		for(int c=0; c<GetPrecision();c++)
			strClean += " ";

		for(str_vec_iter sviIter = csvParameters.begin(); sviIter != csvParameters.end(); sviIter++)
		{
			std::string csParameter;
			std::string csValue;

			int nIndex;
			char chSentinels[] = {'='};
			
			nIndex = (*sviIter).find_first_of(chSentinels, 0, sizeof(chSentinels));

			if(nIndex)
			{
				csValue = (*sviIter).substr(0, nIndex);
				csParameter = (*sviIter).substr(++nIndex, (*sviIter).length());						
			
				if(str2strAssocMap.find(csValue) == str2strAssocMap.end())
				{
					str2strAssocMap[csValue] = csParameter;
					if(strcmp(strVal.c_str(), csValue.c_str()) == 0){
						strClean = csParameter;
					}
				}
			}
		}

		/*if(str2strAssocMap.find(strVal) != str2strAssocMap.end())
			return str2strAssocMap[strVal];
		else*/
			return strClean;
}

std::string scp_text::GetStaticDraw(void)
{
	return m_strStaticText;
}	


