// ScpImage.h: interface for the ScpImage class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SCPIMAGE_H__736F1581_19F5_11D4_9041_00500412025F__INCLUDED_)
#define AFX_SCPIMAGE_H__736F1581_19F5_11D4_9041_00500412025F__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <vector>
#include <map>
#include <string>

#include "ScpWidget.h"

const int gc_nMaxDisplayableRows(16);
const int gc_nMaxDisplayableColumns(32);

const int gc_nMaxDisplayablecells(gc_nMaxDisplayableRows * gc_nMaxDisplayableColumns);

const int gc_nMaxLogicalRows(32);
const int gc_nMaxLogicalColumns(32);

const int gc_nMaxLogicalCells(gc_nMaxLogicalRows * gc_nMaxLogicalColumns);

typedef std::vector<std::string> str_vec;

class scp_image
{
private:

	std::vector<std::string> m_strvecTxBuffer;

	void BuildTxBuffer(void);

public:
	std::string m_strCurrentPageTitle;

	scp_image();
	
	~scp_image();
	
	scp_image(scp_image* p);

	scp_image(scp_image& x);
	
	scp_image& operator=(const scp_image* rhs);
	
	scp_image& operator=(const scp_image& rhs);
	
	bool operator==(const scp_image& rhs);
	
	bool operator==(const scp_image* rhs);

	void AddWidgetVector(sw_vec swvWidgetVec);

	std::vector<std::string> GetAsSerialTxBuffer(void);
};

typedef std::vector<scp_image*> si_vec;
typedef si_vec::iterator si_vec_iter;

typedef std::map<int, scp_image*> int_to_si_map;
typedef int_to_si_map::iterator int_to_si_map_iter;

typedef std::map<std::string, scp_image*> str_to_si_map;
typedef str_to_si_map::iterator str_to_si_map_iter;

#endif // !defined(AFX_SCPIMAGE_H__736F1581_19F5_11D4_9041_00500412025F__INCLUDED_)
