// ScpImage.cpp: implementation of the ScpImage class.
//
//////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#include "ScpImage.h"


#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

scp_image::scp_image()
{
}

scp_image::~scp_image()
{
	m_strvecTxBuffer.clear();
}

void scp_image::AddWidgetVector(sw_vec stwWidgetVector)
{
	std::string strTemp;

	//clear vector of write strings
	m_strvecTxBuffer.clear();

	/*for(int i=0;i<3;i++)
	{
		// command clear screen 
		//   NOTE: 3 times because occasionally during testing subsequent draw
		//   commands were performed by device before screen was actually clean.
		//   From what I can tell this is a less processor intensive approach
		//   than sending a full screen worth of chars out to the comport.  This
		//   approach also significantly simplifies the draw update of comms data
		//   when a very limited section of the screen needs updated.
		strTemp = "\033[E";
		m_strvecTxBuffer.push_back(strTemp);	
	}

	m_strvecTxBuffer.push_back(strTemp);	*/
	//-----------------------------------------

	//add title centered on top row
	int nOffset = ((gc_nMaxDisplayableColumns - m_strCurrentPageTitle.length()) / 2);
	strTemp="\033[E";
	for(int n=0;n<nOffset;n++)
	{
		strTemp+=" ";
	}
	strTemp += m_strCurrentPageTitle + "\r\n";
	m_strvecTxBuffer.push_back(strTemp);
	//------------------------------------------

	//put widgets member text into this image in appropriate location
	for(sw_vec_iter swviIter = stwWidgetVector.begin(); 
					swviIter != stwWidgetVector.end(); 
					swviIter++)
	{
		//let widget build it's draw string and push it onto the vector
		m_strvecTxBuffer.push_back((*swviIter)->BuildDrawCommand());
	}
	//---------------------------------------------
}

std::vector<std::string> scp_image::GetAsSerialTxBuffer(void)
{
	return m_strvecTxBuffer;
}