// ScpEvent.h: interface for the ScpEvent class.
//
//////////////////////////////////////////////////////////////////////

#ifndef SCP_EVENT_H
#define SCP_EVENT_H

#include <vector>
#include <map>
#include <string>

typedef std::vector<std::string> str_vec;
typedef str_vec::iterator str_vec_iter; 
/*
struct state_dependant_command
{
	std::string strLeftParam;
	std::string strOperator;
	std::string strRightParam;
}

typedef std::vector<state_dependant_command*> sdc_vec;
typedef sdc_vec::iterator sdc_iter;
*/
class scp_event  
{
private:
	std::string m_strScope;
	std::string m_strType;//sub-type

	//page link members
	std::string m_strName;
	std::string m_strButtonLabel;

	//dialogue members
	std::string m_strTitle;
	std::string m_strSymbolName;
	std::string	m_strRangeMin;
	std::string m_strRangeMax;
	std::string m_strDataType;

	//command members
	std::string m_strValue;
	std::string m_strMode;
	//symbol name
	//datatype

public:
	scp_event();
	scp_event(std::string strScope, std::string strType, std::string strName, std::string strButtonValue);
	scp_event(scp_event* p);
	scp_event(scp_event& x);

	scp_event& operator=(const scp_event* rhs);
	scp_event& operator=(const scp_event& rhs);
	bool operator==(const scp_event& rhs);
	bool operator==(const scp_event* rhs);
	virtual ~scp_event();

	void AddCommand(std::string strSymbolName, std::string strValue, std::string strDataType);

	void AddSelect(std::string strSymbolName, std::string strValue, std::string strDataType, std::string strMode);

	void AddDialogue(std::string strTitle, std::string strSymbolName, std::string strRangeMin, std::string strRangeMax, std::string strDataType);

	void AddToggle(std::string strTitle, std::string strDataType);

//	void AddStateDependantCommand(std::string strSymbolName, sdc_vec sdcvecConditions);

	std::string GetSerialEventKey(void);

	std::string SerialKeyUpdate(void);

	bool HasPageLink(void);

	bool HasDialogue(void);

	bool HasCommand(void);

	bool HasSelect(void);

	bool HasStateDependantCommand(void);

	bool HasToggle(void);

	str_vec BuildDialogueDrawCommands(void);

	std::string GetButtonLabel(void);

	std::string GetSymbolName(void);

	std::string GetCommandValue(void);

	double GetMax(void);

	double GetMin(void);

	void SetMax(std::string);

	void SetMin(std::string);

	bool IsModal(void);
};


typedef std::vector<scp_event*> se_vec;
typedef se_vec::iterator se_vec_iter;
/*
typedef std::map<int, scp_event*> int_to_se_map;
typedef int_to_se_map::iterator int_to_se_map_iter;
*/
typedef std::map<std::string, scp_event*> str_to_se_map;
typedef str_to_se_map::iterator str_to_se_map_iter;

#endif