// ScpEvent.cpp: implementation of the ScpEvent class.
//
//////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#include "ScpEvent.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

scp_event::scp_event()
{
}

scp_event::scp_event(std::string strScope, std::string strType, std::string strName, std::string strButtonLabel)
:m_strScope(strScope)
,m_strType(strType)
,m_strName(strName)
,m_strButtonLabel(strButtonLabel)
{
}

scp_event::scp_event(scp_event* p)
{
m_strScope = p->m_strScope;
m_strType = p->m_strType;
m_strName = p->m_strName;
m_strButtonLabel = p->m_strButtonLabel;
m_strTitle = p->m_strTitle;
m_strRangeMin = p->m_strRangeMin;
m_strRangeMax = p->m_strRangeMax;
m_strSymbolName = p->m_strSymbolName;
m_strValue = p->m_strValue;
m_strDataType = p->m_strDataType;
m_strMode = p->m_strMode;
}

scp_event::scp_event(scp_event& x)
{
m_strScope = x.m_strScope;
m_strType = x.m_strType;
m_strName = x.m_strName;
m_strButtonLabel = x.m_strButtonLabel;
m_strTitle = x.m_strTitle;
m_strRangeMin = x.m_strRangeMin;
m_strRangeMax = x.m_strRangeMax;
m_strSymbolName = x.m_strSymbolName;
m_strValue = x.m_strValue;
m_strDataType = x.m_strDataType;
m_strMode = x.m_strMode;
}

scp_event& scp_event::operator=(const scp_event* rhs)
{
	if(this == rhs)return *this;

	m_strScope = rhs->m_strScope;
	m_strType = rhs->m_strType;
	m_strName = rhs->m_strName;
	m_strButtonLabel = rhs->m_strButtonLabel;
	m_strTitle = rhs->m_strTitle;
	m_strRangeMin = rhs->m_strRangeMin;
	m_strRangeMax = rhs->m_strRangeMax;
	m_strSymbolName = rhs->m_strSymbolName;
	m_strValue = rhs->m_strValue;
	m_strDataType = rhs->m_strDataType;
	m_strMode = rhs->m_strMode;

	return *this;
}

scp_event& scp_event::operator=(const scp_event& rhs)
{
	if(this == &rhs)return *this;

	m_strScope = rhs.m_strScope;
	m_strType = rhs.m_strType;
	m_strName = rhs.m_strName;
	m_strButtonLabel = rhs.m_strButtonLabel;
	m_strTitle = rhs.m_strTitle;
	m_strRangeMin = rhs.m_strRangeMin;
	m_strRangeMax = rhs.m_strRangeMax;
	m_strSymbolName = rhs.m_strSymbolName;
	m_strValue = rhs.m_strValue;
	m_strMode = rhs.m_strMode;

	return *this;
}

bool scp_event::operator==(const scp_event& rhs)
{
	if(	m_strScope == rhs.m_strScope && 
		m_strType == rhs.m_strType &&
		m_strName == rhs.m_strName &&
		m_strButtonLabel == rhs.m_strButtonLabel
	  )
		return true;

return false;
}

bool scp_event::operator==(const scp_event* rhs)
{
	if(	m_strScope == rhs->m_strScope && 
		m_strType == rhs->m_strType &&
		m_strName == rhs->m_strName &&
		m_strButtonLabel == rhs->m_strButtonLabel //&& 
//		m_nSerialValue == rhs->m_nSerialValue
	  )
		return true;

return false;
}

scp_event::~scp_event()
{

}

std::string scp_event::GetSerialEventKey(void)
{
	return m_strButtonLabel;
}

std::string scp_event::GetSymbolName(void)
{
	return m_strSymbolName;
}

std::string scp_event::SerialKeyUpdate(void)
{
	return m_strName;
}

void scp_event::AddDialogue(std::string strTitle, std::string strSymbolName, std::string strRangeMin, std::string strRangeMax, std::string strDataType)
{
	m_strTitle=strTitle;
	m_strSymbolName=strSymbolName;
	m_strRangeMin=strRangeMin;
	m_strRangeMax=strRangeMax;
	m_strDataType= strDataType;
}

void scp_event::AddCommand(std::string strSymbolName, std::string strValue, std::string strDataType)
{
	m_strValue=strValue;
	m_strSymbolName=strSymbolName;
	m_strDataType=strDataType;
}

void scp_event::AddSelect(std::string strSymbolName, std::string strValue, std::string strDataType, std::string strMode)
{
	m_strValue=strValue;
	m_strSymbolName=strSymbolName;
	m_strDataType=strDataType;
	m_strMode=strMode;
}


/*
void AddStateDependantCommand(std::string strSymbolName, sdc_vec sdcvecConditions);
{
	m_strSymbolName=strSymbolName;

	for(sdc_vec_iter sdcvecIter = sdcvecConditions.begin(); sdcvecIter != sdcvecConditions.end(); sdcvecIter++)
	{
			sdcvecIter.m_strLeftParam;
			sdcvecIter.m_strOperator;
			sdcvecIter.m_strRightParam;
	}
}
*/

void scp_event::AddToggle(std::string strSymbolName, std::string strDataType)
{
	m_strSymbolName = strSymbolName;
	m_strDataType = strDataType;
}

str_vec scp_event::BuildDialogueDrawCommands(void)
{
	str_vec strvecCommands;

	std::string strCommand;
	strCommand = m_strTitle;
	strvecCommands.push_back(strCommand);

	if(m_strRangeMin.length() || m_strRangeMax.length())
	{
		strCommand = "    Min:" + m_strRangeMin + "       Max:" + m_strRangeMax;
		strvecCommands.push_back(strCommand);
	}

	return strvecCommands;
}

bool scp_event::HasPageLink(void)
{
	return bool(m_strType == "PageLink");
}

bool scp_event::HasDialogue(void)
{
	return bool(m_strType == "CommsDialog");
}

/*
bool scp_event::HasStateDependantCommand(void)
{
	return bool(m_strType == "StateDependantCommand");
}
*/

bool scp_event::HasCommand(void)
{
	return bool(m_strType == "Command");
}

bool scp_event::HasSelect(void)
{
	return bool(m_strType == "Select");
}

bool scp_event::HasToggle(void)
{
	return bool(m_strType == "Toggle");
}

std::string scp_event::GetButtonLabel(void)
{
	return m_strButtonLabel;
}

std::string scp_event::GetCommandValue(void)
{
	return m_strValue;
}

bool scp_event::IsModal(void)
{
	return bool(m_strMode == "True");
}

double scp_event::GetMax(void)
{
	return atof(m_strRangeMax.c_str());
}

double scp_event::GetMin(void)
{
	return atof(m_strRangeMin.c_str());
}

void scp_event::SetMax(std::string strMax)
{
	m_strRangeMax = strMax;
}

void scp_event::SetMin(std::string strMin)
{
	m_strRangeMin = strMin;
}