// ScpDialog.cpp: implementation of the ScpDialog class.
//
//////////////////////////////////////////////////////////////////////

#include "ScpDialog.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
scp_dialog::scp_dialog()

scp_dialog::scp_dialog(std::string strTitle, std::string strMax, std::string strMin)
:m_dDialogueMax(atof(strMax))
,m_dDialogueMin(atof(strMin))
,m_bRangeExists(false)
,m_strTitle(strTitle)
{
	if(m_dDialogueMax < m_dDialogueMin)
	{
		double dTemp = m_dDialogueMax;
		m_dDialogueMax = m_dDialogueMin;
		m_dDialogueMin = dTemp;

		std::string strTemp = strMax;
		strMin = strMax;
		strMax = strTemp;
	}

	m_bDialogueRangeExists=false;
	if(m_dDialogueMax-m_dDialogueMin>0)
	{
		m_bDialogueRangeExists = true;
	}

	strvecCommands.push_back(strCommand);

	if(strRangeMin.length() || strRangeMax.length())
	{
		strCommand = "    Min:" + strRangeMin + "       Max:" + strRangeMax;
		strvecCommands.push_back(strCommand);
	}
}

scp_dialog::~scp_dialog()
{

}

void scp_dialog::Update(const int nCurrentInput, bool& bUpdateRequiredFlag)
{
		int nCurrentInput = (int)((const char)strInput[0]);
		switch(nCurrentInput)
		{
			case 13://ok
			{
				m_bDialogueActive=false;
				
		
				if(m_nDialogueCount>0)
				{
					double dTemp = atof(m_strDialogueEntry.c_str());
					if(dTemp>=m_dDialogueMin && dTemp<=m_dDialogueMax)
					{
						gbl_dtxiCommsIO.Write(m_strCurrentDialogueSymbol, m_strDialogueEntry);
					}
				}
				
				m_nDialogueCount=0;
				m_strDialogueEntry="";
				m_strCurrentDialogueSymbol="";
				m_strvecDialogueCommands.clear();

				UpdateScreen(m_strPageName);			
			}
			break;

			case 88://.
			{
				if(m_nDialogueCount < m_strDialogueEntry.length())
				{
					m_strDialogueEntry.insert(m_nDialogueCount, ".");
				}
				else
				{
					m_strDialogueEntry += strReadString;
				}
				
				m_nDialogueCount = m_strDialogueEntry.length();
			}
			break;

			case 89://apply
			case 34:
			{
				
				if(m_nDialogueCount>0)
				{
					double dTemp = atof(m_strDialogueEntry.c_str());
					if(dTemp>=m_dDialogueMin && dTemp<=m_dDialogueMax)
					{
						gbl_dtxiCommsIO.Write(m_strCurrentDialogueSymbol, m_strDialogueEntry);
					}
				}
				
				m_nDialogueCount=0;
				m_strDialogueEntry="";
				DialogueMode();
			}
			break;

			case 27:
			case 90://cancel
			{
				m_bDialogueActive=false;
				m_nDialogueCount=0;
				m_strDialogueEntry="";
				m_strCurrentDialogueSymbol="";
				m_strvecDialogueCommands.clear();
				
				UpdateScreen(m_strPageName);
			}
			break;

			case 32://backspace
			{
				if(m_nDialogueCount>0)
				{
					m_nDialogueCount--;
					
					if(m_nDialogueCount < m_strDialogueEntry.length())
					{
						std::string strTemp = m_strDialogueEntry.substr(0, m_nDialogueCount);
						strTemp += m_strDialogueEntry.substr(m_nDialogueCount + 1, m_strDialogueEntry.length());
						m_strDialogueEntry = strTemp;
					}
					else
					{
						m_strDialogueEntry = m_strDialogueEntry.substr(0, m_strDialogueEntry.length() - 1);
					}
					DialogueMode();
				}
			}
			break;

			case 72:
			case 70:// H or F interpreted as -
			{
				if(m_strDialogueEntry.length()==0)
				{
					m_strDialogueEntry = "-";
					m_nDialogueCount++;
				}
			}
			break;

			//left
			case 60:
			case 68:
			{
				if(m_strDialogueEntry.length()>0 && m_nDialogueCount>0)
				{
					m_nDialogueCount--;
				}
			}
			break;

			//right
			case 62:
			case 69:
			{
				if(m_strDialogueEntry.length()>0)
				{
					m_nDialogueCount++;
				}
			}
			break;

			default://alphanumeric
			{
				if(m_nDialogueCount < m_strDialogueEntry.length())
				{
					m_strDialogueEntry.insert(m_nDialogueCount, strReadString);
				}
				else
				{
					m_strDialogueEntry += strReadString;
					m_nDialogueCount = m_strDialogueEntry.length();
				}
			}
			break;
		}
	}
}


void scp_dialog::Refresh(std::string& strRefreshCommand)
{
	strRefreshCommand = "\033[16;0H\033[4t";
	std::string strOffset = "          >";
	m_nDialogueOffset = strOffset.length() + 1;
	strTemp += strOffset;
	strTemp += m_strDialogueEntry;
}