// data_transfer_interface.h: interface for the data_transfer_interface class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_data_transfer_interface_H__D2FD0613_1719_11D4_9040_00500412025F__INCLUDED_)
#define AFX_data_transfer_interface_H__D2FD0613_1719_11D4_9040_00500412025F__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "..\comms\CommsShared.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


typedef std::vector<CVariant*> vrt_vec;
typedef vrt_vec::iterator vrt_vec_iter;

typedef std::map<std::string, CVariant*> str2vrt_map;
typedef str2vrt_map::iterator str2vrt_map_iter;

typedef std::map<std::string, std::string> str2str_map;
typedef str2str_map::iterator str2str_map_iter;

class data_transfer_interface  
{
//This allows the CALLBACK routine to call the privately declared member functions in this class.
// ... namely Update()
friend void UpdateDTI();

private:
	static CCriticalSection m_syncUpdateCallback;
	
	str2vrt_map m_str2vrtmapReadVariants;
	str2vrt_map m_str2vrtmapWriteVariants;

//	void SetHostValue(CVariant& rVariant, _FSI_STL::string& rstlStrVarName, unsigned long ulOffset);


	//  Update will once per call from UpdateDTI() perform data transfer for all registered symbols
	//  by calling on (Get/Set)HostValue functions and subsequently informing associated widgets of 
	//  activity.
	void Update(void);

	bool m_bExists;
/*
protected:

	void SetHostReal(std::string  pcVariableName,float *pfValue);

	void SetHostInt(std::string strVarName, int *pnValue);

	void SetHostRealArray(std::string pcVariableName, int* pnArrayLength, float *pfArray);

	void SetHostIntArray(std::string pcVariableName, int* pnArrayLength, int* pnArray);
*/

public:

	data_transfer_interface(void);

	virtual ~data_transfer_interface(void);

	void RegisterGlobalVariable(void);

	void RegisterPageVariable(std::string strSymbolName, char chVarType);

	void RegisterWriteVariable(std::string strSymbolName, int nVarType, std::string strMin, std::string strMax);

	void RegisterWriteVariable(std::string strSymbolName, int nVarType);

	bool Read(std::string strSymbolName, std::string& strVal);

	void ClearGlobalVariables(void);

	void ClearPageVariables(void);

	void Write(std::string strVariableName, std::string strWriteData);
};

//global host data communications transfer interface
extern data_transfer_interface gbl_dtxiCommsIO;


#endif // !defined(AFX_data_transfer_interface_H__D2FD0613_1719_11D4_9040_00500412025F__INCLUDED_)
