// DataTransferInterface.cpp: implementation of the DataTransferInterface class.
//
//////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"

#include "DataTransferInterface.h"

/*
enum
{
    VAR_UNKNOWN                 = -1,
    VAR_CHAR                    =  0,
    VAR_UNSIGNED_CHAR           =  1,
    VAR_SHORT_INT               =  2,
    VAR_UNSIGNED_SHORT_INT      =  3,
    VAR_LONG_INT                =  4,
    VAR_UNSIGNED_LONG_INT       =  5,
    VAR_FLOAT                   =  6,
    VAR_DOUBLE                  =  7,
    VAR_BOOL                    =  8,
    VAR_STRING                  =  9
};
*/

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
CCriticalSection data_transfer_interface::m_syncUpdateCallback;

data_transfer_interface::data_transfer_interface()
{
}

data_transfer_interface::~data_transfer_interface()
{
}

void data_transfer_interface::Update(void)
{
	m_syncUpdateCallback.Lock();

	for(str2vrt_map_iter str2vrtmapIter = m_str2vrtmapReadVariants.begin(); str2vrtmapIter != m_str2vrtmapReadVariants.end(); str2vrtmapIter++){
		if((str2vrtmapIter->second) != NULL){
			int nType((str2vrtmapIter->second)->Type());
			int nIndex(0);
			std::string strBaseName(str2vrtmapIter->first);
			int nArrayStartPos(strBaseName.find("[", 0));
			int nArrayStopPos(0);
			
			if(nArrayStartPos > 2){
				nArrayStopPos = strBaseName.find("]", nArrayStartPos);

				if(nArrayStopPos > nArrayStartPos+1){
					std::string strIndex(strBaseName.substr(nArrayStartPos+1, nArrayStopPos - nArrayStartPos - 1));
					nIndex = atol(strIndex.c_str());

					nArrayStopPos = nArrayStopPos - nArrayStartPos - 1;
					strBaseName = strBaseName.substr(0, nArrayStartPos);
				}
			}

			CVariant* pVariant = CCommsShared::FindVariant(strBaseName);
			//ATS - 7-2-2001 ... adding local comms
			if(pVariant==NULL){
				pVariant = CCommsShared::FindLocalVariant(strBaseName);
			}

			if(pVariant != NULL){
				CVariant vTemp(*pVariant);
				if(nIndex > 0){
					vTemp = ((*pVariant)[nIndex]);
				}

				if(&vTemp != NULL){
					switch(nType){
						case VAR_STRING:{
							(str2vrtmapIter->second)->Value((std::string)vTemp);
						}break;

						case VAR_SHORT_INT:{
							(str2vrtmapIter->second)->Value((long int)vTemp);
						}break;
						   
						case VAR_LONG_INT:{
							(str2vrtmapIter->second)->Value((long)vTemp);
						}break;

						case VAR_FLOAT:{
						   (str2vrtmapIter->second)->Value((float)vTemp);
						}break;

						case VAR_DOUBLE:{
						   (str2vrtmapIter->second)->Value((double)vTemp);
						}break;

						case VAR_BOOL:{
							(str2vrtmapIter->second)->Value((bool)vTemp);
						}break;

						default:{
							(str2vrtmapIter->second)->Value((std::string)vTemp);
						}break;
					}
				}
			}
		}
	}
	
	m_syncUpdateCallback.Unlock();
}

bool data_transfer_interface::Read(std::string strSymbolName, std::string& strVal)
{
	bool bRetFlag(false);

	m_syncUpdateCallback.Lock();

	str2vrt_map_iter str2vrtmapIter = m_str2vrtmapReadVariants.find(strSymbolName);
	if(str2vrtmapIter != m_str2vrtmapReadVariants.end()){
		if((*str2vrtmapIter).second != NULL){
			strVal = std::string(*(*str2vrtmapIter).second);
			bRetFlag = true;
		}
	}
	m_syncUpdateCallback.Unlock();
	
	return bRetFlag;
}

void data_transfer_interface::RegisterPageVariable(std::string strSymbolName, char chVarType)
{
	int nIndex(0);
	int nArrayStartPos(strSymbolName.find("[", 0));
	int nArrayStopPos(strSymbolName.find("]", nArrayStartPos));

	if(nArrayStartPos > 2 && nArrayStopPos > nArrayStartPos+1){
		nArrayStopPos = nArrayStopPos - nArrayStartPos - 1;

		std::string strIndex(strSymbolName.substr(nArrayStartPos + 1, nArrayStopPos));
		nIndex = atol(strIndex.c_str());
	}

	if(m_str2vrtmapReadVariants.find(strSymbolName) == m_str2vrtmapReadVariants.end()){
		CVariant* pVariant = new CVariant();
		
		switch(chVarType){
			case 's':{
				pVariant->ChangeType((long)VAR_STRING);
			}break;

			case 'd':
			case 'h':{
				pVariant->ChangeType((long)VAR_LONG_INT);
			}break;
		
			case 'f':{
				pVariant->ChangeType((long)VAR_FLOAT);
			}break;

			case 'a':{
				pVariant->ChangeType((long)VAR_LONG_INT);
			}break;

			default:{
				pVariant->ChangeType((long)VAR_STRING);
			}break;
		}

		m_str2vrtmapReadVariants[strSymbolName] = pVariant;
	}
}

void data_transfer_interface::RegisterWriteVariable(std::string strSymbolName, int nVarType)
{
	if(m_str2vrtmapWriteVariants.find(strSymbolName) == m_str2vrtmapWriteVariants.end())
	{
		CVariant* pVariant = new CVariant();
		pVariant->ChangeType((long)nVarType);
		m_str2vrtmapWriteVariants[strSymbolName] = pVariant;
	}
}

void data_transfer_interface::ClearPageVariables(void)
{
	for(str2vrt_map_iter str2vrtmapIter = m_str2vrtmapReadVariants.begin(); str2vrtmapIter != m_str2vrtmapReadVariants.end(); str2vrtmapIter++)
	{
		delete (str2vrtmapIter->second);
	}
	m_str2vrtmapReadVariants.clear();

	for(str2vrt_map_iter str2vrtmapIter2 = m_str2vrtmapWriteVariants.begin(); str2vrtmapIter2 != m_str2vrtmapWriteVariants.end(); str2vrtmapIter2++)
	{
		delete (str2vrtmapIter2->second);
	}
	m_str2vrtmapWriteVariants.clear();
}

void data_transfer_interface::Write(std::string strSymbolName, std::string strWriteData)
{
	bool bHost(true);
	//it's always a string from my end regardless so I'm going to make sure it exists
	//on the other end, build a temporary variant of the type that matches the other
	//end of the wire and send that variant down the line.
	CVariant* pVariant = CCommsShared::FindVariant(strSymbolName);
	if(pVariant==NULL){
		pVariant = CCommsShared::FindLocalVariant(strSymbolName);
		bHost = false;
	}

	//ATS - adding local comms 7-2-2001
	CVariableData* pVarData;
	if(bHost){//host
		pVarData = CCommsShared::FindVariableData(strSymbolName);
	}
	else{//local
		pVarData = CCommsShared::FindLocalVariableData(strSymbolName);
	}

	CVariant variant;

	if(pVariant==NULL || pVarData==NULL)
		return;

	unsigned long ulType = pVariant->Type();
	switch(ulType)
	{
		case VAR_STRING:
		{
			variant.Value(strWriteData);
		}
		break;
	
		case VAR_LONG_INT:
		{
			variant.Value(atol(strWriteData.c_str()));
		}
		break;
	
		case VAR_FLOAT:
		{
			variant.Value((float)atof(strWriteData.c_str()));
		}
		break;

		case VAR_DOUBLE:
		{
			variant.Value(atof(strWriteData.c_str()));
		}
		break;

		case VAR_BOOL:
		{
			//variant.Value((bool)atoi(strWriteData.c_str()));
         variant.Value((bool)(atoi(strWriteData.c_str()) != 0));
		}
		break;

		default:
			//variant.Value(strWriteData);
			//variant.Value((bool)atoi(strWriteData.c_str()));
         variant.Value((bool)(atoi(strWriteData.c_str()) != 0));
		break;
	}

    unsigned long ulCurrentOffset = pVarData->ArrayOffset();
    pVarData->ArrayOffset(0);

	//ATS - adding local comms 7-2-2001
    // Call the instantiated CCommsSystemInterface derived class' 
    // WriteData member to update simulation.
	if(bHost){//host
		CCommsShared::m_pCommsSystemInterface->WriteData(&variant, pVarData);
	}
	else{//local
		CCommsShared::m_pLocalCommsSystemInterface->WriteData(&variant, pVarData, INDEPENDENT_VARIABLE);
	}

    pVarData->ArrayOffset(ulCurrentOffset);
}