// WeatherControl.h: interface for the CWeatherControl class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_WEATHERCONTROL_H__BC715E71_16C8_11D4_9422_00600895DE54__INCLUDED_)
#define AFX_WEATHERCONTROL_H__BC715E71_16C8_11D4_9422_00600895DE54__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "WeatherArea.h"

const int m_num_wx_areas = 4;



class CWeatherControl  
{
public:
	static void Update();

private:
	static bool m_isAnyActive;
	static int m_wxApplyTimer;
   static void SetApplyTimer(float numSeconds);
	static int m_ActiveArea;
	static double m_dLongitude;
	static double m_dLatitude;
   static int m_nHostRate;
   static CWeatherArea m_area[m_num_wx_areas];
   static void SendNewWeatherToHost();
   static void SendAreaInfoToMap();
   static void SendATISInformation();
   static void LoadSortieAreaData();
   static long m_last_wx_mode;
   static long m_wx_mode;
   static bool m_wxOff;
   static bool m_wx_loadCmd;

};

#endif // !defined(AFX_WEATHERCONTROL_H__BC715E71_16C8_11D4_9422_00600895DE54__INCLUDED_)
