/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : weatherArea.h
//
// Date             : 30 March 2000
//
// Engineer         : Michael F Lawson
//
// Revision         : $
//
// Description      : Holds the values for the four weather areas as preset
//                    by the sortie file.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : 

// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
//
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(WEATHERAREA_H)
#define WEATHERAREA_H

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

enum {VIS_DAWN    =1, VIS_DAY        =2, VIS_DUSK     =3, VIS_NIGHT     =4};
enum {CLOUD_CLEAR =0, CLOUD_SCATTERED=1, CLOUD_BROKEN =2, CLOUD_OVERCAST=3};
enum {FOG_OFF     =0, FOG_SOLID      =1, FOG_PATCHY   =2                  };
enum {PRECIP_NONE =0, PRECIP_RAIN    =1, PRECIP_SNOW  =2                  };
enum {PRECIP_LIGHT=1, PRECIP_MEDIUM  =2, PRECIP_HEAVY =3                  };
enum {RWY_DRY     =0, RWY_WET        =1, RWY_SNOW     =2, RWY_ICE       =3,
      RWY_SLUSH   =4, RWY_PCHY_WET   =5, RWY_PCHY_SNOW=6, RWY_PCHY_ICE  =7};


class CWeatherArea  
{
private:

   bool   m_old_isLoaded;
   bool   m_old_isActive;
   float  m_old_radius;
   double m_old_latitude;
   double m_old_longitude;

   bool   m_wasInRange;

public:
	void Deactivate();
	bool m_use_area;
	void Activate();
   bool   m_isInRange;
	bool isNowInRange();
   CWeatherArea();
	virtual ~CWeatherArea();
	void   Update(double ac_latitude, double ac_longitude);
	bool   setAirportID(char *id);
   bool   hasChanged();
   double m_area_latitude;
   double m_area_longitude;
   bool   m_isLoaded;
   bool   m_isActive;
   char   m_airport[8];
   char   m_runway[8];
   float  m_wx_radius;
	float  m_field_pressure_inHg;
	float  m_field_temperature_f;
	long   m_RVR_ft;
	float  m_visibility_sm;
	long   m_visual_scene;
   long   m_cloud_2_top;
   long   m_cloud_2_bottom;
   long   m_cloud_2_type;
   long   m_cloud_1_top;
   long   m_cloud_1_bottom;
   long   m_cloud_1_type;
   bool   m_cirrus;
   bool   m_scud;
   long   m_fog_type;
   long   m_fog_top;
   float  m_surface_wind_altitude;
   float  m_surface_wind_direction;
   float  m_surface_wind_speed;
   float  m_wind_gust_speed;
   float  m_wind_gust_variation;
   long   m_precip_type;
   long   m_precip_intensity;
   bool   m_lightning;
   bool   m_hail;
   long   m_RCR;
   long   m_runway_condition;
   bool   m_blowing_contamination;
   bool   m_wet_skidmarks;
   long   m_ice_quantity;
   long   m_ice_time;
   long   m_turbulence_intensity;
   bool   m_turbulence_enable;
};

#endif // !defined(WEATHERAREA_H)
