/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : weatherArea.cpp
//
// Date             : 30 March 2000
//
// Engineer         : Michael F Lawson
//
// Revision         : $
//
// Description      : Holds the values for the four weather areas as preset
//                    by the sortie file.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : 

// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
//
//
/////////////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "WeatherArea.h"
#include "..\core\dataconversion.h"
#include "AreaMap.h"

double LatLonDistance(double latitude1, double longitude1,
                      double latitude2, double longitude2)
{
    // great circle method; slower, but more accurate, just here test purposes
    //double LatA = latitude1  * DEG_TO_RAD;
    //double LatB = latitude2  * DEG_TO_RAD;
    //double LonA = longitude1 * DEG_TO_RAD;
    //double LonB = longitude2 * DEG_TO_RAD;
    //double GCResult = 60.0 * acos(sin(LatA) * sin(LatB) + cos(LatA) * cos(LatB) * cos (LonB - LonA)) * RAD_TO_DEG;

    // ususal D65 method
    double avg_lat    = (latitude1 + latitude2) * 0.5;
    double x_distance = 60.0 * (latitude1  - latitude2);
    double y_distance = 60.0 * (longitude1 - longitude2) * cos(avg_lat * DEG_TO_RAD);
    double result = sqrt((x_distance * x_distance) + (y_distance * y_distance));

    return result;
}


CWeatherArea::CWeatherArea()
{
   strcpy (m_airport, "       ");
   strcpy (m_runway,  "       ");
   m_wx_radius                = 10.0f;
   m_old_radius               = m_wx_radius;
   m_isLoaded                 = false;
   m_old_isLoaded             = false;
   m_isActive                 = false;
   m_old_isActive             = false;
   m_isInRange                = false;
   m_wasInRange               = false;
   m_area_latitude            =  0.0f;
   m_old_latitude             = m_area_latitude;
   m_area_longitude           = 0.0f;
   m_old_longitude            = m_area_longitude;
   m_field_pressure_inHg      = 0.0f;
   m_field_temperature_f      = 0.0f;
	m_RVR_ft                   = 0;
	m_visibility_sm            = 25.0f;
	m_visual_scene             = VIS_DAY;
   m_cloud_2_top              = 0;
   m_cloud_2_bottom           = 0;
   m_cloud_2_type             = CLOUD_CLEAR;
   m_cloud_1_top              = 0;
   m_cloud_1_bottom           = 0;
   m_cloud_1_type             = CLOUD_CLEAR;
   m_cirrus                   = false;
   m_scud                     = false;
   m_fog_type                 = FOG_OFF;
   m_fog_top                  = 0;
   m_surface_wind_altitude    = 100.0f;
   m_surface_wind_direction   = 0.0f;
   m_surface_wind_speed       = 0.0f;
   m_wind_gust_speed          = 0.0f;
   m_wind_gust_variation      = 0.0f;
   m_precip_type              = PRECIP_NONE;
   m_precip_intensity         = PRECIP_LIGHT;
   m_lightning                = false;
   m_hail                     = false;
   m_RCR                      = 23;
   m_runway_condition         = RWY_DRY;
   m_blowing_contamination    = false;
   m_wet_skidmarks            = false;
   m_ice_quantity             = 0;
   m_ice_time                 = 1;
   m_turbulence_intensity     = 0;
   m_turbulence_enable        = false;
}


CWeatherArea::~CWeatherArea()
{
}



// Calculate new distance from aircraft to weather area.  If it is now in
// range, set the isInRange flag.

void CWeatherArea::Update(double ac_latitude, double ac_longitude)
{
    if (!m_isLoaded)
        return;

    m_wasInRange = m_isInRange;  // save last-pass value

    double distance_to_aircraft = LatLonDistance(m_area_latitude, m_area_longitude, ac_latitude, ac_longitude);

    if (distance_to_aircraft < m_wx_radius)
        m_isInRange = true;
    else
        m_isInRange = false;
}


// Check to see if anything important has changed in an area, such as if it has
// become active or inactive, or newly loaded, or has a new airport name or
// lat/long.

bool CWeatherArea::hasChanged(void)
{
   bool result = false;
   if ( m_isActive       != m_old_isActive    ||
        m_isLoaded       != m_old_isLoaded    ||
        m_area_latitude  != m_old_latitude    ||
        m_area_longitude != m_old_longitude   ||
        m_wx_radius      != m_old_radius       )
   {
          result = true;
   }

   m_old_isActive    =  m_isActive;
   m_old_isLoaded    =  m_isLoaded;
   m_old_latitude    =  m_area_latitude;
   m_old_longitude   =  m_area_longitude;
   m_old_radius      =  m_wx_radius;

   return result;
}


// Check to see if the aircraft was not in the area before, and now is.

bool CWeatherArea::isNowInRange()
{
   if (m_isInRange && !m_wasInRange )
      return true;
   else
      return false;
}

void CWeatherArea::Activate()
{

    bool validLatLon = GetAirportLatLon((CString)m_airport, m_area_latitude, m_area_longitude);

    if (!validLatLon)
        Deactivate();
    else
    {
        m_isLoaded = true;
    }
}


void CWeatherArea::Deactivate()
{
        m_isActive  = false;
        m_isLoaded  = false;
        m_isInRange = false;
}
