// ToleranceData.cpp: implementation of the CToleranceData class.
//
//////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#include "ToleranceData.h"
#include "..\comms\CommsShared.h"
#include "..\core\DataConversion.h"
#include "WeatherArea.h"

extern double LatLonDistance(double latitude1, double longitude1,
                             double latitude2, double longitude2);


double          CToleranceData::m_dLatLonTolerance  = 0.01; // .1 NM
float           CToleranceData::m_fAltTolerance     = 50.0f; // 20 ft

unsigned long   CToleranceData::m_ulTime = 0;

CVariant*       CToleranceData::m_pSystemFreeze = NULL;

CVariant*       CToleranceData::m_pSortieLoaded = NULL;

long            CToleranceData::m_lMaxNumberOfElementsLead = -1;
long            CToleranceData::m_lMaxNumberOfElementsWing = -1;

CVariant*       CToleranceData::m_pLatVarLead = NULL;
CVariant*       CToleranceData::m_pLonVarLead = NULL;
CVariant*       CToleranceData::m_pAltVarLead = NULL;
CVariant*       CToleranceData::m_pAirspeedVarLead = NULL;
//CVariant*       CToleranceData::m_pHeadingVarLead = NULL;

CVariant*       CToleranceData::m_pLatVarWing = NULL;
CVariant*       CToleranceData::m_pLonVarWing = NULL;
CVariant*       CToleranceData::m_pAltVarWing = NULL;
CVariant*       CToleranceData::m_pAirspeedVarWing = NULL;
//CVariant*       CToleranceData::m_pHeadingVarWing = NULL;

_FSI_STL::list<struct TolData>  CToleranceData::m_listTolDataLead;
_FSI_STL::list<struct TolData>  CToleranceData::m_listTolDataWing;

_FSI_STL::map<HWND, _FSI_STL::map<int, _FSI_STL::list<struct TolData>::iterator> > CToleranceData::m_mapStartIts;
_FSI_STL::map<HWND, _FSI_STL::map<int, _FSI_STL::list<struct TolData>::iterator> > CToleranceData::m_mapClearIts;

_FSI_STL::map<HWND, _FSI_STL::map<int, bool> > CToleranceData::m_mapClearSinceLastUpdate;

_FSI_STL::map<HWND, _FSI_STL::map<int, unsigned short> > CToleranceData::m_mapAdded;

_FSI_STL::map<HWND, _FSI_STL::map<int, int> >  CToleranceData::m_mapTolDataReset;

_FSI_STL::list<struct TolData>::iterator CToleranceData::m_itLastAddedLead;
_FSI_STL::list<struct TolData>::iterator CToleranceData::m_itLastAddedWing;

_FSI_STL::string    CToleranceData::m_stlStrSystemFreeze("system_freeze");

_FSI_STL::string    CToleranceData::m_stlStrSortieLoaded("sortie_was_loaded");

_FSI_STL::string    CToleranceData::m_stlStrLatHostNameLead("lead_ac_latitude");
_FSI_STL::string    CToleranceData::m_stlStrLonHostNameLead("lead_ac_longitude");
_FSI_STL::string    CToleranceData::m_stlStrAltHostNameLead("lead_ac_altitude");
_FSI_STL::string    CToleranceData::m_stlStrAirspeedHostNameLead;
//_FSI_STL::string    CToleranceData::m_stlStrHeadingHostNameLead("lead_ac_heading");

_FSI_STL::string    CToleranceData::m_stlStrLatHostNameWing("ac_latitude");
_FSI_STL::string    CToleranceData::m_stlStrLonHostNameWing("ac_longitude");
_FSI_STL::string    CToleranceData::m_stlStrAltHostNameWing("ac_altitude_geometric");
_FSI_STL::string    CToleranceData::m_stlStrAirspeedHostNameWing("IAS");
//_FSI_STL::string    CToleranceData::m_stlStrHeadingHostNameWing("ac_heading");

bool                CToleranceData::m_bResetClearSinceLast = false;
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
/////////////////////////////////////////////////////////////////////

CToleranceData::CToleranceData()
{
}

void CToleranceData::Update()
{
    if (m_bResetClearSinceLast)
    {
        // m_bResetClearSinceLast would be true if this function was
        // called and then a client call ClearSinceLastUpdate.  The
        // next pass into this function would then have the bool as
        // true.  This is to take care of the approach case where there
        // are three approach tracks but only one type of plot vs the
        // lead/wing designation for the areamap.  If a plot is not
        // displayed, this will have no effect.
        _FSI_STL::map<HWND, _FSI_STL::map<int, bool> >::iterator mcslIt;
        _FSI_STL::map<HWND, _FSI_STL::map<int, bool> >::iterator mendcslIt;

        mcslIt      = m_mapClearSinceLastUpdate.begin();
        mendcslIt   = m_mapClearSinceLastUpdate.end();

        _FSI_STL::map<int, bool>::iterator mIt;
        _FSI_STL::map<int, bool>::iterator mendIt;

        while (mcslIt != mendcslIt)
        {
            mIt     = (*mcslIt).second.begin();
            mendIt  = (*mcslIt).second.end();

            while (mIt != mendIt)
            {
                (*mIt).second = false;

                ++mIt;
            }

            ++mcslIt;
        }

        m_bResetClearSinceLast = false;
    }

    ResetData();

    // If the variant pointers have not been set, then see about
    // getting them.
    if (m_pLatVarLead == NULL)
        m_pLatVarLead = CCommsShared::FindVariant(m_stlStrLatHostNameLead);

    if (m_pLonVarLead == NULL)
        m_pLonVarLead = CCommsShared::FindVariant(m_stlStrLonHostNameLead);

    if (m_pAltVarLead == NULL)
        m_pAltVarLead = CCommsShared::FindVariant(m_stlStrAltHostNameLead);

    if (m_pAirspeedVarLead == NULL)
        m_pAirspeedVarLead = CCommsShared::FindVariant(m_stlStrAirspeedHostNameLead);

//    if (m_pHeadingVarLead == NULL)
//        m_pHeadingVarLead = CCommsShared::FindVariant(m_stlStrHeadingHostNameLead);

    // If we have pointers to position data.
    if (m_pLatVarLead != NULL && m_pLonVarLead != NULL)
    {
        // Should have data for both the lat and lon for the lead.
        // Check to see if the maximum number of elements has been
        // set.
        if (m_lMaxNumberOfElementsLead == -1)
        {
            CVariableData* pVarData = CCommsShared::FindVariableData(m_stlStrLatHostNameLead);
            if (pVarData != NULL)
                m_lMaxNumberOfElementsLead = pVarData->ListSize();
        }

        // Make sure that a size of data has been set.
        if (m_lMaxNumberOfElementsLead > 0)
        {
            // Get all of the latest data
            struct TolData td;
            memset(&td, 0, sizeof(TolData));
            td.s_dLat = (double)(*m_pLatVarLead);
            td.s_dLon = (double)(*m_pLonVarLead);
            td.s_ulTime = m_ulTime;

            if (m_pAirspeedVarLead != NULL)
                td.s_fAirpseed = (float)(*m_pAirspeedVarLead);

            if (m_pAltVarLead != NULL)
                td.s_fAlt = (float)(*m_pAltVarLead);

//            if (m_pHeadingVarLead != NULL)
//                td.s_fHeading = (float)(*m_pHeadingVarLead);

            if (m_listTolDataLead.empty())
            {
                // Add the current position since no data has been added.
                m_listTolDataLead.push_back(td);

                m_itLastAddedLead = m_listTolDataLead.begin();

                // Make sure that any clients have been set to the beginning
                // of the list, the number of elements added is 1.
                _FSI_STL::map<HWND, _FSI_STL::map<int, _FSI_STL::list<struct TolData>::iterator> >::iterator mhwndIt;
                _FSI_STL::map<HWND, _FSI_STL::map<int, _FSI_STL::list<struct TolData>::iterator> >::iterator mhwndEndIt;

                mhwndIt     = m_mapStartIts.begin();
                mhwndEndIt  = m_mapStartIts.end();

                while (mhwndIt != mhwndEndIt)
                {
                    // Set the start pointers to the beginning.
                    (*mhwndIt).second[AreaMapLead]  = m_listTolDataLead.begin();
                    (*mhwndIt).second[GeoChartLead] = m_listTolDataLead.begin();

                    // Set the clear pointers to the beginning.
                    m_mapClearIts[(*mhwndIt).first][AreaMapLead]  = m_listTolDataLead.begin();
                    m_mapClearIts[(*mhwndIt).first][GeoChartLead] = m_listTolDataLead.begin();

                    // Set the number added to 1.
                    m_mapAdded[(*mhwndIt).first][AreaMapLead]     = 1;
                    m_mapAdded[(*mhwndIt).first][GeoChartLead]    = 1;

                    // Set the reset flags to 0.
                    m_mapTolDataReset[(*mhwndIt).first][AreaMapLead]  = 0;
                    m_mapTolDataReset[(*mhwndIt).first][GeoChartLead] = 0;

                    ++mhwndIt;
                }
            }
            else
            {
                if (LatLonDistance(td.s_dLat, td.s_dLon,
                                   m_listTolDataLead.back().s_dLat,
                                   m_listTolDataLead.back().s_dLon) >= m_dLatLonTolerance ||
                    fabs(m_listTolDataLead.back().s_fAlt - td.s_fAlt) >= m_fAltTolerance)
                {
                    // Put the data in the list.
                    m_listTolDataLead.push_back(td);

                    // Increment the last added.
                    ++m_itLastAddedLead;

                    // Since we are going to add some data, increment the number added for
                    // all of the lead clients.
                    _FSI_STL::map<HWND, _FSI_STL::map<int, unsigned short> >::iterator mIt;
                    _FSI_STL::map<HWND, _FSI_STL::map<int, unsigned short> >::iterator mEndIt;

                    mIt     = m_mapAdded.begin();
                    mEndIt  = m_mapAdded.end();

                    while (mIt != mEndIt)
                    {
                        if ((*mIt).second[AreaMapLead] != m_lMaxNumberOfElementsLead)
                        {
                            int nNumberToAdd = (*mIt).second[AreaMapLead];
                            if (nNumberToAdd == 0)
                               m_mapStartIts[(*mIt).first][AreaMapLead] = m_itLastAddedLead;

                            (*mIt).second[AreaMapLead] += 1;
                        }

                        if ((*mIt).second[GeoChartLead] != m_lMaxNumberOfElementsLead)
                        {
                            int nNumberToAdd = (*mIt).second[GeoChartLead];
                            if (nNumberToAdd == 0)
                               m_mapStartIts[(*mIt).first][GeoChartLead] = m_itLastAddedLead;

                            (*mIt).second[GeoChartLead] += 1;
                        }

                        ++mIt;
                    }

                    // The distance between the latest lat,lon and the last lat,lon
                    // in the list satisfies the tolerance.If the size of the
                    // list is larger than the maximum size, then increment any 
                    // iterators that point to the front and then pop the front.
                    if (m_listTolDataLead.size() > m_lMaxNumberOfElementsLead)
                    {
                        _FSI_STL::map<HWND, _FSI_STL::map<int, _FSI_STL::list<struct TolData>::iterator> >::iterator mhwndIt;
                        _FSI_STL::map<HWND, _FSI_STL::map<int, _FSI_STL::list<struct TolData>::iterator> >::iterator mhwndEndIt;
                        _FSI_STL::map<int, _FSI_STL::list<struct TolData>::iterator>::iterator menumIt;
                        _FSI_STL::map<int, _FSI_STL::list<struct TolData>::iterator>::iterator menumEndIt;

                        // Move all of the start pointers up.
                        mhwndIt     = m_mapStartIts.begin();
                        mhwndEndIt  = m_mapStartIts.end();

                        while (mhwndIt != mhwndEndIt)
                        {
                            menumIt     = (*mhwndIt).second.begin();
                            menumEndIt  = (*mhwndIt).second.end();

                            while (menumIt != menumEndIt)
                            {
                                if ((*menumIt).second == m_listTolDataLead.begin())
                                    ++((*menumIt).second);

                                ++menumIt;
                            }

                            ++mhwndIt;
                        }

                        // Move all of the clear pointers up.
                        mhwndIt     = m_mapClearIts.begin();
                        mhwndEndIt  = m_mapClearIts.end();

                        while (mhwndIt != mhwndEndIt)
                        {
                            menumIt     = (*mhwndIt).second.begin();
                            menumEndIt  = (*mhwndIt).second.end();

                            while (menumIt != menumEndIt)
                            {
                                if ((*menumIt).second == m_listTolDataLead.begin())
                                    ++((*menumIt).second);

                                ++menumIt;
                            }

                            ++mhwndIt;
                        }

                        m_listTolDataLead.pop_front();
                    }
                }
            }
        }
    }
 
    // If the variant pointers have not been set, then see about
    // getting them.
    if (m_pLatVarWing == NULL)
        m_pLatVarWing = CCommsShared::FindVariant(m_stlStrLatHostNameWing);

    if (m_pLonVarWing == NULL)
        m_pLonVarWing = CCommsShared::FindVariant(m_stlStrLonHostNameWing);

    if (m_pAltVarWing == NULL)
        m_pAltVarWing = CCommsShared::FindVariant(m_stlStrAltHostNameWing);

    if (m_pAirspeedVarWing == NULL)
        m_pAirspeedVarWing = CCommsShared::FindVariant(m_stlStrAirspeedHostNameWing);

//    if (m_pHeadingVarWing == NULL)
//       m_pHeadingVarWing = CCommsShared::FindVariant(m_stlStrHeadingHostNameWing);

    // If valid pointers to position data.
    if (m_pLatVarWing != NULL && m_pLonVarWing != NULL)
    {
        // Should have data for both the lat and lon for the Wing.
        // Check to see if the maximum number of elements has been
        // set.
        if (m_lMaxNumberOfElementsWing == -1)
        {
            CVariableData* pVarData = CCommsShared::FindVariableData(m_stlStrLatHostNameWing);
            if (pVarData != NULL)
                m_lMaxNumberOfElementsWing = pVarData->ListSize();
        }

        // Make sure that a size of data has been set.
        if (m_lMaxNumberOfElementsWing > 0)
        {
            // Get all of the latest data
            struct TolData td;
            memset(&td, 0, sizeof(TolData));
            td.s_dLat = (double)(*m_pLatVarWing);
            td.s_dLon = (double)(*m_pLonVarWing);
            td.s_ulTime = m_ulTime;

            if (m_pAirspeedVarWing != NULL)
                td.s_fAirpseed = (float)(*m_pAirspeedVarWing);

            if (m_pAltVarWing != NULL)
                td.s_fAlt = (float)(*m_pAltVarWing);

//            if (m_pHeadingVarWing != NULL)
//                td.s_fHeading = (float)(*m_pHeadingVarWing);

            if (m_listTolDataWing.empty())
            {
                // Add the current position since no data has been added.
                m_listTolDataWing.push_back(td);

                m_itLastAddedWing = m_listTolDataWing.begin();

                // Make sure that any clients have been set to the beginning
                // of the list, the number of elements added is 1.
                _FSI_STL::map<HWND, _FSI_STL::map<int, _FSI_STL::list<struct TolData>::iterator> >::iterator mhwndIt;
                _FSI_STL::map<HWND, _FSI_STL::map<int, _FSI_STL::list<struct TolData>::iterator> >::iterator mhwndEndIt;

                mhwndIt     = m_mapStartIts.begin();
                mhwndEndIt  = m_mapStartIts.end();

                while (mhwndIt != mhwndEndIt)
                {
                    // Set the start pointers to the beginning.
                    (*mhwndIt).second[AreaMapWing]  = m_listTolDataWing.begin();
                    (*mhwndIt).second[ApproachPlot] = m_listTolDataWing.begin();
                    (*mhwndIt).second[GeoChartWing] = m_listTolDataWing.begin();

                    // Set the clear pointers to the beginning.
                    m_mapClearIts[(*mhwndIt).first][AreaMapWing] = m_listTolDataWing.begin();
                    m_mapClearIts[(*mhwndIt).first][ApproachPlot] = m_listTolDataWing.begin();
                    m_mapClearIts[(*mhwndIt).first][GeoChartWing] = m_listTolDataWing.begin();

                    // Set the number added to 1.
                    m_mapAdded[(*mhwndIt).first][AreaMapWing]   = 1;
                    m_mapAdded[(*mhwndIt).first][ApproachPlot]  = 1;
                    m_mapAdded[(*mhwndIt).first][GeoChartWing]  = 1;

                    // Set the reset flags to 0.
                    m_mapTolDataReset[(*mhwndIt).first][AreaMapWing]    = 0;
                    m_mapTolDataReset[(*mhwndIt).first][ApproachPlot]   = 0;
                    m_mapTolDataReset[(*mhwndIt).first][GeoChartWing]   = 0;

                    ++mhwndIt;
                }
            }
            else
            {
                if (LatLonDistance(td.s_dLat, td.s_dLon,
                                   m_listTolDataWing.back().s_dLat,
                                   m_listTolDataWing.back().s_dLon) >= m_dLatLonTolerance ||
                    fabs(m_listTolDataWing.back().s_fAlt - td.s_fAlt) >= m_fAltTolerance)
                {
                    // Add the data to the list
                    m_listTolDataWing.push_back(td);

                    // Move the pointer for the last added.
                    ++m_itLastAddedWing;

                    // Since we are going to add some data, increment the number added for
                    // all of the lead clients.
                    _FSI_STL::map<HWND, _FSI_STL::map<int, unsigned short> >::iterator mIt;
                    _FSI_STL::map<HWND, _FSI_STL::map<int, unsigned short> >::iterator mEndIt;

                    mIt     = m_mapAdded.begin();
                    mEndIt  = m_mapAdded.end();

                    while (mIt != mEndIt)
                    {
                        if ((*mIt).second[AreaMapWing] != m_lMaxNumberOfElementsWing)
                        {
                            int nNumberToAdd = (*mIt).second[AreaMapWing];
                            if (nNumberToAdd == 0)
                               m_mapStartIts[(*mIt).first][AreaMapWing] = m_itLastAddedWing;

                            (*mIt).second[AreaMapWing]  += 1;
                        }

                        if ((*mIt).second[ApproachPlot] != m_lMaxNumberOfElementsWing)
                        {
                            int nNumberToAdd = (*mIt).second[ApproachPlot];
                            if (nNumberToAdd == 0)
                               m_mapStartIts[(*mIt).first][ApproachPlot] = m_itLastAddedWing;

                            (*mIt).second[ApproachPlot] += 1;
                        }

                        if ((*mIt).second[GeoChartWing] != m_lMaxNumberOfElementsWing)
                        {
                            int nNumberToAdd = (*mIt).second[GeoChartWing];
                            if (nNumberToAdd == 0)
                               m_mapStartIts[(*mIt).first][GeoChartWing] = m_itLastAddedWing;

                            (*mIt).second[GeoChartWing] += 1;
                        }

                        ++mIt;
                    }

                    // The distance between the latest lat,lon and the last lat,lon
                    // in the list satisfies the tolerance.  If the size of the
                    // list is larger than the maximum size, then increment any 
                    // iterators that point to the front and then pop the front.
                    if (m_listTolDataWing.size() > m_lMaxNumberOfElementsWing)
                    {
                        //
                        _FSI_STL::map<HWND, _FSI_STL::map<int, _FSI_STL::list<struct TolData>::iterator> >::iterator mhwndIt;
                        _FSI_STL::map<HWND, _FSI_STL::map<int, _FSI_STL::list<struct TolData>::iterator> >::iterator mhwndEndIt;
                        _FSI_STL::map<int, _FSI_STL::list<struct TolData>::iterator>::iterator menumIt;
                        _FSI_STL::map<int, _FSI_STL::list<struct TolData>::iterator>::iterator menumEndIt;

                        // Move the start pointers up.
                        mhwndIt     = m_mapStartIts.begin();
                        mhwndEndIt  = m_mapStartIts.end();

                        while (mhwndIt != mhwndEndIt)
                        {
                            menumIt     = (*mhwndIt).second.begin();
                            menumEndIt  = (*mhwndIt).second.end();

                            while (menumIt != menumEndIt)
                            {
                                if ((*menumIt).second == m_listTolDataWing.begin())
                                    ++((*menumIt).second);

                                ++menumIt;
                            }

                            ++mhwndIt;
                        }

                        // Move the clear pointers up.
                        mhwndIt     = m_mapClearIts.begin();
                        mhwndEndIt  = m_mapClearIts.end();

                        while (mhwndIt != mhwndEndIt)
                        {
                            menumIt     = (*mhwndIt).second.begin();
                            menumEndIt  = (*mhwndIt).second.end();

                            while (menumIt != menumEndIt)
                            {
                                if ((*menumIt).second == m_listTolDataWing.begin())
                                    ++((*menumIt).second);

                                ++menumIt;
                            }

                            ++mhwndIt;
                        }

                        m_listTolDataWing.pop_front();
                    }
                }
            }
        }
    }

    ResetData();

    // Determine if the time value for the data needs to be incremented.
    if (m_pSystemFreeze == NULL)
        m_pSystemFreeze = CCommsShared::FindVariant(m_stlStrSystemFreeze);

    bool bFreezeInEffect = false;
    if (m_pSystemFreeze != NULL)
        bFreezeInEffect = (bool)(*m_pSystemFreeze);

    if (!bFreezeInEffect)
        ++m_ulTime;

    // Determine if a sortie was loaded since the last pass.
    // If so, then the old data needs to be "dropped".
    if (m_pSortieLoaded == NULL)
        m_pSortieLoaded = CCommsShared::FindLocalVariant(m_stlStrSortieLoaded);

    bool bSortieLoaded = false;
    if (m_pSortieLoaded != NULL)
        bSortieLoaded = (bool)(*m_pSortieLoaded);

    if (bSortieLoaded)
    {
        // Since a sortie was loaded, the clear pointers need to be reset.
        ClearAll();

        CVariant var;
        var.Value(false);

        CCommsShared::SetLocalValue(var, m_stlStrSortieLoaded, 0);
    }

}

void CToleranceData::Clear(HWND hWnd, enum TolDataClients eTDC)
{
    // For a given screen, move the clear iterator to the last start iterator.
    if (m_mapClearIts.find(hWnd) != m_mapClearIts.end() &&
        m_mapStartIts.find(hWnd) != m_mapStartIts.end())
    {
        (m_mapClearIts[hWnd])[eTDC] = (m_mapStartIts[hWnd])[eTDC];
    }
    else if (hWnd != NULL)
    {
        // Not found.  Set the clear to the start of the data.
        if (eTDC == AreaMapLead || eTDC == GeoChartLead  || eTDC == ApproachPlot)
        {
            m_mapClearIts[hWnd][eTDC] = m_listTolDataLead.begin();
            m_mapClearIts[hWnd][eTDC] = m_listTolDataLead.begin();
        }
        else
        {
            m_mapClearIts[hWnd][eTDC] = m_listTolDataWing.begin();
            m_mapClearIts[hWnd][eTDC] = m_listTolDataWing.begin();
        }
    }
}

void CToleranceData::ClearAll()
{
    // ClearAll will move all of the start pointers to the last added data and
    // then move all of the clear pointers to match the start pointers.  The
    // number added is then 1.
    _FSI_STL::map<HWND, _FSI_STL::map<int, _FSI_STL::list<struct TolData>::iterator> >::iterator mIt;
    _FSI_STL::map<HWND, _FSI_STL::map<int, _FSI_STL::list<struct TolData>::iterator> >::iterator mendIt;

    mIt     = m_mapClearIts.begin();
    mendIt  = m_mapClearIts.end();

    _FSI_STL::map<int, _FSI_STL::list<struct TolData>::iterator>::iterator mTolDataClientIt;
    _FSI_STL::map<int, _FSI_STL::list<struct TolData>::iterator>::iterator mendTolDataClientIt;

    while (mIt != mendIt)
    {
        mTolDataClientIt    = (*mIt).second.begin();
        mendTolDataClientIt = (*mIt).second.end();

        while (mTolDataClientIt != mendTolDataClientIt)
        {
            m_mapAdded[(*mIt).first][(*mTolDataClientIt).first] = 1;

            // Second pass.  Move the start pointers to the last added data.
            if ((*mTolDataClientIt).first == AreaMapLead)
                m_mapStartIts[(*mIt).first][(*mTolDataClientIt).first] = m_itLastAddedLead;
            else if ((*mTolDataClientIt).first == GeoChartLead)
                m_mapStartIts[(*mIt).first][(*mTolDataClientIt).first] = m_itLastAddedLead;
            else
                m_mapStartIts[(*mIt).first][(*mTolDataClientIt).first] = m_itLastAddedWing;

            m_mapClearIts[(*mIt).first][(*mTolDataClientIt).first] = m_mapStartIts[(*mIt).first][(*mTolDataClientIt).first];

            m_mapClearSinceLastUpdate[(*mIt).first][(*mTolDataClientIt).first] = true;

            ++mTolDataClientIt;
        }

        ++mIt;
    }
}

bool CToleranceData::ClearSinceLastUpdate(HWND hWnd, enum TolDataClients eTDC)
{
    bool bClearSinceLastUpdate = false;
    if (m_mapClearSinceLastUpdate.find(hWnd) != m_mapClearSinceLastUpdate.end())
    {
        bClearSinceLastUpdate = m_mapClearSinceLastUpdate[hWnd][eTDC];

        m_bResetClearSinceLast = bClearSinceLastUpdate;
    }

    return bClearSinceLastUpdate;
}

void CToleranceData::ResetData()
{
    _FSI_STL::map<HWND, _FSI_STL::map<int, int> >::iterator mIt;
    _FSI_STL::map<HWND, _FSI_STL::map<int, int> >::iterator mendIt;

    mIt     = m_mapTolDataReset.begin();
    mendIt  = m_mapTolDataReset.end();

    _FSI_STL::map<int, int>::iterator mResetIt;
    _FSI_STL::map<int, int>::iterator mendResetIt;

    while (mIt != mendIt)
    {
        mResetIt    = (*mIt).second.begin();
        mendResetIt = (*mIt).second.end();

        while (mResetIt != mendResetIt)
        {
            if ((*mResetIt).second & RESET_ADDED)
                m_mapAdded[(*mIt).first][(*mResetIt).first] = 0;

            if (((*mResetIt).second & RESET_START_IT) &&
                !((*mResetIt).second & RESET_ADDED))
            {
                // Second pass.  Move the start pointers to the last added data.
                if ((*mResetIt).first == AreaMapLead)
                    m_mapStartIts[(*mIt).first][(*mResetIt).first] = m_itLastAddedLead;
                else if ((*mResetIt).first == GeoChartLead)
                    m_mapStartIts[(*mIt).first][(*mResetIt).first] = m_itLastAddedLead;
                else
                    m_mapStartIts[(*mIt).first][(*mResetIt).first] = m_itLastAddedWing;

                (*mResetIt).second = 0;
            }
            else
            {
                // Clear any resets of added.  Leave the start_it reset
                // since ResetData will be called again after data is added.
                (*mResetIt).second &= RESET_START_IT;
            }

            ++mResetIt;
        }

        ++mIt;
    }
}

//////////////////////////////////////////////////////////////////////
// Accessors
//////////////////////////////////////////////////////////////////////
double CToleranceData::LatLonTolerance()
{
    return m_dLatLonTolerance;
}

float CToleranceData::AltTolerance()
{
    return m_fAltTolerance;
}

unsigned short CToleranceData::Added(HWND hWnd, enum TolDataClients eTDC)
{
    // Return the number added for a screen and a particular plot since
    // the last call to added.
    m_mapTolDataReset[hWnd][eTDC] |= RESET_ADDED;
    if (m_mapAdded.find(hWnd) != m_mapAdded.end())
    {
        return m_mapAdded[hWnd][eTDC];
    }

    m_mapAdded[hWnd][eTDC] = 0;

    return 0;
}

void CToleranceData::StartIt(HWND hWnd, enum TolDataClients eTDC,
                             bool& bOk, _FSI_STL::list<struct TolData>::iterator& it)
{
    // Get the start pointer for a screen and a particular plot.
    bOk = true;
    m_mapTolDataReset[hWnd][eTDC] |= RESET_START_IT;
    if (m_mapStartIts.find(hWnd) != m_mapStartIts.end())
    {
        if (m_mapStartIts[hWnd].find(eTDC) != m_mapStartIts[hWnd].end())
        {
            it = m_mapStartIts[hWnd][eTDC];
            return;
        }
    }

    // Wasn't in the data structure.  Add it.
    int size;
    if (eTDC == AreaMapLead)
    {
        it      = m_listTolDataLead.begin();
        size    = m_listTolDataLead.size();
    }
    else if (eTDC == GeoChartLead)
    {
        it      = m_listTolDataLead.begin();
        size    = m_listTolDataLead.size();
    }
    else
    {
        it      = m_listTolDataWing.begin();
        size    = m_listTolDataWing.size();
    }

    m_mapStartIts[hWnd][eTDC]       = it;
    m_mapClearIts[hWnd][eTDC]       = it;

    m_mapAdded[hWnd][eTDC]          = size;
}

void CToleranceData::ClearIt(HWND hWnd, enum TolDataClients eTDC,
                             bool& bOk, _FSI_STL::list<struct TolData>::iterator& it)
{
    // Get the clear pointer for a screen and a particular plot.
    bOk = true;
    if (m_mapClearIts.find(hWnd) != m_mapClearIts.end())
    {
        if (m_mapClearIts[hWnd].find(eTDC) != m_mapClearIts[hWnd].end())
        {
            it = m_mapClearIts[hWnd][eTDC];
            return;
        }
    }

    // Wasn't in the data structure add it by calling the StartIt method.
    if (m_mapClearIts[hWnd].find(eTDC) == m_mapClearIts[hWnd].end())
        StartIt(hWnd, eTDC, bOk, it);

    if (m_mapClearIts[hWnd].find(eTDC) == m_mapClearIts[hWnd].end())
        m_mapClearIts[hWnd][eTDC] = m_mapStartIts[hWnd][eTDC];
}

//////////////////////////////////////////////////////////////////////
// Mutators
//////////////////////////////////////////////////////////////////////
void CToleranceData::LatLonTolerance(const double& rdLatLonTolerance)
{
    m_dLatLonTolerance = rdLatLonTolerance;

    // Should data be cleared/iterators reset if the tolerance changes?
}

void CToleranceData::AltTolerance(const float fAltTolerance)
{
    m_fAltTolerance = fAltTolerance;

    // Should data be cleared/iterators reset if the tolerance changes?
}