// Texan_Model.h: interface for the Texan_Model class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TEXAN_MODEL_H__58E179A0_33B3_11D2_B7EB_0000E8471EC5__INCLUDED_)
#define AFX_TEXAN_MODEL_H__58E179A0_33B3_11D2_B7EB_0000E8471EC5__INCLUDED_

#include "ooglTexture.h"	// Added by ClassView
#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

// Color definitions /////////////////////////////////////////////////

#define JPATS_BLUE	0.1f, 0.1f, 0.3f, 1.0f
#define JPATS_WHITE 1.0f, 1.0f, 1.0f, 1.0f
#define JPATS_BLACK 0.02f, 0.02f, 0.02f, 1.0f
#define JPATS_CANOPY 0.3f, 0.3f,  0.9f,  1.0f
#define JPATS_EXHAUST 0.59f, 0.43f, 0.29f, 1.0f
#define JPATS_NOSECONE 0.498f, 0.4471f, 0.4039f, 1.0f
#define JPATS_PROP 0.2f, 0.2f, 0.2f, 1.0f
#define JPATS_GEAR 0.7f, 0.7f, 0.7f, 1.0f
#define JPATS_TIRE 0.1f, 0.1f, 0.1f, 1.0f

// The following CG_OFFSET values are used to adjust the entire scene so that all rotations and translations
// occur with reference to the center of gravity of the aircraft.
#define  X_CG_OFFSET    -2.0f
#define  Y_CG_OFFSET    -110.0f
#define  Z_CG_OFFSET     0.0f

// Enumerated types //////////////////////////////////////////////////
enum whichGear { NOSE_GEAR, LEFT_GEAR, RIGHT_GEAR };
enum whichPaintScheme { NAVY, GENERIC, NOT_ANY};

//////////////////////////////////////////////////////////////////////
class Texan_Model  
{
public:

	double temps;
	double tempz;
	double tempy;
	double tempx;
	void SetSteeringAngle(double newAngle);
	void SetGearDoorPosition(whichGear, double);
	void SetGearPosition(whichGear, double);
	void SetElevatorPosition(double);
	void SetRudderPosition(double);
	void SetPropPosition(double);
	void Initialize(whichPaintScheme paintScheme = NAVY);
	void Render(void);
	void SetPropPitch(double);

	Texan_Model();
	virtual ~Texan_Model();

private:

	GLuint m_aileron2_list;
	GLuint m_aileron1_list;
	GLuint m_inner_gear_door_list;
	GLuint m_r_outer_gear_door_list;
	GLuint m_l_outer_gear_door_list;
	GLuint m_r_gear_list;
	GLuint m_l_gear_list;
	GLuint m_elevator_list;
	GLuint m_nose_door_list;
	GLuint m_aircraft_list;
	GLuint m_rudder_list;
	GLuint m_nosegear_list;
	GLuint m_prop_list;

	inline void drawGear(void);
	inline void drawProp(void);
	inline void drawRudder(void);
	inline void drawElevator(void);
	inline void drawACBody(void);
	inline void drawAilerons(void);

	ooglTexture2D r_fuselageTex;
	ooglTexture2D l_fuselageTex;
	ooglTexture2D m_bottom_texture;
	ooglTexture2D m_top_texture;

	double m_gear_door_position[3];
	double m_gear_position[3];
	double m_rudder_position;
	double m_prop_position;
	double m_prop_pitch;
	double m_elevator_position;
	double m_steering_angle;

    bool m_bDeleteLists;
};

#endif // !defined(AFX_TEXAN_MODEL_H__58E179A0_33B3_11D2_B7EB_0000E8471EC5__INCLUDED_)
