/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : StationKillActionPage.cpp
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision$
//
// Description      : StationKillActionPage.cpp contains the implementation of the 
//                    CStationKillActionPage class.  This class is used to 
//                    set the properties for a CStationKillAction object.  It 
//                    is derived from Core::CIOActionPage.  As with all 
//                    other CIOActionPage derived classes, a list of 
//                    variables from the IO source is shown as well as 
//                    the expected values of the parent grapical widget 
//                    so that a link can be made between what the 
//                    parent expects and what is available in the IO 
//                    source datafile.    This page is displayed in the
//                    CWidgetProps dialog.    The standard 
//                    CBasePage framework methods--SetProperties and 
//                    UpdateProperties--are defined and implemented in
//                    Core::CIOActionPage.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : CIOActionPage.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3
//                                          Microsoft Windows NT 5.0
//
//                    Compiler(s) - Visual C++ 5.0 with VisC++ service pack 3
//                                  Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log$
//
#include "..\core\stdafx.h"
#include "StationKillActionPage.h"

#include "StationKillAction.h"

#include "..\core\Widget.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
//
// CStationKillActionPage::CStationKillActionPage()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Default constructor.  The base class constructor 
//                    is also called with the resource template 
//                    identifier for the property page.  Since all 
//                    CIOActionPage classes share the same template, 
//                    the title of the property page is changed here.
//
/////////////////////////////////////////////////////////////////////////////
CStationKillActionPage::CStationKillActionPage() : CIOActionPage()
{
	//{{AFX_DATA_INIT(CStationKillActionPage)
	//}}AFX_DATA_INIT
    m_stlStrPageName = _FSI_STL::string("Station Kill Action");
    m_psp.dwFlags |= PSP_USETITLE;
    m_psp.pszTitle = _T("Station Kill Action");
}

/////////////////////////////////////////////////////////////////////////////
//
// CStationKillActionPage::~CStationKillActionPage()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Default destructor.
//
/////////////////////////////////////////////////////////////////////////////
CStationKillActionPage::~CStationKillActionPage()
{
}

BEGIN_MESSAGE_MAP(CStationKillActionPage, CIOActionPage)
	//{{AFX_MSG_MAP(CStationKillActionPage)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
//
// CBasePage* CStationKillActionPage::CreateObject()
//
// Inputs           : None.
//
// Return Values    : Address of a new instance of CStationKillActionPage.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : CreateObject() is a common framework method that must be
//                    implemented by each CBasePage derived class.  The widget
//                    that uses this page associates the name of this page with 
//                    this static CreateObject method so that a new object can be
//                    created without linking against the library that contains
//                    this class.
//
/////////////////////////////////////////////////////////////////////////////
CBasePage* CStationKillActionPage::CreateObject()
{
    return new CStationKillActionPage;
}

/////////////////////////////////////////////////////////////////////////////
//
// BOOL CStationKillActionPage::OnInitDialog()
//
// Inputs           : None.
//
// Return Values    : TRUE.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : OnInitDialog() is an override of the MFC common framework
//                    method by the same name for a CDialog derived class.  Its
//                    purpose is to fill the list of variables from the IO
//                    source datafile.  The parent class will fill the list of
//                    the parent graphical element's expected variables.
//
/////////////////////////////////////////////////////////////////////////////
BOOL CStationKillActionPage::OnInitDialog() 
{
	CIOActionPage::OnInitDialog();
	
   m_ctrlVariableList.ResetContent();

   m_ctrlVariableList.AddString("Configuration");
   m_ctrlVariableList.AddString("Status");

   m_ctrlVariableList.SelectString(-1, m_strCommVariable);


   CWnd* pStatic = GetDlgItem(IDC_ARRAY_STATIC);
   if (pStatic != NULL)
   {
      pStatic->SetWindowText("Bit Index");
   }

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
