/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : StationKillAction.h
//
// Date             : 02 April 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision$
//
// Description      : StationKillAction.h contains the definition 
//                    of the CStationKillAction class.  This class is 
//                    similar to the CCommsAction class.  As opposed to 
//                    calling a CCommsSystemInterface class WriteData 
//                    member, CStationKillAction updates the CVariant to 
//                    which this class has a pointer and then call 
//                    OnUpdate for each CStationKillAction also attached 
//                    to the same pointer. 
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : None.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3
//                                          Microsoft Windows NT 5.0
//
//                    Compiler(s) - Visual C++ 5.0 with VisC++ service pack 3
//                                  Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log$
/////////////////////////////////////////////////////////////////////////////
#if !defined(_STATIONKILLACTION_H_)
#define _STATIONKILLACTION_H_

#include "..\core\ioAction.h"
#include "..\core\Widget.h"
#include "NavaidShared.h"

class CStationKillAction : public CIOAction, public CWidget, public CNavaidShared
{
protected:

public:
	CStationKillAction();
	virtual ~CStationKillAction();

   virtual void Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                         const long int lId, bool bEditMode);
   static CWidget* CreateObject();

   virtual  enum     LButtonUpReturn   OnLButtonUp();

   virtual  void  ResetProperties();

   virtual  void  OnLoad();
   virtual  void  OnUpdate();
};

#endif