/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : StationKillAction.cpp
//
// Date             : 08 October 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision$
//
// Description      : StationKillAction.cpp contains the implementation 
//                    of the CStationKillAction class.  This class is 
//                    similar to the CCommsAction class.  As opposed to 
//                    calling a CCommsSystemInterface class WriteData 
//                    member, CStationKillAction updates the CVariant to 
//                    which this class has a pointer and then call 
//                    OnUpdate for each CStationKillAction also attached 
//                    to the same pointer. 
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : None.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3
//                                          Microsoft Windows NT 5.0
//
//                    Compiler(s) - Visual C++ 5.0 with VisC++ service pack 3
//                                  Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log$
/////////////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#include "StationKillAction.h"

#include "StationKillActionPage.h"
#include "..\core\UpdateList.h"


CStationKillAction::CStationKillAction()
{
    m_stlStrWidgetName = _FSI_STL::string("Station_Kill");

    m_listWidgetPropPages.push_back(CStationKillActionPage::CreateObject);
}

/////////////////////////////////////////////////////////////////////////////
//
// CStationKillAction::~CStationKillAction
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 08 October 1999
//
// Engineer         : Billy Baker
//
// Description      : Default destructor.
//
/////////////////////////////////////////////////////////////////////////////
CStationKillAction::~CStationKillAction()
{
   _FSI_STL::list<CAction*>::iterator lIt;
   lIt = _FSI_STL::find(m_navaid.m_listActions.begin(),
                      m_navaid.m_listActions.end(), this);

   if (lIt != m_navaid.m_listActions.end())
   {
      m_navaid.m_listActions.erase(lIt);
   }
}

/////////////////////////////////////////////////////////////////////////////
//
// void CStationKillAction::Initialize()
//
// Inputs           : CXMLWidget*& rpXMLWidget - pointer to return a new 
//                                               instance of a CXMLWidget.
//                    CWnd* pWnd - the parent of this widget.
//                    const long lId - the control ID.
//                    bool bEditMode - whether this widget is being created 
//                                     in the editor or the runtime.
//
// Return Values    : None.
//
// Date             : 08 October 1999
//
// Engineer         : Billy Baker
//
// Description      : Initialize() is a common framework method that must be
//                    implemented by each CWidget derived class.  Besides 
//                    standard initialization code for a CAction and CWidget
//                    derived class, the CCommsSystemInterface derived class
//                    is started if it has not already been started. 
//
/////////////////////////////////////////////////////////////////////////////
void CStationKillAction::Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                                const long lId, bool bEditMode)
{
    // Set the help text.
    if (rpXMLWidget == NULL)
    {
        m_stlStrName = m_stlStrName + " " + m_stlStrWidgetName.c_str();
    }

    // Call the base class.
    CWidget::Initialize(rpXMLWidget,pWnd, lId, bEditMode);

    m_pAction = this;
    m_pWidget = (CWidget*)this;

    if (rpXMLWidget != NULL)
    {
        m_pIOActionXMLWidget = m_pXMLWidget;
        ResetProperties();
    }

    m_navaid.m_listActions.push_back(this);

    OnLoad();
}

/////////////////////////////////////////////////////////////////////////////
//
// CWidget* CStationKillAction::CreateObject()
//
// Inputs           : None.
//
// Return Values    : Address of a new instance of CStationKillAction.
//
// Date             : 08 October 1999
//
// Engineer         : Billy Baker
//
// Description      : CreateObject() is a common framework method that must be
//                    implemented by each CWidget derived class.  The main
//                    application associates the name of this widget with this
//                    static CreateObject method so that a new object can be
//                    created without linking against the library that contains
//                    this class.
//
/////////////////////////////////////////////////////////////////////////////
CWidget* CStationKillAction::CreateObject()
{
    return new CStationKillAction();
}


void CStationKillAction::ResetProperties()
{
    CWidget::ResetProperties();
    CIOAction::ResetProperties();
}

/////////////////////////////////////////////////////////////////////////////
//
// void CStationKillAction::OnUpdate()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : OnUpdate() is a common framework method for CAction
//                    derived classes.  Its purpose is to send a new value
//                    to its parent graphical widget.  OnUpdate should 
//                    generally be called by some other class than the parent 
//                    graphical element.
//
/////////////////////////////////////////////////////////////////////////////
void CStationKillAction::OnUpdate()
{
   if (CWidget::IsValidAddress(m_pParentWidget) != VALID )
   {
      return;
   }

   int   result   =  0;

   if (m_stlStrVariableToWatch   == "Configuration")
      result   =  m_navaid.GetCurrentConfiguration();
   else if (m_stlStrVariableToWatch   == "Status")
      result   =  m_navaid.GetCurrentStatus();


   // use bit/array index to determine if value to write is true or false.
   // If true, then flip the bit to 1.
   if (m_lElement > -1)
   {
      m_variant.Value((long)(result  & 0x00000001 << m_lElement));
   }
   else
   {
      return;
   }



   m_ChangeValue.Variant(&m_variant);
   m_pParentWidget->ChangeValue(CString(m_stlStrElementVar.c_str()), &m_ChangeValue);

   CWnd* pWnd = m_pParentWidget->FrameworkParent();

   if (pWnd != NULL)
   {
      CUpdateList::AddPaintWidget(pWnd->GetSafeHwnd(), m_pParentWidget);
   }
}

void  CStationKillAction::OnLoad()
{
   if (! m_bEditing)
      OnUpdate();
}

enum LButtonUpReturn CStationKillAction::OnLButtonUp()
{
   if (m_stlStrVariableToWatch   == "Status")
   {
      int   result   =  0;
      result   =  m_navaid.GetCurrentStatus();

      if (m_lElement > -1)
      {
         m_navaid.SetPendingStatus((long)(result  ^ 0x00000001 << m_lElement));
      }
   }

    return LBU_OK;
}