/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : SelectRunwayCommsAction.cpp
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.19 $
//
// Description      : SelectRunwayCommsAction.cpp contains the implementation of the 
//                    CSelectRunwayCommsAction class.  This action is derived from 
//                    Core::CIOAction.  Its purpose is to distribute a 
//                    value to a graphical element in its OnUpdate 
//                    member.  This member is called from 
//                    CCommsSystemInterface::UpdateComms().  
//                    CCommsSystemInterface keeps track of all 
//                    CSelectRunwayCommsAction instances so that it may update all 
//                    of them.  Each CSelectRunwayCommsAction instance shares a 
//                    single CVariant instance.  Thus, many graphical 
//                    elements may want the value of a variable and 
//                    each graphical element will have an instance of a 
//                    CSelectRunwayCommsAction to read that variable.  However, the 
//                    value will be read from simulation once and 
//                    placed in the shared CVariant.  CSelectRunwayCommsAction will 
//                    also update simulation variable in OnLButtonUp.  
//                    This member will be called whenever an action 
//                    occurs on a graphical element.  The action might 
//                    be clicking a button or pressing the 
//                    enter/carriage return key while in an editbox.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : Core::CIOAction, Core::CWidget, Comms::CCommsShared, 
//                    Core::CVariant, _FSI_STL::string, _FSI_STL::list, _FSI_STL::map, 
//                    _FSI_STL::vector, Comms::CCommsSystemInterface, 
//                    Core::CChangeValue, Core::CRange.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 4
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: SelectRunwayCommsAction.cpp $
// Revision 1.1  1999/04/02 19:41:28  billyb
/////////////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#include "..\general\ComboWidget.h"
#include "SelectRunwayCommsAction.h"

#include "..\core\DataConversion.h"

#include <algorithm>

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


/////////////////////////////////////////////////////////////////////////////
//
// CSelectRunwayCommsAction::CSelectRunwayCommsAction
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Default constructor.  Sets the name of the widget.
//                    Adds the CSelectRunwayCommsActionPage to the list of widget
//                    property pages.
/////////////////////////////////////////////////////////////////////////////
CSelectRunwayCommsAction::CSelectRunwayCommsAction()
{
    m_stlStrWidgetName = _FSI_STL::string("Select_Runway_Comms");
}

/////////////////////////////////////////////////////////////////////////////
//
// CWidget* CSelectRunwayCommsAction::CreateObject()
//
// Inputs           : None.
//
// Return Values    : Address of a new instance of CSelectRunwayCommsAction.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : CreateObject() is a common framework method that must be
//                    implemented by each CWidget derived class.  The main
//                    application associates the name of this widget with this
//                    static CreateObject method so that a new object can be
//                    created without linking against the library that contains
//                    this class.
//
/////////////////////////////////////////////////////////////////////////////
CWidget* CSelectRunwayCommsAction::CreateObject()
{
    return new CSelectRunwayCommsAction();
}


/////////////////////////////////////////////////////////////////////////////
//
// void CSelectRunwayCommsAction::OnUpdate()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : OnUpdate() is a common framework method for CAction
//                    derived classes.  Its purpose is to send a new value
//                    to its parent graphical widget.  OnUpdate should 
//                    generally be called by some other class than the parent 
//                    graphical element.
//
/////////////////////////////////////////////////////////////////////////////
void CSelectRunwayCommsAction::OnUpdate()
{
   m_sync.Lock();

   if (m_bDeleting == true)
   {
      m_sync.Unlock();
      return;
   }

   // Make sure there is a Variant will a value to send to the parent
   // graphical widget.
   if (m_pVariant == NULL)
   {
      m_sync.Unlock();
      return;
   }

   // Make sure this instance is attached to a graphical element.
   if (CWidget::IsValidAddress(m_pParentWidget) != VALID )
   {
      m_sync.Unlock();
      return;
   }

   if (m_bool_list_has_changed)
   {
      _FSI_STL::map<long, _FSI_STL::list<_FSI_STL::string> >   list_of_runways;

      for (int index = 0; index < m_runway_count; index++)
      {
         list_of_runways[index].push_back(m_runway_list[index]);
      }

      ((CComboWidget *)m_pParentWidget)->Entries(list_of_runways);

      CString strElementVar   = CString(m_stlStrElementVar.c_str());
      CVariant variant;
      variant.Value(MAX_RUNWAYS);
      m_ChangeValue.Variant(&variant);
      m_ChangeValue.UseRange(false);

      m_pParentWidget->ChangeValue(strElementVar, &m_ChangeValue);

      CWnd* pWnd = m_pParentWidget->FrameworkParent();

      if (pWnd != NULL && m_pCommsSystemInterface != NULL)
      {
         (m_pCommsSystemInterface->m_mapWidgetsToRefresh[pWnd->GetSafeHwnd()])[m_pParentWidget] = true;
      }
   }


   // Depending on the read_mode--read always, read changed, read never, 
   // or read_once-- update the parent graphical widget.  Also, if a read
   // has not been performed once and the read_mode is not read never, then
   // go ahead and get an initial value. 
   if (  (  (m_bReadOnce      == true  && m_bRead  == false)   || 
            (m_bReadChanged   == true  && m_pVariant->WasChanged(m_lElement)  == true) || 
            (m_bReadAlways    == true) || (m_bInitialRead   == true))   && 
         (m_bReadOnce   == true  || m_bReadChanged == true  || m_bReadAlways  == true) ||
         m_bool_list_has_changed)
   {
      CString strElementVar   = CString(m_stlStrElementVar.c_str());
      CVariant variant        = (*m_pVariant)[m_lElement];

      bool  found =  false;
      for (long which_runway = 0; which_runway < m_runway_count; which_runway++)
      {
         if (!strncmp(m_runway_list[which_runway], _FSI_STL::string(variant).c_str(), RUNWAY_IDENT_LENGTH))
         {
            found =  true;
            break;
         }
      }
      if (found)
         variant.Value(which_runway);
      else
         variant.Value(MAX_RUNWAYS);

      // Send the new value to the parent graphical widget.
      // m_bUseRange will tell the parent whether to use the m_pVariant
      // value of the data for colors and text.
      m_ChangeValue.Variant(&variant);
      m_ChangeValue.UseRange(false);

      m_pParentWidget->ChangeValue(strElementVar, &m_ChangeValue);

      CWnd* pWnd = m_pParentWidget->FrameworkParent();

      if (pWnd != NULL && m_pCommsSystemInterface != NULL)
      {
         (m_pCommsSystemInterface->m_mapWidgetsToRefresh[pWnd->GetSafeHwnd()])[m_pParentWidget] = true;
      }

      // If this is a read once initializer, then mark as being read.
      if (m_bReadOnce == true)
      {
         m_bRead = true;
      }

      m_bInitialRead = false;
   }

   m_bool_list_has_changed =  false;

   m_sync.Unlock();
}

enum LButtonUpReturn CSelectRunwayCommsAction::OnLButtonUp()
{
   m_sync.Lock();

   if (m_bCanWrite == false)
   {
      m_sync.Unlock();
      return LBU_CAN_NOT_WRITE;
   }

   if (m_bDeleting == true)
   {
      // Since memory is going away, the parent is probably going away as well.  Let the parent think that
      // everything went ok.  Or, no write can take place
      m_sync.Unlock();
      return LBU_OK;
   }

   if (m_pCommsSystemInterface == NULL)
   {
      m_sync.Unlock();
      return LBU_NO_COMMS;
   }

   // Make sure this instance is attached to a graphical element.
   if (CWidget::IsValidAddress(m_pParentWidget) != VALID )
   {
      m_sync.Unlock();
      return LBU_OK;
   }

   CVariableData  *pVarData   =  NULL;

   if (m_pCommsSystemInterface->m_mapVarName2Data.find(m_stlStrVariableToWatch)  != m_pCommsSystemInterface->m_mapVarName2Data.end())
   {
      // Get the variable data to change the type.
      pVarData =  m_pCommsSystemInterface->m_mapVarName2Data[m_stlStrVariableToWatch];

      if (pVarData == NULL)
      {
         m_sync.Unlock();
         return LBU_OK;
      }
   }
   else
   {
      m_sync.Unlock();
      return LBU_OK;
   }


   CVariant variant;
   if (m_bUseSpecificRange == true && m_pRange != NULL)
   {
      variant = m_pRange->Lower();
      variant.ChangeType(pVarData->Type());
   }
   else
   {
      // Get the value from the parent graphical element.
      CVariant  *pVariant   =  m_pParentWidget->GetValue(CString(m_stlStrElementVar.c_str()));

      if (pVariant != NULL)
      {
         variant = *pVariant;
      }
      else
      {
         m_sync.Unlock();
         return LBU_OK;
      }
   }

   // At this point variant contains an integer which represents the position of the selected item in the list box,
   // so lookup this item in the list of runways and send the appropriate runway ident to the host.
   variant.Value(_FSI_STL::string(m_runway_list[(long)variant]));

   long lOffset = pVarData->ArrayOffset();
   pVarData->ArrayOffset(m_lElement);

   // Call the instantiated CCommsSystemInterface derived class' 
   // WriteData member to update simulation.
   m_pCommsSystemInterface->WriteData(&variant, pVarData);

   pVarData->ArrayOffset(lOffset);

   m_sync.Unlock();

   return LBU_OK;
}