// RunwayListShared.cpp: implementation of the CRunwayListShared class.
//
//////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#include "..\core\Action.h"
#include "RunwayListShared.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


char  CRunwayListShared::m_runway_list[MAX_RUNWAYS][RUNWAY_IDENT_LENGTH];
bool  CRunwayListShared::m_bool_list_has_changed =  false;
int   CRunwayListShared::m_runway_count          =  0;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CRunwayListShared::CRunwayListShared()
{
}

CRunwayListShared::~CRunwayListShared()
{
}

void  CRunwayListShared::LookupRunways(CString airport_id)
{
   CString  temp(airport_id);
   temp.MakeReverse();
   int      int_ident   =  (int)*(int *)LPCTSTR(temp);

   rdbStation  *pStation   =  COpenGLMap::rdbRadioDB.Runway(int_ident);

   m_runway_count          =  0;

   while (pStation)
   {
      rdbRWY      *pRunway =  (rdbRWY  *)pStation;

      CString     runway_id;
      runway_id   =  (char)((pRunway->nIdent &  0xff000000) >> 24);
      runway_id   += (char)((pRunway->nIdent &  0x00ff0000) >> 16);
      runway_id   += (char)((pRunway->nIdent &  0x0000ff00) >> 8);
      runway_id   += (char)((pRunway->nIdent &  0x000000ff));
      runway_id   += "\0";

      strncpy(m_runway_list[m_runway_count], LPCTSTR(runway_id), RUNWAY_IDENT_LENGTH);

      m_runway_count++;

      if (m_runway_count   >  MAX_RUNWAYS -  1)
         break;

      pStation =  COpenGLMap::rdbRadioDB.RunwayNext();
   }

   m_bool_list_has_changed =  true;
}

