#include "..\core\stdafx.h"
#include "RadioDatabaseComponentInterface.h"
 
#include "3DMapping.h"

#include "ApproachPlot.h"
#include "AreaMap.h"
#include "AreaMapLegend.h"

#include "FormationFlightRepositionPlanView.h"
#include "FormationFlightRepositionRearView.h"

#include "StationKillAction.h"
#include "NavaidKillIdentAction.h"
#include "LookupRunwayCommsAction.h"
#include "SelectRunwayCommsAction.h"

#include "MappingConfigPage.h"

#include "NavaidConfigPage.h"

#include "WeatherControl.h"
#include "ToleranceData.h"

#include "..\fsisuite\product_version.h"


#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// The following static members contain the date and time of the last
// compilation of this class.
const char CRadioDatabaseComponentInterface::m_cRevisionDate[] = __DATE__;
const char CRadioDatabaseComponentInterface::m_cRevisionTime[] = __TIME__;

/////////////////////////////////////////////////////////////////////////////
//
// CRadioDatabaseComponentInterface::CRadioDatabaseComponentInterface()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 26 October 1998
//
// Engineer         : Billy Baker
//
// Description      : This is the default constuctor for this class.  It 
//                    initializes the map of option pages, initializes 
//                    the string with the date and time of compilation, 
//                    and initializes the name of the component.
//
/////////////////////////////////////////////////////////////////////////////
CRadioDatabaseComponentInterface::CRadioDatabaseComponentInterface(
                                                  _FSI_STL::string stlStrPathName) :
                    CComponentInterface(_FSI_STL::string("Radio Database"),
                                        stlStrPathName)
{
    _FSI_STL::string stlStrDate(m_cRevisionDate);
    _FSI_STL::string stlStrTime(m_cRevisionTime);

    m_stlStrDate = stlStrDate + " " + stlStrTime;

    m_listPropPages.push_back(CMappingConfigPage::CreateObject);
    m_listPropPages.push_back(CNavaidConfigPage::CreateObject);

    m_listActions.push_back(CStationKillAction::CreateObject);
    m_listActions.push_back(CNavaidKillIdentAction::CreateObject);
    m_listActions.push_back(CLookupRunwayCommsAction::CreateObject);
    m_listActions.push_back(CSelectRunwayCommsAction::CreateObject);

    m_listWidgetCtrls.push_back(C3DMapping::CreateObject);

    m_listWidgetCtrls.push_back(CApproachPlot::CreateObject);
    m_listWidgetCtrls.push_back(CAreaMap::CreateObject);
    m_listWidgetCtrls.push_back(CAreaMapLegend::CreateObject);

    m_listWidgetCtrls.push_back(CFormationFlightRepositionPlanView::CreateObject);
    m_listWidgetCtrls.push_back(CFormationFlightRepositionRearView::CreateObject);



    CBitmap* pBmp = new CBitmap;
    pBmp->LoadBitmap(C3DMapping::IDB);
    m_listWidgetImages.push_back(pBmp);


    pBmp = new CBitmap;
    pBmp->LoadBitmap(CApproachPlot::IDB);
    m_listWidgetImages.push_back(pBmp);

    pBmp = new CBitmap;
    pBmp->LoadBitmap(CAreaMap::IDB);
    m_listWidgetImages.push_back(pBmp);

    pBmp = new CBitmap;
    pBmp->LoadBitmap(CAreaMapLegend::IDB);
    m_listWidgetImages.push_back(pBmp);

    pBmp = new CBitmap;
    pBmp->LoadBitmap(CFormationFlightRepositionPlanView::IDB);
    m_listWidgetImages.push_back(pBmp);

    pBmp = new CBitmap;
    pBmp->LoadBitmap(CFormationFlightRepositionRearView::IDB);
    m_listWidgetImages.push_back(pBmp);

}

/////////////////////////////////////////////////////////////////////////////
//
// CRadioDatabaseComponentInterface::~CRadioDatabaseComponentInterface()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 26 October 1998
//
// Engineer         : Billy Baker
//
// Description      : This is the default destructor for this class.  It 
//                    does not need to delete the option pages since 
//                    they are attached to a window when they are 
//                    created and will be deleted when that window is 
//                    destroyed.  The pointers in the map, though, are 
//                    freed with a call to the map clear() method in the
//                    base class destructor.
//
/////////////////////////////////////////////////////////////////////////////
CRadioDatabaseComponentInterface::~CRadioDatabaseComponentInterface()
{
}

/////////////////////////////////////////////////////////////////////////////
//
// void CRadioDatabaseComponentInterface::InitializeComponentConfig()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Description      : InitializeComponentConfig() is a common framework method
//                    used to read the configuration data for this DLL from
//                    the registry.
//
/////////////////////////////////////////////////////////////////////////////
void CRadioDatabaseComponentInterface::InitializeComponentConfig()
{
   CComponentInterface::InitializeComponentConfig();

   HKEY hKey;
   RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\") + CString(m_stlStrComponentName.c_str()), 0, KEY_READ, &hKey);

   if (hKey != NULL)
   {
      CString strValue;
      DWORD dwType, dwCount;

      unsigned long int ulData = 0;
      DWORD dwSize = sizeof (unsigned long int);

      // Get the IO source datafile name.
      LONG lResult = RegQueryValueEx(hKey, _T("RadioDatabaseFile"), 
                                     NULL, &dwType, NULL, &dwCount);
      if (lResult == ERROR_SUCCESS)
      {
         ASSERT(dwType == REG_SZ);
         lResult = RegQueryValueEx(hKey, _T("RadioDatabaseFile"), NULL, &dwType,
                                   (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                   &dwCount);

         strValue.ReleaseBuffer();
      }

      COpenGLMap::rdbRadioDB.Load((char*)(LPCTSTR)strValue);

      RegCloseKey(hKey);
   }

   CNavaidShared::m_navaid.CreateComms();

   CCommsShared::AddUpdateCallback(CWeatherControl::Update);
   CCommsShared::AddUpdateCallback(CToleranceData::Update);
}

void CRadioDatabaseComponentInterface::CleanComponentResources()
{
   CComponentInterface::CleanComponentResources();

   CCommsShared::DeleteUpdateCallback(CToleranceData::Update);
   CCommsShared::DeleteUpdateCallback(CWeatherControl::Update);
}

