// OpenGLMap.h: interface for the COpenGLMap class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_OPENGLMAP_H__1D2FF181_AFB5_11D2_AD62_006008B0E0C3__INCLUDED_)
#define AFX_OPENGLMAP_H__1D2FF181_AFB5_11D2_AD62_006008B0E0C3__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <afxtempl.h>
#include <gl\gl.h>              // OpenGL
#include <gl\glu.h>             // GLU library
#include "resource.h"
#include "iosRadioDB.h"

const double   NMI_FT         =  6076.1;
const double   NM_PER_DEGREE  =  60.0;

#define  glRGB(x, y, z) glColor3ub((GLubyte)x, (GLubyte)y, (GLubyte)z)

class COpenGLMap  
{
public:
	COpenGLMap();
	virtual ~COpenGLMap();

   virtual  void  Initialize(HWND hwnd);
   virtual  void  Draw(void);

   void  DrawAxes(float length);
   float m_width;
   float m_height;

   static CIosRadioDB rdbRadioDB;

   static   _FSI_STL::string  m_stlStrError;
   static   _FSI_STL::string  m_stlStrCaption;

   static   UINT              MsgThread(LPVOID param);

protected:
   void  BeginDraw(int red = 0, int green = 0, int blue = 0);
   void  EndDraw(void);
   float m_aspect_ratio;

   CRect rectViewCoord;
   CRect rectView;

   int m_list;

private:
	float m_border;
   HWND  m_hwnd;
   HDC   m_hDC;                     // GDI Device context
   HGLRC m_hRC;                     // Permenant Rendering context
};

#endif // !defined(AFX_OPENGLMAP_H__1D2FF181_AFB5_11D2_AD62_006008B0E0C3__INCLUDED_)
