// OpenGLMap.cpp: implementation of the COpenGLMap class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "OpenGLMap.h"
#include "..\general\OpenGLWidget.h"


#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

CIosRadioDB COpenGLMap::rdbRadioDB;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

COpenGLMap::COpenGLMap()
{
   m_border       =  0.1f;
   m_aspect_ratio =  1.0f;
   m_list         = -1;
}

COpenGLMap::~COpenGLMap()
{
   if (m_list != -1)
   {
      glDeleteLists(m_list, 1);
   }
}

void  COpenGLMap::Initialize(HWND hwnd)
{
   m_hwnd   =  hwnd;

   CRect rectangle;
   GetWindowRect(hwnd, &rectangle);

   rectViewCoord = rectangle;
   rectView = CRect(0,0,1152,800);

   // Get the size of the view.
   CWnd* pWnd = CWnd::FromHandle(m_hwnd);
   CFrameWnd* pFrame = pWnd->GetParentFrame();
   if (pFrame != NULL)
   {
       CView* pView = pFrame->GetActiveView();
       if (pView != NULL)
       {
           pView->GetWindowRect(&rectView);
           pView->ScreenToClient(&rectViewCoord);
       }
   }

   m_width  =  (float)rectangle.Width();
   m_height =  (float)rectangle.Height();

   m_aspect_ratio =  m_height /  m_width;
}

void  COpenGLMap::BeginDraw(int red, int green, int blue)
{
   if (m_hwnd == NULL)
   {
      return;
   }

   COpenGLWidget  *pWidget =  dynamic_cast<COpenGLWidget *>(this);
   if (pWidget)
   {
      if (pWidget->GetEditing())
      {
         glViewport(rectViewCoord.left, rectView.Height() - rectViewCoord.bottom, (int)m_width, (int)m_height);
         glScissor(rectViewCoord.left, rectView.Height() - rectViewCoord.bottom, (int)m_width, (int)m_height);
         glClear(GL_COLOR_BUFFER_BIT);
         Initialize(m_hwnd);
      }
   }


   glViewport(rectViewCoord.left, rectView.Height() - rectViewCoord.bottom, (int)m_width, (int)m_height);
   glScissor(rectViewCoord.left, rectView.Height() - rectViewCoord.bottom, (int)m_width, (int)m_height);

   glLoadIdentity();

   glOrtho(-m_width  /  2.0f, m_width  /  2.0f, -m_height   /  2.0f, m_height /  2.0f, 0.0f, -14400.0f);

   glScalef(m_width  /  2.0f, m_height /  2.0f, 1.0f);

   // Clear the background color.
   glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
   glRGB(red, green, blue);
   glBegin(GL_QUADS);
      glVertex2f(-1.0f,-1.0f);
      glVertex2f( 1.0f,-1.0f);
      glVertex2f( 1.0f, 1.0f);
      glVertex2f(-1.0f, 1.0f);
   glEnd();
   glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
}

void  COpenGLMap::EndDraw(void)
{
}

void  COpenGLMap::Draw()
{
}


void  COpenGLMap::DrawAxes(float length)
{
   glBegin(GL_LINES);
//      glColor3f(  0.0f, 1.0f,    0.0f);

      glRGB(255, 64, 64);
      glVertex3f( 0.0f,    0.0f, 0.0f);
      glVertex3f(length,   0.0f, 0.0f);   // x axis

      glRGB(64, 255, 64);
      glVertex3f( 0.0f, 0.0f,    0.0f);
//      glVertex3f( 0.0f, -length,    0.0f);
      glVertex3f( 0.0f, length,  0.0f);   // y axis

      glRGB(64, 64, 255);
      glVertex3f( 0.0f, 0.0f,    0.0f);
      glVertex3f( 0.0f, 0.0f,    length); // z axis
   glEnd();
}

_FSI_STL::string  COpenGLMap::m_stlStrError;
_FSI_STL::string  COpenGLMap::m_stlStrCaption;

UINT COpenGLMap::MsgThread(LPVOID param)
{
    ::MessageBox(NULL, _T(m_stlStrError.c_str()), _T(m_stlStrCaption.c_str()), MB_ICONEXCLAMATION |  MB_OK |  MB_SYSTEMMODAL);
    return 0;
}
