// NavaidSystemInterface.h: interface for the CNavaidSystemInterface class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_NAVAIDSYSTEMINTERFACE_H__7ACD83BF_BD5D_11D3_AE07_006008B0E0C3__INCLUDED_)
#define AFX_NAVAIDSYSTEMINTERFACE_H__7ACD83BF_BD5D_11D3_AE07_006008B0E0C3__INCLUDED_

#include  <string>
#include  <list>
#include "../comms/CommsAction.h"
#include "../core/changevalue.h"
#include "OpenGLMap.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CAction;
class CStationKillAction;
class CNavaidKillIdentAction;

const int   MAX_STATION_KILL  =  16;

class CNavaidSystemInterface  
{
public:
	CNavaidSystemInterface();
	virtual ~CNavaidSystemInterface();

   void     ChangeValue(const CString& rstrElementVar, CChangeValue* pCV);

   void     SetCurrentIdent(_FSI_STL::string &ident, bool reload  = true);
   void     SetPendingStatus(long status);
   _FSI_STL::string  GetCurrentIdent(void);

   int      GetCurrentConfiguration(void);
   long     GetCurrentStatus(void);
   long     GetPendingStatus(void);

   long     GetIdentStatus(const _FSI_STL::string &ident);
   long     GetIdentConfig(const _FSI_STL::string &ident);

   friend   class CStationKillAction;
   friend   class CNavaidKillIdentAction;

   void     CreateComms();

protected:
   _FSI_STL::string  m_stl_str_ident;

   _FSI_STL::list<CAction*>   m_listActions;

   int      m_int_configuration;
   long     m_long_status[MAX_STATION_KILL];
   CString  m_CStr_idents[MAX_STATION_KILL];
   double   m_latitude;
   double   m_longitude;
   long     m_pending_status;

   CAction  *m_pAction;

   CCommsAction   *m_CommsAction_latitude;
   CCommsAction   *m_CommsAction_longitude;
   CCommsAction   *m_CommsAction_host_status_array;
   CCommsAction   *m_CommsAction_host_idents_array;

   CXMLWidget     *m_XMLWidget_latitude;
   CXMLWidget     *m_XMLWidget_longitude;
   CXMLWidget     *m_XMLWidget_host_status_array;
   CXMLWidget     *m_XMLWidget_host_idents_array;

   void     FixupAndConvertIdent(CString &CStr_ident);
   long     DetermineConfiguration(rdbStation *pStation);

};

#endif // !defined(AFX_NAVAIDSYSTEMINTERFACE_H__7ACD83BF_BD5D_11D3_AE07_006008B0E0C3__INCLUDED_)
