// NavaidKillIdentAction.cpp: implementation of the CNavaidKillIdentAction class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "NavaidKillIdentAction.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CNavaidKillIdentAction::CNavaidKillIdentAction()
{
    m_stlStrWidgetName = _FSI_STL::string("NAVAID_Kill_Ident");
}

CNavaidKillIdentAction::~CNavaidKillIdentAction()
{
   m_navaid.m_pAction   =  NULL;
}

void CNavaidKillIdentAction::Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, const long lId, bool bEditMode)
{
    // Set the help text.
    if (rpXMLWidget == NULL)
    {
        m_stlStrName = m_stlStrName + " " + m_stlStrWidgetName.c_str();
    }

    // Call the base class.
    CWidget::Initialize(rpXMLWidget,pWnd, lId, bEditMode);

    ResetProperties();

    m_pAction = this;
    m_pWidget = (CWidget*)this;

    m_navaid.m_pAction  =  this;

    OnLoad();
}

/////////////////////////////////////////////////////////////////////////////
//
// CWidget* CNavaidKillIdentAction::CreateObject()
//
// Inputs           : None.
//
// Return Values    : Address of a new instance of CNavaidKillIdentAction.
//
// Date             : 08 October 1999
//
// Engineer         : Billy Baker
//
// Description      : CreateObject() is a common framework method that must be
//                    implemented by each CWidget derived class.  The main
//                    application associates the name of this widget with this
//                    static CreateObject method so that a new object can be
//                    created without linking against the library that contains
//                    this class.
//
/////////////////////////////////////////////////////////////////////////////
CWidget* CNavaidKillIdentAction::CreateObject()
{
    return new CNavaidKillIdentAction();
}

void CNavaidKillIdentAction::OnLoad()
{
   if (! m_bEditing)
      OnUpdate();
}

void CNavaidKillIdentAction::OnUpdate()
{
   if (m_pParentWidget == NULL)
   {
      return;
   }

   m_variant.Value(m_navaid.GetCurrentIdent());

   m_ChangeValue.Variant(&m_variant);
   m_pParentWidget->ChangeValue(CString("Default"), &m_ChangeValue);
   m_pParentWidget->UpdateRenderVariables();
   m_pParentWidget->Wnd()->Invalidate();
}


enum LButtonUpReturn CNavaidKillIdentAction::OnLButtonUp()
{
   if (m_pParentWidget == NULL)
   {
      return LBU_OK;
   }

   CVariant* pVariant = m_pParentWidget->GetValue(CString("Default"));

   m_navaid.SetCurrentIdent((_FSI_STL::string)*pVariant, false);

   return   LBU_NOT_IN_RANGE;    // Don't want edit box cleared no matter what happens.
}