// NavaidConfigPage.cpp : implementation file
//

#include "..\core\stdafx.h"
#include "NavaidConfigPage.h"
#include "..\comms\commsaction.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CNavaidConfigPage property page

CNavaidConfigPage::CNavaidConfigPage() : CBasePage(CNavaidConfigPage::IDD)
{
	//{{AFX_DATA_INIT(CNavaidConfigPage)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
    m_stlStrPageName = _FSI_STL::string("Navaid Config");
}

CNavaidConfigPage::~CNavaidConfigPage()
{
}

void CNavaidConfigPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CNavaidConfigPage)
	DDX_Control(pDX, IDC_NAVAID_STATUS_COMBO, m_ctrl_navaid_status);
	DDX_Control(pDX, IDC_NAVAID_IDENT_COMBO, m_ctrl_navaid_ident);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CNavaidConfigPage, CBasePage)
	//{{AFX_MSG_MAP(CNavaidConfigPage)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNavaidConfigPage message handlers

CBasePage* CNavaidConfigPage::CreateObject()
{
    return new CNavaidConfigPage;
}


void CNavaidConfigPage::SetProperties(void* pWidget)
{
   CString strComponentName = CString((char *)pWidget);
   HKEY hKey;

    // Open the registry.
   RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\") + strComponentName, 0, KEY_READ, &hKey);

   if (hKey != NULL)
   {
		CString strValue;
		DWORD dwType, dwCount;

		LONG lResult = RegQueryValueEx(hKey, _T("NavaidIdents"), 
                                       NULL, &dwType, NULL, &dwCount);
		if (lResult == ERROR_SUCCESS)
		{
			ASSERT(dwType == REG_SZ);
			lResult = RegQueryValueEx(hKey, _T("NavaidIdents"), NULL, &dwType,
				            (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                      &dwCount);

			strValue.ReleaseBuffer();
		}

      m_navaid_idents = strValue;

		lResult = RegQueryValueEx(hKey, _T("NavaidStatus"), 
                                       NULL, &dwType, NULL, &dwCount);
		if (lResult == ERROR_SUCCESS)
		{
	      ASSERT(dwType == REG_SZ);
			lResult = RegQueryValueEx(hKey, _T("NavaidStatus"), NULL, &dwType,
				            (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                      &dwCount);

			strValue.ReleaseBuffer();
		}

      m_navaid_status = strValue;

      RegCloseKey(hKey);
   }
}

/////////////////////////////////////////////////////////////////////////////
//
// void CMappingConfigPage::UpdateProperties()
//
// Inputs           : None.
//
// Return Values    : void* pWidget - for COptions property pages, pWidget
//                                    is the addrss of the name of the 
//                                    component whose configuration is being
//                                    changed or checked.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : UpdateProperties() is a common framework method that must
//                    be implemented by each CBasePage derived class. 
//                    UpdateProperties is called after the Ok or Apply button
//                    on the COptions dialog has been pressed.  Its purpose is
//                    to write the copnfiguration data to the registry.  Special
//                    code here determines if the comms protocol changed and if
//                    so creates a new comms system interface.  Also, if the
//                    IO source datafile changed, then it is reread.
//
/////////////////////////////////////////////////////////////////////////////
void CNavaidConfigPage::UpdateProperties(void* pWidget)
{
   if (GetSafeHwnd() == NULL)
   {
      return;
   }

   CString strComponentName = CString((char *)pWidget);
   HKEY hKey;
   DWORD dw;

   // Open the registry.
   RegCreateKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\") + strComponentName, 
                 0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dw);

   if (hKey != NULL)
   {
      UpdateData(TRUE);

      CString   navaid_idents;
      CString   navaid_status;

      if (m_ctrl_navaid_ident.GetCurSel() != CB_ERR)
      {
         m_ctrl_navaid_ident.GetLBText(m_ctrl_navaid_ident.GetCurSel(), navaid_idents);
      }

      if (m_ctrl_navaid_status.GetCurSel() != CB_ERR)
      {
         m_ctrl_navaid_status.GetLBText(m_ctrl_navaid_status.GetCurSel(), navaid_status);
      }

      RegSetValueEx(hKey, _T("NavaidIdents"), NULL, REG_SZ, 
                   (BYTE*)(LPCTSTR)navaid_idents,
                   navaid_idents.GetLength() + 1);

      RegSetValueEx(hKey, _T("NavaidStatus"), NULL, REG_SZ, 
                   (BYTE*)(LPCTSTR)navaid_status,
                   navaid_status.GetLength() + 1);

      RegCloseKey(hKey);
   }
}

BOOL CNavaidConfigPage::OnInitDialog() 
{
	CBasePage::OnInitDialog();
	
   m_ctrl_navaid_ident.ResetContent();

   // Attempt to fill in the variables from the comms system.
   if (CCommsAction::m_pCommsSystemInterface != NULL)
   {
     _FSI_STL::map<_FSI_STL::string,  CVariableData*>::iterator mIt;
     mIt = CCommsAction::m_pCommsSystemInterface->m_mapVarName2Data.begin();
     _FSI_STL::map<_FSI_STL::string,  CVariableData*>::iterator mendIt;
     mendIt = CCommsAction::m_pCommsSystemInterface->m_mapVarName2Data.end();

     // Fill the combobox with the variables from the current 
     // CCommsSystemInterface derived class.
     while (mIt != mendIt)
     {
         m_ctrl_navaid_ident.AddString(CString((*mIt).first.c_str()));
         mIt++;
     }

     m_ctrl_navaid_ident.SelectString(-1, m_navaid_idents.c_str());
   }

   m_ctrl_navaid_status.ResetContent();

   // Attempt to fill in the variables from the comms system.
   if (CCommsAction::m_pCommsSystemInterface != NULL)
   {
     _FSI_STL::map<_FSI_STL::string,  CVariableData*>::iterator mIt;
     mIt = CCommsAction::m_pCommsSystemInterface->m_mapVarName2Data.begin();
     _FSI_STL::map<_FSI_STL::string,  CVariableData*>::iterator mendIt;
     mendIt = CCommsAction::m_pCommsSystemInterface->m_mapVarName2Data.end();

     // Fill the combobox with the variables from the current 
     // CCommsSystemInterface derived class.
     while (mIt != mendIt)
     {
         m_ctrl_navaid_status.AddString(CString((*mIt).first.c_str()));
         mIt++;
     }

     m_ctrl_navaid_status.SelectString(-1, m_navaid_status.c_str());
   }
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
