#include "..\core\stdafx.h"
#include "MappingConfigPage.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCommsConfigPage Base page

/////////////////////////////////////////////////////////////////////////////
//
// CMappingConfigPage::CMappingConfigPage()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Default constructor.  Calls parent's constructor 
//                    passing the resource template ID for the property 
//                    page.  Sets the non-displayed name of the 
//                    property page.
//
/////////////////////////////////////////////////////////////////////////////
CMappingConfigPage::CMappingConfigPage() : CBasePage(CMappingConfigPage::IDD)
{
	//{{AFX_DATA_INIT(CMappingConfigPage)
	m_strRadioDatabaseFile = _T("");
	m_strAreamapCustomDataFile = _T("");
	m_strTacanChannelFile = _T("");
	//}}AFX_DATA_INIT
    m_stlStrPageName = _FSI_STL::string("Mapping Config");
}

/////////////////////////////////////////////////////////////////////////////
//
// CMappingConfigPage::~CMappingConfigPage()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Default destructor.
//
/////////////////////////////////////////////////////////////////////////////
CMappingConfigPage::~CMappingConfigPage()
{
}

void CMappingConfigPage::DoDataExchange(CDataExchange* pDX)
{
	CBasePage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMappingConfigPage)
	DDX_Text(pDX, IDC_RADIO_DATABASE_FILE, m_strRadioDatabaseFile);
	DDX_Text(pDX, IDC_AREAMAP_CUSTOM_DATA_FILE, m_strAreamapCustomDataFile);
	DDX_Text(pDX, IDC_TACAN_CHANNEL_FILE, m_strTacanChannelFile);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CMappingConfigPage, CBasePage)
	//{{AFX_MSG_MAP(CMappingConfigPage)
	ON_BN_CLICKED(IDC_RADIO_DATABASE_FILE_BUTTON, OnRadioDatabaseButton)
	ON_BN_CLICKED(IDC_AREAMAP_CUSTOM_DATA_FILE_BUTTON, OnAreamapCustomDataFileButton)
	ON_BN_CLICKED(IDC_TACAN_CHANNEL_FILE_BUTTON, OnTacanChannelFileButton)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
//
// CBasePage* CMappingConfigPage::CreateObject()
//
// Inputs           : None.
//
// Return Values    : Address of a new instance of CMappingConfigPage
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : CreateObject() is a common framework method that must be
//                    implemented by each CBasePage derived class.  The DLL
//                    that uses this page associates the name of this page with 
//                    this static CreateObject method so that a new object can be
//                    created without linking against the library that contains
//                    this class.
//
/////////////////////////////////////////////////////////////////////////////
CBasePage* CMappingConfigPage::CreateObject()
{
    return new CMappingConfigPage;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CMappingConfigPage::SetProperties()
//
// Inputs           : None.
//
// Return Values    : void* pWidget - for COptions property pages, pWidget
//                                    is the addrss of the name of the 
//                                    component whose configuration is being
//                                    changed or checked.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : SetProperties() is a common framework method that must be
//                    implemented by each CBasePage derived class. SetProperties
//                    is called after the property page has been created but
//                    before OnInitDialog().  Its purpose is to read the 
//                    registry for configuration data.
//
/////////////////////////////////////////////////////////////////////////////
void CMappingConfigPage::SetProperties(void* pWidget)
{
   CString  strComponentName  =  CString((char *)pWidget);
   HKEY hKey;

   // Open the registry.
   RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\") + strComponentName, 0, KEY_READ, &hKey);

   if (hKey != NULL)
   {
      CString  strValue;
      DWORD    dwType,  dwCount;

      LONG  lResult  =  RegQueryValueEx(hKey, _T("RadioDatabaseFile"), NULL, &dwType, NULL, &dwCount);
      if (lResult == ERROR_SUCCESS)
      {
         ASSERT(dwType  == REG_SZ);
         lResult  =  RegQueryValueEx(hKey, _T("RadioDatabaseFile"), NULL, &dwType, (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)), &dwCount);
         strValue.ReleaseBuffer();
      }
      m_strRadioDatabaseFile  =  strValue;


      lResult  =  RegQueryValueEx(hKey, _T("AreaMapCustomDataFile"), NULL, &dwType, NULL, &dwCount);
      if (lResult == ERROR_SUCCESS)
      {
         ASSERT(dwType  == REG_SZ);
         lResult  =  RegQueryValueEx(hKey, _T("AreaMapCustomDataFile"), NULL, &dwType, (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)), &dwCount);
         strValue.ReleaseBuffer();
      }
      m_strAreamapCustomDataFile =  strValue;

      lResult  =  RegQueryValueEx(hKey, _T("TacanChannelDataFile"), NULL, &dwType, NULL, &dwCount);
      if (lResult == ERROR_SUCCESS)
      {
         ASSERT(dwType  == REG_SZ);
         lResult  =  RegQueryValueEx(hKey, _T("TacanChannelDataFile"), NULL, &dwType, (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)), &dwCount);
         strValue.ReleaseBuffer();
      }
      m_strTacanChannelFile      =  strValue;

      RegCloseKey(hKey);
   }
}

/////////////////////////////////////////////////////////////////////////////
//
// void CMappingConfigPage::UpdateProperties()
//
// Inputs           : None.
//
// Return Values    : void* pWidget - for COptions property pages, pWidget
//                                    is the addrss of the name of the 
//                                    component whose configuration is being
//                                    changed or checked.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : UpdateProperties() is a common framework method that must
//                    be implemented by each CBasePage derived class. 
//                    UpdateProperties is called after the Ok or Apply button
//                    on the COptions dialog has been pressed.  Its purpose is
//                    to write the copnfiguration data to the registry.  Special
//                    code here determines if the comms protocol changed and if
//                    so creates a new comms system interface.  Also, if the
//                    IO source datafile changed, then it is reread.
//
/////////////////////////////////////////////////////////////////////////////
void CMappingConfigPage::UpdateProperties(void* pWidget)
{
   if (GetSafeHwnd() == NULL)
      return;

   CString  strComponentName  =  CString((char *)pWidget);
   HKEY  hKey;
   DWORD dw;

   // Open the registry.
   RegCreateKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\") + strComponentName, 0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dw);

   if (hKey != NULL)
   {
      UpdateData(TRUE);

      RegSetValueEx(hKey,  _T("RadioDatabaseFile"),      NULL, REG_SZ, 
                    (BYTE*)(LPCTSTR)m_strRadioDatabaseFile,       m_strRadioDatabaseFile.GetLength()  +  1);

      RegSetValueEx(hKey,  _T("AreaMapCustomDataFile"),  NULL, REG_SZ, 
                     (BYTE*)(LPCTSTR)m_strAreamapCustomDataFile,  m_strAreamapCustomDataFile.GetLength() +  1);

      RegSetValueEx(hKey,  _T("TacanChannelDataFile"),  NULL, REG_SZ, 
                     (BYTE*)(LPCTSTR)m_strTacanChannelFile,  m_strTacanChannelFile.GetLength() +  1);

      RegCloseKey(hKey);
   }
}

/////////////////////////////////////////////////////////////////////////////
//
// void CMappingConfigPage::OnVariablesButton()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Description      : OnVariablesButton() handles clicks on the button 
//                    to browse for the name of the Variables file.  A 
//                    common file dialog is created and displayed.
//
/////////////////////////////////////////////////////////////////////////////
void CMappingConfigPage::OnRadioDatabaseButton() 
{
   // Get all of the current data.
   UpdateData(TRUE);

   CFileDialog cfd(TRUE, "bin", m_strRadioDatabaseFile,
                   OFN_SHAREAWARE | OFN_PATHMUSTEXIST | OFN_HIDEREADONLY,
                   "Radio Database File (*.bin)|*.bin|All Files (*.*)|*.*||",
                   this);

   long  int   lRetVal  =  cfd.DoModal();

   // If ok was clicked, then update the name of the file.
   if (lRetVal == IDOK)
   {
      m_strRadioDatabaseFile  =  cfd.GetPathName();
      UpdateData(FALSE);
   }
}

void CMappingConfigPage::OnAreamapCustomDataFileButton() 
{
   // Get all of the current data.
   UpdateData(TRUE);

   CFileDialog cfd(TRUE, "ini", m_strAreamapCustomDataFile,
                   OFN_SHAREAWARE | OFN_PATHMUSTEXIST | OFN_HIDEREADONLY,
                   "Radio Database File (*.ini)|*.ini|All Files (*.*)|*.*||",
                   this);

   long  int   lRetVal  =  cfd.DoModal();

   // If ok was clicked, then update the name of the file.
   if (lRetVal == IDOK)
   {
      m_strAreamapCustomDataFile =  cfd.GetPathName();
      UpdateData(FALSE);
   }
}

void CMappingConfigPage::OnTacanChannelFileButton() 
{
   // Get all of the current data.
   UpdateData(TRUE);

   CFileDialog cfd(TRUE, "csv", m_strAreamapCustomDataFile,
                   OFN_SHAREAWARE | OFN_PATHMUSTEXIST | OFN_HIDEREADONLY,
                   "Tacan Channel File (*.csv)|*.csv|All Files (*.*)|*.*||",
                   this);

   long  int   lRetVal  =  cfd.DoModal();

   // If ok was clicked, then update the name of the file.
   if (lRetVal == IDOK)
   {
      m_strTacanChannelFile   =  cfd.GetPathName();
      UpdateData(FALSE);
   }
}

BOOL CMappingConfigPage::OnInitDialog() 
{
	CBasePage::OnInitDialog();

#ifdef   HAF
   GetDlgItem(IDC_TACAN_CHANNEL_FILE)->EnableWindow(TRUE);
   GetDlgItem(IDC_TACAN_CHANNEL_FILE_BUTTON)->EnableWindow(TRUE);
   GetDlgItem(IDC_STATIC_TACAN_CHANNEL_FILE)->EnableWindow(TRUE);
#else
   GetDlgItem(IDC_TACAN_CHANNEL_FILE)->EnableWindow(FALSE);
   GetDlgItem(IDC_TACAN_CHANNEL_FILE_BUTTON)->EnableWindow(FALSE);
   GetDlgItem(IDC_STATIC_TACAN_CHANNEL_FILE)->EnableWindow(FALSE);
#endif
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
