/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : LookupRunwayCommsAction.cpp
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.19 $
//
// Description      : LookupRunwayCommsAction.cpp contains the implementation of the 
//                    CLookupRunwayCommsAction class.  This action is derived from 
//                    Core::CIOAction.  Its purpose is to distribute a 
//                    value to a graphical element in its OnUpdate 
//                    member.  This member is called from 
//                    CCommsSystemInterface::UpdateComms().  
//                    CCommsSystemInterface keeps track of all 
//                    CLookupRunwayCommsAction instances so that it may update all 
//                    of them.  Each CLookupRunwayCommsAction instance shares a 
//                    single CVariant instance.  Thus, many graphical 
//                    elements may want the value of a variable and 
//                    each graphical element will have an instance of a 
//                    CLookupRunwayCommsAction to read that variable.  However, the 
//                    value will be read from simulation once and 
//                    placed in the shared CVariant.  CLookupRunwayCommsAction will 
//                    also update simulation variable in OnLButtonUp.  
//                    This member will be called whenever an action 
//                    occurs on a graphical element.  The action might 
//                    be clicking a button or pressing the 
//                    enter/carriage return key while in an editbox.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : Core::CIOAction, Core::CWidget, Comms::CCommsShared, 
//                    Core::CVariant, _FSI_STL::string, _FSI_STL::list, _FSI_STL::map, 
//                    _FSI_STL::vector, Comms::CCommsSystemInterface, 
//                    Core::CChangeValue, Core::CRange.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 4
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: LookupRunwayCommsAction.cpp $
// Revision 1.1  1999/04/02 19:41:28  billyb
/////////////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#include "LookupRunwayCommsAction.h"

#include "..\core\DataConversion.h"

#include <algorithm>

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


/////////////////////////////////////////////////////////////////////////////
//
// CLookupRunwayCommsAction::CLookupRunwayCommsAction
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Default constructor.  Sets the name of the widget.
//                    Adds the CLookupRunwayCommsActionPage to the list of widget
//                    property pages.
/////////////////////////////////////////////////////////////////////////////
CLookupRunwayCommsAction::CLookupRunwayCommsAction()
{
    m_stlStrWidgetName = _FSI_STL::string("Lookup_Runway_Comms");
}

/////////////////////////////////////////////////////////////////////////////
//
// CWidget* CLookupRunwayCommsAction::CreateObject()
//
// Inputs           : None.
//
// Return Values    : Address of a new instance of CLookupRunwayCommsAction.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : CreateObject() is a common framework method that must be
//                    implemented by each CWidget derived class.  The main
//                    application associates the name of this widget with this
//                    static CreateObject method so that a new object can be
//                    created without linking against the library that contains
//                    this class.
//
/////////////////////////////////////////////////////////////////////////////
CWidget* CLookupRunwayCommsAction::CreateObject()
{
    return new CLookupRunwayCommsAction();
}


/////////////////////////////////////////////////////////////////////////////
//
// void CLookupRunwayCommsAction::OnUpdate()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : OnUpdate() is a common framework method for CAction
//                    derived classes.  Its purpose is to send a new value
//                    to its parent graphical widget.  OnUpdate should 
//                    generally be called by some other class than the parent 
//                    graphical element.
//
/////////////////////////////////////////////////////////////////////////////
void CLookupRunwayCommsAction::OnUpdate()
{
   if (((m_bReadOnce    == true  && m_bRead  == false)         ||
        (m_bReadChanged == true  && m_pVariant->WasChanged(m_lElement)  == true) || 
        (m_bReadAlways  == true) || (m_bInitialRead == true))  && 
        (m_bReadOnce    == true  || m_bReadChanged == true  || m_bReadAlways == true))
   {
      CString  airport_id(((_FSI_STL::string)*m_pVariant).c_str());
      airport_id.MakeUpper();
      LookupRunways(airport_id);
   }

   CCommsAction::OnUpdate();
}

