#ifndef __IOSRADIODB_H__
#define __IOSRADIODB_H__

#include <vector>
using namespace std;

// Fixed fsi_rdb.rdb file offsets.

const int RADIODB_APT_SIZE					=88;
const int RADIODB_AIRPT_TABLE_DATA_OFFSET	=164;
const int RADIODB_COM_SIZE					=108;
const int RADIODB_FREQ_TABLE_DATA_OFFSET	=116;
const int RADIODB_IDENT_TABLE_DATA_OFFSET	=132;
const int RADIODB_ILS_SIZE					=100;
const int RADIODB_LATLON_TABLE_DATA_OFFSET	=148;
const int RADIODB_MLS_SIZE					=104;
const int RADIODB_RWY_SIZE					=96;
const int RADIODB_STATIONS_OFFSET			=256;
const int RADIODB_TWPT_SIZE					=92;

// Station table element data structures.

	typedef	struct
	{
			int		nIdent;
			int		nICAO;
			int		nType1;
			int		nType2;
			int		nLat;
			int		nLon;
			short	sMvarX10;
			short	sElev;
			long	n3Id;
			short	Spare1;
			char	chName[30];
	}		rdbAPT;

	typedef	struct
	{
			int		nIdent;
			int		nICAO;
			int		nType1;
			int		nType2;
			int		nLat;
			int		nLon;
			short	sMvarX10;
			short	sElev;
			short	sMorseCode;
			short	sHdgX10;
	}		rdbAWM;

	typedef	struct
	{
			int		nIdent;
			int		nICAO;
			int		nType1;
			int		nType2;
			int		nLat;
			int		nLon;
			short	sMvarX10;
			short	sElev;
			unsigned short	sFreqX100;
			short	sSpare;
	}		rdbCOM;

	typedef	struct
	{
			char	chIdent[4];
			int		nICAO;
			int		nType1;
			UINT	chIdent5	:8;
			UINT				:8;
			UINT	Continuation:8;
			UINT				:1;	// Spare
			UINT	RouteType	:3;	// TBD
			UINT	bHi			:1;	// 1 = High Alt
			UINT	bLo			:1;	// 1 = Low Alt
			UINT				:2;	// Spare
			int		nLatLon[6][2];
	}		rdbENR;

	typedef	struct
	{
			int		nIdent;
			int		nICAO;
			int		nType1;
			int		nType2;
			int		nLat;
			int		nLon;
			short	sCourseX10;
			short	sLegLength;
			short	sSpare;
			short	sSpare2;
	}		rdbHP;

	typedef	struct
	{
			int		nIdent;
			int		nICAO;
			int		nType1;
			int		nType2;
			int		nLat;
			int		nLon;
			short	sMvarX10;
			short	sElev;
			unsigned short	sFreqX100;
			short	sThdgX10;
			int		nAptIdent;
			int		nRwyIdent;
			short	sLgd;		
			short	sLbwX100;	
			short	sGsaX100;	
			short	sGsw;		
			int		nDmeLat;
			int		nDmeLon;
			int		nImLat;
			int		nImLon;
			int		nMmLat;
			int		nMmLon;
			int		nOmLat;
			int		nOmLon;
			short	sGsDist;
			short	spare;
	}		rdbILS;

	typedef	struct
	{
			int		nIdent;
			int		nICAO;
			int		nType1;
			int		nType2;
			int		nLat;
			int		nLon;
			unsigned short	sMvarX10;
			short	sElev;
			unsigned short	sFreqX100;
			short	sThdgX10;
			int		nAptIdent;
			int		nRwyIdent;
			short	sAedLgd;	
			short	sLrApa;		
			short	sLrAca;		
			short	sEasGsw;	
			short	sNeaGsa;	
			short	sMinGpa;	
			short	sBatadLgd;	
			short	sLrBpa;		
			short	sLrBca;		
			short	sTbabX10;	
			short	sGsd;		
			short	sSpare;	
	}		rdbMLS;

	typedef	struct
	{
			int		nIdent;
			int		nICAO;
			int		nType1;
			int		nType2;
			int		nLat;
			int		nLon;
			short	sMvarX10;
			short	sElev;
			unsigned short	sFreqX100;
			short	sSpare;
	}		rdbNDB;

	typedef	struct
	{
			int		nIdent;
			int		nICAO;
			int		nType1;
			int		nType2;
			int		nLat;
			int		nLon;
			short	sThdgx10;
			short	sLen;
			short	sDispThr;
			short	sWidth;
			int		nLocIdent;
			int		nAptIdent;
	}		rdbRWY;

	typedef struct
	{
			int		nIdent;
			int		nICAO;
			int		nType1;
			int		nType2;
			int		nLat;
			int		nLon;
			int		nMisc;
	}		rdbStation;

	typedef	struct
	{
			int		nIdent;
			int		nICAO;
			int		nType1;
			int		nType2;
			int		nLat;
			int		nLon;
			short	sMvarX10;
			short	sElev;
			unsigned short	sFreqX100;
			short	sDeclX10;
	}		rdbVHF;

	typedef	struct
	{
			int		nIdent;
			int		nICAO;
			int		nType1;
			int		nType2;
			int		nLat;
			int		nLon;
			short	sMvarX10;
			short	sSpare;
			short	sSpare2;
			short	sSpare3;
	}		rdbWPT;

// Type 1 (Facility) Type Codes
//
// Bit Position:
//   31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 15 14 13 12 11 10  9  8  7  6  5  4  3  2  1  0
// Mnemonic:
//    .  I  M  V  D  T  .  .  N  A  C  .  .  .  .  .  A  R  E  E  T  .  .  .  .  .  .  .  .  .  .  .
//    .  L  L  O  M  A  .  .  D  W  O  .  .  .  .  .  P  W  N  W  W  H  .  .  .  .  .  .  .  .  .  .
//    .  S  S  R  E  C  .  .  B  M  M  .  .  .  .  .  T  Y  R  P  P  P  .  .  .  .  .  .  .  .  .  .
// Bit Value:
//    8  4  2  1  8  4  2  1  8  4  2  1  8  4  2  1  8  4  2  1  8  4  2  1  8  4  2  1  8  4  2  1

const unsigned long rdbType1NULL = 0x00000000u;
const unsigned long rdbType1ILS	 = 0x40000000u;
const unsigned long rdbType1MLS	 = 0x20000000u;
const unsigned long rdbType1VOR	 = 0x10000000u;
const unsigned long rdbType1DME	 = 0x08000000u;
const unsigned long rdbType1TAC	 = 0x04000000u;
const unsigned long rdbType1NDB	 = 0x00800000u;
const unsigned long rdbType1AWM	 = 0x00400000u;
const unsigned long rdbType1COM	 = 0x00200000u;
const unsigned long rdbType1APT	 = 0x00008000u;
const unsigned long rdbType1RWY	 = 0x00004000u;
const unsigned long rdbType1ENR	 = 0x00002000u;
const unsigned long rdbType1WPT	 = 0x00001000u;
const unsigned long rdbType1TWPT = 0x00000800u;
const unsigned long rdbType1HP	 = 0x00000400u;

const unsigned long rdbType1VORDME		= (rdbType1VOR|rdbType1DME);
const unsigned long rdbType1VORTAC		= (rdbType1VOR|rdbType1TAC);
const unsigned long rdbType1DMETAC		= (rdbType1DME|rdbType1TAC);
const unsigned long rdbType1VORDMETAC	= (rdbType1VOR|rdbType1DME|rdbType1TAC);
const unsigned long rdbType1ILSDME		= (rdbType1ILS|rdbType1DME);

const unsigned long rdbType2CLEARANCE	= 0x41000000u; 
const unsigned long rdbType2ATIS		= 0x42000000u; 
const unsigned long rdbType2APPROACH	= 0x48000000u;  
const unsigned long rdbType2DEPARTURE	= 0x44000000u;  
const unsigned long rdbType2GROUND		= 0x50000000u;
const unsigned long rdbType2TOWER		= 0x60000000u;
const unsigned long rdbType2HIGHFREQ	= 0x00000000u; 


// Lat/Lon table element structure.

typedef	struct
{
		int			nLat;
		int			nLon;
		rdbStation*	pStation;
}		rdbLatLon;


typedef vector<rdbStation *> VecStation;

typedef vector<double> StationDistances;

/////////////////////////////////////////////////////////////////////////////
// CIosRadioDB

class CIosRadioDB
{
// Construction
public:
	CIosRadioDB();
	virtual ~CIosRadioDB();

// Attributes
private:
	rdbStation**	m_pFreq;
	int				m_nFreqTableRecords;
	rdbStation**	m_pIdent;
	int				m_nIdentName;
	int				m_nIdentPosition;
	int				m_nIdentTableRecords;
	rdbStation*		m_pILS;
	rdbLatLon*		m_pLatLon;
	int				m_nLatLonTableRecords;
	rdbStation*		m_pRunway;
	int				m_nStation;
	rdbStation*		m_pStations;

// Operations
public:
	rdbStation*		Airport(int nIdent);
	rdbStation*		Ident(int nIdent);
	rdbStation*		IdentNext(void);
	rdbStation*		ILS(int nIdent);
	rdbStation*		ILSNext(void);
	BOOL			Load(const char * chPathName);
	rdbStation*		Runway(int nIdent);
	rdbStation*		RunwayNext(void);
	rdbStation*		StationFirst(void);
	rdbStation*		StationFirstLat(double dLatitudeMin, double dLatitudeMax);
	rdbStation*		StationNext(rdbStation* pStation);
	rdbStation*		StationNextLat(double dLatitudeMin, double dLatitudeMax);
	rdbStation*		NearestNavAid(int nIdent, double dLat, double dLon, int & nNumDups);
	void			AdjacentNavAids(rdbStation *pCurrStation, double dDistance, VecStation & vecpStations);
	void			AdjacentStations(double dLatitude, double dLongitude, double dSearchRadius, VecStation & vecpStations, StationDistances & vecStationDistances, int nStationType);

	// Implementation
private:
	void SwapStationData(void);
	bool LoadStations(FILE *fpFile);
	bool LoadTable(FILE *fpFile, int nHeaderLoc, void **ppBuffer, int nRecordSize, int &nNumOfRecords);
	bool Delete();
   bool  m_bool_intel_format;
};

/////////////////////////////////////////////////////////////////////////////

#endif // __IOSRADIODB_H__