// FormationFlightRepositionRearView.cpp: implementation of the CFormationFlightRepositionRearView class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "FormationFlightRepositionRearView.h"
#include "..\core\DataConversion.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


const int   GRID_NUMBER_OF_TICKS    =  4;
const float ORIGINAL_SCALE          =  140.0f;
const float GRID_SPACING_OF_TICKS   =  0.25f;
const float GRID_INNER_TICK         =  GRID_SPACING_OF_TICKS   /  2.0f;


BEGIN_MESSAGE_MAP(CFormationFlightRepositionRearView, COpenGLWidget)
   //{{AFX_MSG_MAP(CFormationFlightRepositionRearView)
   ON_WM_LBUTTONUP()
   ON_WM_MOUSEMOVE()
   //}}AFX_MSG_MAP
END_MESSAGE_MAP()

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CFormationFlightRepositionRearView::CFormationFlightRepositionRearView()
{
   m_exPtUpperLeft      =  CExtentsPoint(CPoint(0,0));
   m_exPtLowerRight     =  CExtentsPoint(CPoint(320,320));

   m_stlStrWidgetName   =  _FSI_STL::string("Formation_Flight_Reposition_Rear_View");

   m_listGraphicalElementVars.clear();

   m_listGraphicalElementVars.push_back("ac_latitude_lead");
   m_listGraphicalElementVars.push_back("ac_longitude_lead");
   m_listGraphicalElementVars.push_back("ac_heading_lead");
   m_listGraphicalElementVars.push_back("ac_altitude_lead");

   m_listGraphicalElementVars.push_back("ac_latitude_wing");
   m_listGraphicalElementVars.push_back("ac_longitude_wing");
   m_listGraphicalElementVars.push_back("ac_altitude_wing");

   m_listGraphicalElementVars.push_back("Reposition Above_Below");
   m_listGraphicalElementVars.push_back("Reposition Fore_Aft");
   m_listGraphicalElementVars.push_back("Reposition Left_Right");
   m_listGraphicalElementVars.push_back("Reposition Select");

   m_listGraphicalElementVars.push_back("formation_reposition_id");

   m_scale     =  ORIGINAL_SCALE;

   m_touch_reposition_requested  =  true;

   m_mouse_x_position   =  0;
   m_mouse_y_position   =  0;
   m_CVar_mouse_above_below.Value(0.0f);
   m_CVar_mouse_fore_aft.Value(0.0f);
   m_CVar_mouse_left_right.Value(0.0f);
}

CFormationFlightRepositionRearView::~CFormationFlightRepositionRearView()
{
}


void  CFormationFlightRepositionRearView::Setup(void)
{
   COpenGLMap::Initialize(GetSafeHwnd());

   webLabel.SetForegroundColor(96, 192, 96);
   webLabel.SetBackgroundColor(true, 0, 0, 0);

   units.SetForegroundColor(96, 192, 96);

   leadSymbol.SetForegroundColor(0, 255, 255);
   m_CStr_leadSymbol =  "L";
   wingSymbol.SetForegroundColor(255, 0, 255);
   m_CStr_wingSymbol =  "W";

   m_CStr_units      =  "FT";

   leadModel.Initialize(NOT_ANY);
   leadModel.SetGearPosition(NOSE_GEAR,    0.0f);
   leadModel.SetGearPosition(LEFT_GEAR,    0.0f);
   leadModel.SetGearPosition(RIGHT_GEAR,   0.0f);

   wingModel.Initialize(NOT_ANY);
   wingModel.SetGearPosition(NOSE_GEAR,    0.0f);
   wingModel.SetGearPosition(LEFT_GEAR,    0.0f);
   wingModel.SetGearPosition(RIGHT_GEAR,   0.0f);
}


void  CFormationFlightRepositionRearView::Render(void)
{
   BeginDraw();

   // Draw the standard stuff.
   COpenGLMap::Draw();

   glPushMatrix();
   {
      glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);

      float scale_factor   =  ORIGINAL_SCALE /  m_scale;

      glRGB(64, 64, 64);
      // Draw horizontal line.
      glBegin(GL_LINES);
         glVertex2f(-1.00f,   0.0f);
         glVertex2f( 1.00f,   0.0f);
      glEnd();
/*
      // Draw horizontal line.
      glBegin(GL_LINES);
         glVertex2f(-1.00f,   GRID_INNER_TICK   *  scale_factor);
         glVertex2f( 1.00f,   GRID_INNER_TICK   *  scale_factor);
      glEnd();
      glBegin(GL_LINES);
         glVertex2f(-1.00f,  -GRID_INNER_TICK   *  scale_factor);
         glVertex2f( 1.00f,  -GRID_INNER_TICK   *  scale_factor);
      glEnd();
*/
      // Draw vertical lines on each side of the lead aircraft.
      glBegin(GL_LINES);
         glVertex2f( GRID_INNER_TICK   *  scale_factor,  -1.00f);
         glVertex2f( GRID_INNER_TICK   *  scale_factor,   1.00f);
      glEnd();
      glBegin(GL_LINES);
         glVertex2f(-GRID_INNER_TICK   *  scale_factor,  -1.00f);
         glVertex2f(-GRID_INNER_TICK   *  scale_factor,   1.00f);
      glEnd();

      float radius   =  (GRID_SPACING_OF_TICKS  /  scale_factor)  +  GRID_INNER_TICK;
      for (int ii =  0; ii <  GRID_NUMBER_OF_TICKS;   ii++, radius   += GRID_SPACING_OF_TICKS   /  scale_factor)
      {
         m_CStr_webLabel.Format("%2.0f",  (35.0f   /  scale_factor)  *  (ii   +  1));

         glRGB(64, 64, 64);
         // Draw vertical lines.
         glBegin(GL_LINES);
            glVertex2f( radius   *  scale_factor,  -1.00f);
            glVertex2f( radius   *  scale_factor,   1.00f);
         glEnd();
         glBegin(GL_LINES);
            glVertex2f(-radius   *  scale_factor,  -1.00f);
            glVertex2f(-radius   *  scale_factor,   1.00f);
         glEnd();
         // Label vertical lines.
         glPushMatrix();
            glTranslatef(radius  *  scale_factor,   0.0f, 0.0f);
            webLabel.Draw(m_CStr_webLabel, true, 0.0f, 0.85f);
         glPopMatrix();
         glPushMatrix();
            glTranslatef(-radius *  scale_factor,   0.0f, 0.0f);
            webLabel.Draw(m_CStr_webLabel, true, 0.0f, 0.85f);
         glPopMatrix();


         glRGB(64, 64, 64);
         radius   -= GRID_INNER_TICK;
            // Draw horizontal lines.
            glBegin(GL_LINES);
               glVertex2f(-1.00f,   radius   *  scale_factor);
               glVertex2f( 1.00f,   radius   *  scale_factor);
            glEnd();
            glBegin(GL_LINES);
               glVertex2f(-1.00f,  -radius   *  scale_factor);
               glVertex2f( 1.00f,  -radius   *  scale_factor);
            glEnd();
            // Label horizontal lines.
            glPushMatrix();
               glTranslatef(0.0f, radius  *  scale_factor, 0.0f);
               webLabel.Draw(m_CStr_webLabel, true, 0.0f, 0.85f);
            glPopMatrix();
            glPushMatrix();
               glTranslatef(0.0f, -radius *  scale_factor, 0.0f);
               webLabel.Draw(m_CStr_webLabel, true, 0.0f, 0.85f);
            glPopMatrix();
         radius   += GRID_INNER_TICK;
      }


      if (m_scale >  280.0f)
      {
         leadSymbol.Draw(m_CStr_leadSymbol, true, 0.0f, 1.5f, 2.0f);    // Centered at 0, 0, 0.

         glPushMatrix();
            glTranslatef(m_x_offset /  m_scale, m_y_offset  /  m_scale, 0.0f);
            wingSymbol.Draw(m_CStr_wingSymbol, true, 0.0f, 1.5f, 2.0f);
         glPopMatrix();
      }
      else
      {
         glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
         glEnable(GL_DEPTH_TEST);
         glClear(GL_DEPTH_BUFFER_BIT);
         glEnable(GL_CULL_FACE);
         {
            glPushMatrix();
               glScalef(scale_factor,  scale_factor,  scale_factor);
               glTranslatef(0.0f, 0.0f, 0.0f);
               glRotatef(180.0f,  0.0f, 1.0f, 0.0f);
               glScalef(1.0f  /  3000.0f,  1.0f  /  3000.0f,  1.0f  /  3000.0f);
               leadModel.Render();
            glPopMatrix();

            glPushMatrix();
               glTranslatef(m_x_offset /  m_scale, m_y_offset  /  m_scale, 0.0f);
               glScalef(scale_factor,  scale_factor,  scale_factor);
               glRotatef(180.0f,  0.0f, 1.0f, 0.0f);
               glScalef(1.0f  /  3000.0f,  1.0f  /  3000.0f,  1.0f  /  3000.0f);
               wingModel.Render();
            glPopMatrix();
         }
         glDisable(GL_CULL_FACE);
         glDisable(GL_DEPTH_TEST);
      }

      glPushMatrix();
         glTranslatef(0.9f, -0.925f, 0.0f);
         units.Draw(m_CStr_units,   true, 0.0f, 1.5f);
      glPopMatrix();

      
      static   int   lpv_x_position =  0;
      static   int   lpv_y_position =  0;

      if (lpv_y_position   != m_mouse_y_position)
      {
         lpv_y_position          =  m_mouse_y_position;
         double   height_in_feet =  2.0f  *  m_scale;
         float    y_offset       =  -(height_in_feet  /  (m_height   -  1) *  m_mouse_y_position   -  height_in_feet /  2.0f);
         m_CVar_mouse_above_below.Value(y_offset);
      }

      if (lpv_x_position   != m_mouse_x_position)
      {
         lpv_x_position          =  m_mouse_x_position;
         double   width_in_feet  =  2.0f  *  m_scale;
         float    x_offset       =  width_in_feet  /  (m_width -  1) *  m_mouse_x_position   -  width_in_feet  /  2.0f;
         m_CVar_mouse_left_right.Value(x_offset);
      }
/*
      glPushMatrix();
         glTranslatef(-0.5f, 0.925f, 0.0f);
         m_CStr_mouseXposition.Format("X %d %2.2f", m_mouse_x_position, (float)m_CVar_mouse_left_right);
         mouseXposition.Draw(m_CStr_mouseXposition,   true, 0.0f, 1.0f);
      glPopMatrix();
      glPushMatrix();
         glTranslatef( 0.5f, 0.925f, 0.0f);
         m_CStr_mouseYposition.Format("Y %d %2.2f", m_mouse_y_position, (float)m_CVar_mouse_above_below);
         mouseYposition.Draw(m_CStr_mouseYposition,   true, 0.0f, 1.0f);
      glPopMatrix();
*/
   }
   glPopMatrix();

   EndDraw();
}


CWidget* CFormationFlightRepositionRearView::CreateObject()
{
   return new CFormationFlightRepositionRearView();
}


void CFormationFlightRepositionRearView::ChangeValue(const CString& rstrElementVar, CChangeValue* pCV)
{
   if (pCV == NULL)
   {
       return;
   }
   CVariant* pVariant = pCV->Variant();

   if (rstrElementVar    == "ac_latitude_lead")
   {
      m_ac_latitude_lead_cv   =  *pVariant;
   }
   else if (rstrElementVar    == "ac_longitude_lead")
   {
      m_ac_longitude_lead_cv  =  *pVariant;
   }
   else if (rstrElementVar    == "ac_heading_lead")
   {
      m_ac_heading_lead_cv    =  *pVariant;
   }
   else if (rstrElementVar    == "ac_altitude_lead")
   {
      m_ac_altitude_lead_cv   =  *pVariant;
   }
   else if (rstrElementVar    == "ac_latitude_wing")
   {
      m_ac_latitude_wing_cv   =  *pVariant;
   }
   else if (rstrElementVar    == "ac_longitude_wing")
   {
      m_ac_longitude_wing_cv  =  *pVariant;
   }
   else if (rstrElementVar    == "ac_altitude_wing")
   {
      m_ac_altitude_wing_cv   =  *pVariant;
   }
   else if (rstrElementVar    == "Reposition Above_Below")
   {
      m_CVar_mouse_above_below   =  *pVariant;
   }
   else if (rstrElementVar    == "Reposition Fore_Aft")
   {
      m_CVar_mouse_fore_aft      =  *pVariant;
   }
   else if (rstrElementVar    == "Reposition Left_Right")
   {
      m_CVar_mouse_left_right    =  *pVariant;
   }
}


bool  CFormationFlightRepositionRearView::UpdateRenderVariables()
{
   bool  bRetVal  =  CWidget::UpdateRenderVariables();

   if (bRetVal == true)
   {
      m_ac_latitude_lead   =  m_ac_latitude_lead_cv;
      m_ac_longitude_lead  =  m_ac_longitude_lead_cv;
      m_ac_altitude_lead   =  m_ac_altitude_lead_cv;

      m_ac_latitude_wing   =  m_ac_latitude_wing_cv;
      m_ac_longitude_wing  =  m_ac_longitude_wing_cv;
      m_ac_altitude_wing   =  m_ac_altitude_wing_cv;

      m_ac_heading_lead    =  m_ac_heading_lead_cv;


      double   avg_lat     =  (m_ac_latitude_lead  +  m_ac_latitude_wing)  *  0.5;
      // The xgas term is the north-south distance from the lead aircraft to the wing aircraft, in feet.  
      double   xgas        =  (m_ac_latitude_lead  -  m_ac_latitude_wing)  *  NM_PER_DEGREE  *  NMI_FT;
      // The ygas term is the east-west distance from the lead aircraft to the wing aircraft, in feet.  
      double   ygas        =  (m_ac_longitude_lead -  m_ac_longitude_wing) *  NM_PER_DEGREE  *  cos(avg_lat *  DEG_TO_RAD) *  NMI_FT;

      double   sin_of_lead =  sin(m_ac_heading_lead   *  DEG_TO_RAD);
      double   cos_of_lead =  cos(m_ac_heading_lead   *  DEG_TO_RAD);

      // The agas term is the distance from the wing aircraft to the lead aircraft cg, in feet, measured along the axis of the lead 
      // aircraft.  Positive values indicate the wing aircraft is in front of the lead aircraft, with negative values indicating 
      // that the wing aircraft is behind the lead aircraft.
      double   agas        =  ygas  *  sin_of_lead +  xgas  *  cos_of_lead;
      // The bgas term is the distance from the wing aircraft to the lead aircraft cg, in feet, measured perpendicular to the 
      // lead aircraft's centerline.  Positive values indicate the wing aircraft is to the right of the lead aircraft, and negative 
      // values indicate the wing aircraft is to the left of the lead aircraft.
      double   bgas        =  xgas  *  sin_of_lead -  ygas  *  cos_of_lead;

      m_y_offset           =  (m_ac_altitude_wing  -  m_ac_altitude_lead);
      m_x_offset           =  bgas;

      double   max_offset  =  __max(fabs(m_x_offset), fabs(m_y_offset));

      // If new position is near the middle of the current scale, zoom in.
      if (max_offset       <  35.0f    *  4.0f)
         m_scale           =  10.0f    *  4.0f;
      else if (max_offset  <  70.0f    *  4.0f)
         m_scale           =  35.0f    *  4.0f;
      else if (max_offset  <  105.0f   *  4.0f)
         m_scale           =  70.0f    *  4.0f;
      else if (max_offset  <  0.1f     *  4.0f  *  NMI_FT)
         m_scale           =  105.0f   *  4.0f;
      else if (max_offset  <  0.5f     *  4.0f  *  NMI_FT)
         m_scale           =  0.1f     *  4.0f  *  NMI_FT;
      else if (max_offset  <  2.0f     *  4.0f  *  NMI_FT)
         m_scale           =  0.5f     *  4.0f  *  NMI_FT;
      
      // If new position is near the outer edge of the current scale, zoom out.
      if (max_offset       >= 0.5f     *  4.0f  *  NMI_FT)
         m_scale           =  2.0f     *  4.0f  *  NMI_FT;
      else if (max_offset  >= 0.1f     *  4.0f  *  NMI_FT)
         m_scale           =  0.5f     *  4.0f  *  NMI_FT;
      else if (max_offset  >= 105.0f   *  4.0f)
         m_scale           =  0.1f     *  4.0f  *  NMI_FT;
      else if (max_offset  >= 70.0f    *  4.0f)
         m_scale           =  105.0f   *  4.0f;
      else if (max_offset  >= 35.0f    *  4.0f)
         m_scale           =  70.0f    *  4.0f;
      else if (max_offset  >= 10.0f    *  4.0f)
         m_scale           =  35.0f    *  4.0f;
   }

   return   bRetVal;
}


CVariant *CFormationFlightRepositionRearView::GetValue(const CString &rstrValue)
{
   if (m_touch_reposition_requested)
   {
      static   bool  above_below_sent  =  false;
      static   bool  fore_aft_sent     =  false;
      static   bool  left_right_sent   =  false;

      if (rstrValue        == "Reposition Above_Below")
      {
         above_below_sent  =  true;
         return   &m_CVar_mouse_above_below;
      }
      else if (rstrValue   == "Reposition Fore_Aft")
      {
         fore_aft_sent     =  true;
         return   &m_CVar_mouse_fore_aft;
      }
      else if (rstrValue   == "Reposition Left_Right")
      {
         left_right_sent   =  true;
         return   &m_CVar_mouse_left_right;
      }
      else if (rstrValue   == "Reposition Select")
      {
         if (above_below_sent && fore_aft_sent  && left_right_sent)
         {
            above_below_sent              =  false;
            fore_aft_sent                 =  false;
            left_right_sent               =  false;
            m_CVar_reposition_select.Value(22L);
         }
         else
            m_CVar_reposition_select.Value(0L);

         return   &m_CVar_reposition_select;
      }
   }

   if (rstrValue == "formation_reposition_id")
   {
      m_CVar_formation_reposition_id.Value(0L);
      return   &m_CVar_formation_reposition_id;
   }

   return   NULL;
}

void  CFormationFlightRepositionRearView::OnLButtonUp(UINT nFlags, CPoint point) 
{
   if (m_bEditing == true)
   {
   }
   else
   {
      COpenGLWidget::OnLButtonUp(nFlags, point);
   }
}

void  CFormationFlightRepositionRearView::OnMouseMove(UINT nFlags, CPoint point) 
{
   m_mouse_x_position  =  point.x;
   m_mouse_y_position  =  point.y;
}
