// FormationFlightRepositionPlanView.h: interface for the CFormationFlightRepositionPlanView class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_FORMATIONFLIGHTREPOSITIONPLANVIEW_H__88832CA3_B23A_11D2_AD63_006008B0E0C3__INCLUDED_)
#define AFX_FORMATIONFLIGHTREPOSITIONPLANVIEW_H__88832CA3_B23A_11D2_AD63_006008B0E0C3__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "..\general\OpenGLWidget.h"
#include "OpenGLMap.h"
#include "..\core\OpenGLtext.h"
#include "..\core\OpenGLCircle.h"
#include "Texan_Model.h"

class CFormationFlightRepositionPlanView : 	public COpenGLWidget,   public COpenGLMap
{
public:
	CFormationFlightRepositionPlanView();
	virtual ~CFormationFlightRepositionPlanView();

   static CWidget* CreateObject();
   virtual CVariant* GetValue(const CString &rstrValue);
   virtual bool UpdateRenderVariables();

   void  Setup(void);
   void  Render(void);

   virtual void ChangeValue(const CString& rstrElementVar, CChangeValue* pCV);

private:
   COpenGLtext webLabel;
   CString     m_CStr_webLabel;

   Texan_Model leadModel;
   Texan_Model wingModel;

   COpenGLtext leadSymbol;
   CString     m_CStr_leadSymbol;
   COpenGLtext wingSymbol;
   CString     m_CStr_wingSymbol;
   COpenGLtext relativeheadingSymbol;
   CString     m_CStr_relativeheadingSymbol;

   COpenGLtext units;
   CString     m_CStr_units;

   double   m_ac_latitude_lead;
   double   m_ac_latitude_lead_cv;
   double   m_ac_longitude_lead;
   double   m_ac_longitude_lead_cv;

   double   m_ac_latitude_wing;
   double   m_ac_latitude_wing_cv;
   double   m_ac_longitude_wing;
   double   m_ac_longitude_wing_cv;

   float    m_ac_heading_lead;
   float    m_ac_heading_lead_cv;

   float    m_ac_heading_wing;
   float    m_ac_heading_wing_cv;

   float    m_delta_heading;

   double   m_x_offset;
   double   m_y_offset;
   double   m_scale;

   COpenGLCircle  m_circle;

   int         m_mouse_x_position;
   int         m_mouse_y_position;
   CVariant    m_CVar_mouse_above_below;
   CVariant    m_CVar_mouse_fore_aft;
   CVariant    m_CVar_mouse_left_right;
   CVariant    m_CVar_reposition_select;
   bool        m_touch_reposition_requested;

   CVariant    m_CVar_formation_reposition_id;

   COpenGLtext mouseXposition;
   CString     m_CStr_mouseXposition;
   COpenGLtext mouseYposition;
   CString     m_CStr_mouseYposition;

// Attributes
public:
  	enum { IDB = IDB_FF_REPO_PLAN_VIEW};

protected:
	//{{AFX_MSG(CFormationFlightRepositionPlanView)
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#endif // !defined(AFX_FORMATIONFLIGHTREPOSITIONPLANVIEW_H__88832CA3_B23A_11D2_AD63_006008B0E0C3__INCLUDED_)
