// FormationFlightRepositionPlanView.cpp: implementation of the CFormationFlightRepositionPlanView class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "FormationFlightRepositionPlanView.h"
#include "..\core\DataConversion.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

const int   SPIDER_WEB_NUMBER_OF_RINGS    =  4;
const int   SPIDER_WEB_NUMBER_OF_RADIALS  =  12;

const float ORIGINAL_SCALE                =  140.0f;
const float SPIDER_WEB_SPACING_OF_RINGS   =  0.25f;
const float SPIDER_WEB_INNER_RADIUS       =  SPIDER_WEB_SPACING_OF_RINGS   /  2.0f;


BEGIN_MESSAGE_MAP(CFormationFlightRepositionPlanView, COpenGLWidget)
   //{{AFX_MSG_MAP(CFormationFlightRepositionPlanView)
   ON_WM_LBUTTONUP()
   ON_WM_MOUSEMOVE()
   //}}AFX_MSG_MAP
END_MESSAGE_MAP()

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CFormationFlightRepositionPlanView::CFormationFlightRepositionPlanView()
{
   m_exPtUpperLeft      =  CExtentsPoint(CPoint(0,0));
   m_exPtLowerRight     =  CExtentsPoint(CPoint(320,320));

   m_stlStrWidgetName   =  _FSI_STL::string("Formation_Flight_Reposition_Plan_View");

   m_listGraphicalElementVars.clear();

   m_listGraphicalElementVars.push_back("ac_latitude_lead");
   m_listGraphicalElementVars.push_back("ac_longitude_lead");
   m_listGraphicalElementVars.push_back("ac_heading_lead");

   m_listGraphicalElementVars.push_back("ac_latitude_wing");
   m_listGraphicalElementVars.push_back("ac_longitude_wing");
   m_listGraphicalElementVars.push_back("ac_heading_wing");

   m_listGraphicalElementVars.push_back("Reposition Above_Below");
   m_listGraphicalElementVars.push_back("Reposition Fore_Aft");
   m_listGraphicalElementVars.push_back("Reposition Left_Right");
   m_listGraphicalElementVars.push_back("Reposition Select");

   m_listGraphicalElementVars.push_back("formation_reposition_id");

   m_scale     =  ORIGINAL_SCALE;

   m_touch_reposition_requested  =  true;

   m_mouse_x_position   =  0;
   m_mouse_y_position   =  0;
   m_CVar_mouse_above_below.Value(0.0f);
   m_CVar_mouse_fore_aft.Value(0.0f);
   m_CVar_mouse_left_right.Value(0.0f);
}

CFormationFlightRepositionPlanView::~CFormationFlightRepositionPlanView()
{
}

void  CFormationFlightRepositionPlanView::Setup(void)
{
   COpenGLMap::Initialize(GetSafeHwnd());

   webLabel.SetForegroundColor(96, 192, 96);
   webLabel.SetBackgroundColor(true, 0, 0, 0);

   units.SetForegroundColor(96, 192, 96);

   leadSymbol.SetForegroundColor(0, 255, 255);
   m_CStr_leadSymbol =  "L";
   wingSymbol.SetForegroundColor(255, 0, 255);
   m_CStr_wingSymbol =  "W";
   relativeheadingSymbol.SetForegroundColor(128, 128, 128);
   m_CStr_relativeheadingSymbol.Format("%c", TORQUE_NEEDLE);

   leadModel.Initialize(NOT_ANY);
   leadModel.SetGearPosition(NOSE_GEAR,    0.0f);
   leadModel.SetGearPosition(LEFT_GEAR,    0.0f);
   leadModel.SetGearPosition(RIGHT_GEAR,   0.0f);

   wingModel.Initialize(NOT_ANY);
   wingModel.SetGearPosition(NOSE_GEAR,    0.0f);
   wingModel.SetGearPosition(LEFT_GEAR,    0.0f);
   wingModel.SetGearPosition(RIGHT_GEAR,   0.0f);

   m_circle.ArraySize(60);

   if (m_list != -1)
   {
       glDeleteLists(m_list, 1);
   }

   m_list = glGenLists(1);
   glNewList(m_list, GL_COMPILE);
   {
      glPushMatrix();
      {
         GLUquadricObj  *pquad   =  gluNewQuadric();
            gluQuadricDrawStyle(pquad, GLU_LINE);
            glRGB(64, 64, 64);
            gluDisk(pquad, 0.0f, 1.5f, SPIDER_WEB_NUMBER_OF_RADIALS, 1);
         gluDeleteQuadric(pquad);
      }
      glPopMatrix();
   }
   glEndList();
}

void  CFormationFlightRepositionPlanView::Render(void)
{
   BeginDraw();

   // Draw the standard stuff.
   COpenGLMap::Draw();

   glPushMatrix();
   {
      glCallList(m_list);

      float scale_factor   =  ORIGINAL_SCALE /  m_scale;

      // Draw a circle around the lead aircraft.
      glRGB(64, 64, 64);
      glPushMatrix();
         glScalef(scale_factor   *  SPIDER_WEB_INNER_RADIUS,  scale_factor   *  SPIDER_WEB_INNER_RADIUS,  1.0f);
         m_circle.Draw();
      glPopMatrix();

      // Draw and label the spider web rings.
      float radius   =  (SPIDER_WEB_SPACING_OF_RINGS  /  scale_factor)  +  SPIDER_WEB_INNER_RADIUS;
      for (int ii =  0; ii <  SPIDER_WEB_NUMBER_OF_RINGS;   ii++, radius   += SPIDER_WEB_SPACING_OF_RINGS   /  scale_factor)
      {
         glRGB(64, 64, 64);
         glPushMatrix();
            glScalef(radius   *  scale_factor,  radius   *  scale_factor,  1.0f);
            m_circle.Draw();
         glPopMatrix();

         if (m_scale >  420.0f   *  4.0f)
            m_CStr_webLabel.Format("%2.1f",  (35.0f   /  scale_factor)  *  (ii   +  1) /  NMI_FT);
         else
            m_CStr_webLabel.Format("%2.0f",  (35.0f   /  scale_factor)  *  (ii   +  1));

         glPushMatrix();
            glRotatef(  0.0f, 0.0f, 0.0f, 1.0f);
            glTranslatef(radius  *  scale_factor,   0.0f, 0.0f);
            webLabel.Draw(m_CStr_webLabel, true, - 0.0f, 0.85f);
         glPopMatrix();
         glPushMatrix();
            glRotatef( 90.0f, 0.0f, 0.0f, 1.0f);
            glTranslatef(radius  *  scale_factor,   0.0f, 0.0f);
            webLabel.Draw(m_CStr_webLabel, true, - 90.0f, 0.85f);
         glPopMatrix();
         glPushMatrix();
            glRotatef(180.0f, 0.0f, 0.0f, 1.0f);
            glTranslatef(radius  *  scale_factor,   0.0f, 0.0f);
            webLabel.Draw(m_CStr_webLabel, true, -180.0f, 0.85f);
         glPopMatrix();
         glPushMatrix();
            glRotatef(270.0f, 0.0f, 0.0f, 1.0f);
            glTranslatef(radius  *  scale_factor,   0.0f, 0.0f);
            webLabel.Draw(m_CStr_webLabel, true, -270.0f, 0.85f);
         glPopMatrix();
      }
/*
      // Label the spider web radials.
      for (int jj =  0; jj <  SPIDER_WEB_NUMBER_OF_RADIALS; jj += 2)
      {
         float angle =  (360.0f  /  SPIDER_WEB_NUMBER_OF_RADIALS) *  jj;
         m_CStr_webLabel.Format("%.0f%c", angle, DEGREES);
         glPushMatrix();
            glRotatef(90.0f   -  angle,  0.0f, 0.0f, 1.0f);
            glTranslatef(radius  *  scale_factor   -  0.5, 0.0f, 0.0f);
            webLabel.Draw(m_CStr_webLabel, true, (jj >  SPIDER_WEB_NUMBER_OF_RADIALS  /  2) ?  180.0f   :  0.0f, 0.95f);
         glPopMatrix();
      }
*/
      glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);

      if (m_scale >  420.0f)
      {
         leadSymbol.Draw(m_CStr_leadSymbol, true, 0.0f, 1.5f, 2.0f);    // Centered at 0, 0, 0.

         glPushMatrix();
            glTranslatef(m_x_offset /  m_scale, m_y_offset  /  m_scale, 0.0f);
            relativeheadingSymbol.Draw(m_CStr_relativeheadingSymbol, true, m_delta_heading, 8.0f, 2.0f);
            wingSymbol.Draw(m_CStr_wingSymbol, true, 0.0f, 1.5f, 2.0f);
         glPopMatrix();
      }
      else
      {
         glEnable(GL_DEPTH_TEST);
         glClear(GL_DEPTH_BUFFER_BIT);
         glEnable(GL_CULL_FACE);
         {
            glPushMatrix();
               glScalef(scale_factor,  scale_factor,  scale_factor);
               glTranslatef(0.0f, 0.0f, 0.1f);
               glRotatef(90.0f,  1.0f, 0.0f, 0.0f);
               glRotatef(180.0f,  0.0f, 1.0f, 0.0f);
               glScalef(1.0f  /  3000.0f,  1.0f  /  3000.0f,  1.0f  /  3000.0f);
               leadModel.Render();
            glPopMatrix();

            glPushMatrix();
               glTranslatef(m_x_offset /  m_scale, m_y_offset  /  m_scale, 0.0f);
               glScalef(scale_factor,  scale_factor,  scale_factor);
               glTranslatef(0.0f, 0.0f, 0.1f);
               glRotatef(90.0f,  1.0f, 0.0f, 0.0f);
               glRotatef(180.0f,  0.0f, 1.0f, 0.0f);
               glScalef(1.0f  /  3000.0f,  1.0f  /  3000.0f,  1.0f  /  3000.0f);
               glRotatef(m_delta_heading, 0.0f, 1.0f, 0.0f);
               wingModel.Render();
            glPopMatrix();

         }
         glDisable(GL_CULL_FACE);
         glDisable(GL_DEPTH_TEST);
      }

      glPushMatrix();
         glTranslatef(0.9f, -0.925f, 0.0f);
         units.Draw(m_CStr_units,   true, 0.0f, 1.5f);
      glPopMatrix();


      static   int   lpv_x_position =  0;
      static   int   lpv_y_position =  0;

      if (lpv_y_position   != m_mouse_y_position)
      {
         lpv_y_position          =  m_mouse_y_position;
         double   height_in_feet =  2.0f  *  m_scale;
         float    y_offset       =  -(height_in_feet  /  (m_height   -  1) *  m_mouse_y_position   -  height_in_feet /  2.0f);
         m_CVar_mouse_fore_aft.Value(y_offset);
      }

      if (lpv_x_position   != m_mouse_x_position)
      {
         lpv_x_position          =  m_mouse_x_position;
         double   width_in_feet  =  2.0f  *  m_scale;
         float    x_offset       =  width_in_feet  /  (m_width -  1) *  m_mouse_x_position   -  width_in_feet  /  2.0f;
         m_CVar_mouse_left_right.Value(x_offset);
      }
/*
      glPushMatrix();
         glTranslatef(-0.5f, 0.925f, 0.0f);
         m_CStr_mouseXposition.Format("X %d %2.2f", m_mouse_x_position, (float)m_CVar_mouse_left_right);
         mouseXposition.Draw(m_CStr_mouseXposition,   true, 0.0f, 1.0f);
      glPopMatrix();
      glPushMatrix();
         glTranslatef( 0.5f, 0.925f, 0.0f);
         m_CStr_mouseYposition.Format("Y %d %2.2f", m_mouse_y_position, (float)m_CVar_mouse_fore_aft);
         mouseYposition.Draw(m_CStr_mouseYposition,   true, 0.0f, 1.0f);
      glPopMatrix();
*/
   }
   glPopMatrix();

   EndDraw();
}


CWidget* CFormationFlightRepositionPlanView::CreateObject()
{
   return new CFormationFlightRepositionPlanView();
}

void  CFormationFlightRepositionPlanView::ChangeValue(const CString& rstrElementVar, CChangeValue* pCV)
{
   if (pCV == NULL)
   {
       return;
   }
   CVariant* pVariant = pCV->Variant();


   if (rstrElementVar         == "ac_latitude_lead")
   {
      m_ac_latitude_lead_cv   =  *pVariant;
   }
   else if (rstrElementVar    == "ac_longitude_lead")
   {
      m_ac_longitude_lead_cv  =  *pVariant;
   }
   else if (rstrElementVar    == "ac_heading_lead")
   {
      m_ac_heading_lead_cv    =  *pVariant;
   }
   else if (rstrElementVar    == "ac_latitude_wing")
   {
      m_ac_latitude_wing_cv   =  *pVariant;
   }
   else if (rstrElementVar    == "ac_longitude_wing")
   {
      m_ac_longitude_wing_cv  =  *pVariant;
   }
   else if (rstrElementVar    == "ac_heading_wing")
   {
      m_ac_heading_wing_cv    =  *pVariant;
   }
   else if (rstrElementVar    == "Reposition Above_Below")
   {
      m_CVar_mouse_above_below   =  *pVariant;
   }
   else if (rstrElementVar    == "Reposition Fore_Aft")
   {
      m_CVar_mouse_fore_aft      =  *pVariant;
   }
   else if (rstrElementVar    == "Reposition Left_Right")
   {
      m_CVar_mouse_left_right    =  *pVariant;
   }
}


bool  CFormationFlightRepositionPlanView::UpdateRenderVariables()
{
   bool  bRetVal  =  CWidget::UpdateRenderVariables();

   if (bRetVal == true)
   {
      m_ac_latitude_lead   =  m_ac_latitude_lead_cv;
      m_ac_longitude_lead  =  m_ac_longitude_lead_cv;

      m_ac_latitude_wing   =  m_ac_latitude_wing_cv;
      m_ac_longitude_wing  =  m_ac_longitude_wing_cv;

      m_ac_heading_lead    =  m_ac_heading_lead_cv;
      m_ac_heading_wing    =  m_ac_heading_wing_cv;

      m_delta_heading      =  m_ac_heading_lead -  m_ac_heading_wing;


      double   avg_lat     =  (m_ac_latitude_lead  +  m_ac_latitude_wing)  *  0.5;
      // The xgas term is the north-south distance from the lead aircraft to the wing aircraft, in feet.  
      double   xgas        =  (m_ac_latitude_lead  -  m_ac_latitude_wing)  *  NM_PER_DEGREE  *  NMI_FT;
      // The ygas term is the east-west distance from the lead aircraft to the wing aircraft, in feet.  
      double   ygas        =  (m_ac_longitude_lead -  m_ac_longitude_wing) *  NM_PER_DEGREE  *  cos(avg_lat *  DEG_TO_RAD) *  NMI_FT;

      double   sin_of_lead =  sin(m_ac_heading_lead   *  DEG_TO_RAD);
      double   cos_of_lead =  cos(m_ac_heading_lead   *  DEG_TO_RAD);

      // The agas term is the distance from the wing aircraft to the lead aircraft cg, in feet, measured along the axis of the lead 
      // aircraft.  Positive values indicate the lead aircraft is in front of the wing aircraft, with negative values indicating 
      // that the wing aircraft is behind the lead aircraft.
      double   agas        =  ygas  *  sin_of_lead +  xgas  *  cos_of_lead;
      // The bgas term is the distance from the wing aircraft to the lead aircraft cg, in feet, measured perpendicular to the 
      // lead aircraft's centerline.  Positive values indicate the wing aircraft is to the right of the lead aircraft, and negative 
      // values indicate the wing aircraft is to the left of the lead aircraft.
      double   bgas        =  xgas  *  sin_of_lead -  ygas  *  cos_of_lead;

      m_y_offset  =  -agas;   // We want positive values to indicate lead is behind the wing aircraft for plotting purposes.
      m_x_offset  =  bgas;

      double   max_offset  =  sqrt((m_x_offset  *  m_x_offset) +  (m_y_offset *  m_y_offset));

      // If new position is near the middle of the current scale, zoom in.
      if (max_offset       <  35.0f    *  4.0f)
         m_scale           =  10.0f    *  4.0f;
      else if (max_offset  <  70.0f    *  4.0f)
         m_scale           =  35.0f    *  4.0f;
      else if (max_offset  <  105.0f   *  4.0f)
         m_scale           =  70.0f    *  4.0f;
      else if (max_offset  <  0.1f     *  4.0f  *  NMI_FT)
         m_scale           =  105.0f   *  4.0f;
      else if (max_offset  <  0.5f     *  4.0f  *  NMI_FT)
         m_scale           =  0.1f     *  4.0f  *  NMI_FT;
      else if (max_offset  <  2.0f     *  4.0f  *  NMI_FT)
         m_scale           =  0.5f     *  4.0f  *  NMI_FT;
      
      // If new position is near the outer edge of the current scale, zoom out.
      if (max_offset       >= 0.5f     *  4.0f  *  NMI_FT)
         m_scale           =  2.0f     *  4.0f  *  NMI_FT;
      else if (max_offset  >= 0.1f     *  4.0f  *  NMI_FT)
         m_scale           =  0.5f     *  4.0f  *  NMI_FT;
      else if (max_offset  >= 105.0f   *  4.0f)
         m_scale           =  0.1f     *  4.0f  *  NMI_FT;
      else if (max_offset  >= 70.0f    *  4.0f)
         m_scale           =  105.0f   *  4.0f;
      else if (max_offset  >= 35.0f    *  4.0f)
         m_scale           =  70.0f    *  4.0f;
      else if (max_offset  >= 10.0f    *  4.0f)
         m_scale           =  35.0f    *  4.0f;

      if (m_scale >= 420.0f   *  4.0f)
         m_CStr_units   =  "NM";
      else
         m_CStr_units   =  "FT";
   }

   return   bRetVal;
}


CVariant *CFormationFlightRepositionPlanView::GetValue(const CString &rstrValue)
{
   if (m_touch_reposition_requested)
   {
      static   bool  above_below_sent  =  false;
      static   bool  fore_aft_sent     =  false;
      static   bool  left_right_sent   =  false;

      if (rstrValue        == "Reposition Above_Below")
      {
         above_below_sent  =  true;
         return   &m_CVar_mouse_above_below;
      }
      else if (rstrValue   == "Reposition Fore_Aft")
      {
         fore_aft_sent     =  true;
         return   &m_CVar_mouse_fore_aft;
      }
      else if (rstrValue   == "Reposition Left_Right")
      {
         left_right_sent   =  true;
         return   &m_CVar_mouse_left_right;
      }
      else if (rstrValue   == "Reposition Select")
      {
         if (above_below_sent && fore_aft_sent  && left_right_sent)
         {
            above_below_sent              =  false;
            fore_aft_sent                 =  false;
            left_right_sent               =  false;
            m_CVar_reposition_select.Value(22L);
         }
         else
            m_CVar_reposition_select.Value(0L);

         return   &m_CVar_reposition_select;
      }
   }

   if (rstrValue == "formation_reposition_id")
   {
      m_CVar_formation_reposition_id.Value(0L);
      return   &m_CVar_formation_reposition_id;
   }

   return   NULL;
}

void CFormationFlightRepositionPlanView::OnLButtonUp(UINT nFlags, CPoint point) 
{
   if (m_bEditing == true)
   {
   }
   else
   {
      COpenGLWidget::OnLButtonUp(nFlags, point);
   }
}

void CFormationFlightRepositionPlanView::OnMouseMove(UINT nFlags, CPoint point) 
{
   m_mouse_x_position  =  point.x;
   m_mouse_y_position  =  point.y;
}
