// AreaMapLegend.cpp: implementation of the CAreaMapLegend class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "AreaMapLegend.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CAreaMapLegend::CAreaMapLegend()
{
   m_exPtUpperLeft      =  CExtentsPoint(CPoint(0,0));
   m_exPtLowerRight     =  CExtentsPoint(CPoint(192,192));

   m_stlStrWidgetName   =  _FSI_STL::string("Area_Map_Legend");
}

CAreaMapLegend::~CAreaMapLegend()
{
}

void  CAreaMapLegend::Setup(void)
{
   COpenGLMap::Initialize(GetSafeHwnd());

   m_tacanLegend.Format("TACAN");
   m_dmeLegend.Format("DME");
   m_ilsLegend.Format("ILS");
   m_vorLegend.Format("VOR");
   m_vordmeLegend.Format("VORDME");
   m_vortacLegend.Format("VORTAC");
   m_wptLegend.Format("WPT");
   m_airportLegend.Format("AIRPORT");
   m_ndbLegend.Format("NDB");
   m_omLegend.Format("OM");
   m_imLegend.Format("IM");
   m_mmLegend.Format("MM");

   tacanLegend.SetForegroundColor   (192, 192,  192);
   dmeLegend.SetForegroundColor     (192, 192,  192);
   ilsLegend.SetForegroundColor     (192, 192,  192);
   vorLegend.SetForegroundColor     (192, 192,  192);
   vordmeLegend.SetForegroundColor  (192, 192,  192);
   vortacLegend.SetForegroundColor  (192, 192,  192);
   wptLegend.SetForegroundColor     (192, 192,  192);
   airportLegend.SetForegroundColor (192, 192,  192);
   ndbLegend.SetForegroundColor     (192, 192,  192);
   omLegend.SetForegroundColor      (192, 192,  192);
   imLegend.SetForegroundColor      (192, 192,  192);
   mmLegend.SetForegroundColor      (192, 192,  192);


   m_tacan.Format("%c", TACAN);
   m_dme.Format("%c", DME);
   m_ils.Format("%c", ILS_FAN);
   m_vor.Format("%c", VOR);
   m_vordme.Format("%c", VORDME);
   m_vortac.Format("%c", VORTAC);
   m_wpt.Format("%c", WPT);
   m_airport.Format("%c", AIRPORT);
   m_ndb.Format("%c", NDB);
   m_om.Format("%c", OUTER_MARKER);
   m_im.Format("%c", INNER_MARKER);
   m_mm.Format("%c", MIDDLE_MARKER);

   tacan.SetForegroundColor   (0,   192,  0);   // Green
   dme.SetForegroundColor     (255, 255,  0);
   ils.SetForegroundColor     (0,   128,  0);   // Green
   vor.SetForegroundColor     (192, 192,  0);
   vordme.SetForegroundColor  (192, 192,  0);
   vortac.SetForegroundColor  (192, 192,  0);
   wpt.SetForegroundColor     (0,   255,  255);
   airport.SetForegroundColor (0,   192,  192);
   ndb.SetForegroundColor     (255, 255,  0);

   if (m_list != -1)
   {
       glDeleteLists(m_list, 1);
   }

   m_list = glGenLists(1);
   glNewList(m_list, GL_COMPILE);
   {
      glPushMatrix();
      {
         glPushMatrix();
         {
            glPushMatrix();
               glTranslatef(-0.66f, 0.60f, 0.0f);
               tacanLegend.Draw(m_tacanLegend,     true, 0.0f,    1.5f *  m_aspect_ratio, 1.0f);
            glPopMatrix();
            glPushMatrix();
               glTranslatef( 0.00f, 0.60f, 0.0f);
               dmeLegend.Draw(m_dmeLegend,         true, 0.0f,    1.5f *  m_aspect_ratio, 1.0f);
            glPopMatrix();
            glPushMatrix();
               glTranslatef( 0.66f, 0.60f, 0.0f);
               ilsLegend.Draw(m_ilsLegend,         true, 0.0f,    1.5f *  m_aspect_ratio, 1.0f);
            glPopMatrix();

            glPushMatrix();
               glTranslatef(-0.66f, 0.15f, 0.0f);
               vorLegend.Draw(m_vorLegend,         true, 0.0f,    1.5f *  m_aspect_ratio, 1.0f);
            glPopMatrix();
            glPushMatrix();
               glTranslatef( 0.00f, 0.15f, 0.0f);
               vordmeLegend.Draw(m_vordmeLegend,   true, 0.0f,    1.5f *  m_aspect_ratio, 1.0f);
            glPopMatrix();
            glPushMatrix();
               glTranslatef( 0.66f, 0.15f, 0.0f);
               vortacLegend.Draw(m_vortacLegend,   true, 0.0f,    1.5f *  m_aspect_ratio, 1.0f);
            glPopMatrix();

            glPushMatrix();
               glTranslatef(-0.66f, -0.30f, 0.0f);
               wptLegend.Draw(m_wptLegend,         true, 0.0f,    1.5f *  m_aspect_ratio, 1.0f);
            glPopMatrix();
            glPushMatrix();
               glTranslatef( 0.00f, -0.30f, 0.0f);
               airportLegend.Draw(m_airportLegend, true, 0.0f,    1.5f *  m_aspect_ratio, 1.0f);
            glPopMatrix();
            glPushMatrix();
               glTranslatef( 0.66f, -0.30f, 0.0f);
               ndbLegend.Draw(m_ndbLegend,         true, 0.0f,    1.5f *  m_aspect_ratio, 1.0f);
            glPopMatrix();

            glPushMatrix();
               glTranslatef(-0.66f, -0.75f, 0.0f);
               omLegend.Draw(m_omLegend,           true, 0.0f,    1.5f *  m_aspect_ratio, 1.0f);
            glPopMatrix();
            glPushMatrix();
               glTranslatef( 0.00f, -0.75f, 0.0f);
               imLegend.Draw(m_imLegend,           true, 0.0f,    1.5f *  m_aspect_ratio, 1.0f);
            glPopMatrix();
            glPushMatrix();
               glTranslatef( 0.66f, -0.75f, 0.0f);
               mmLegend.Draw(m_mmLegend,           true, 0.0f,    1.5f *  m_aspect_ratio, 1.0f);
            glPopMatrix();


            glPushMatrix();
               glTranslatef(-0.66f, 0.80f, 0.0f);
               tacan.Draw(m_tacan,                 true, 0.0f,    3.5f *  m_aspect_ratio, 1.0f);
            glPopMatrix();
            glPushMatrix();
               glTranslatef( 0.00f, 0.80f, 0.0f);
               dme.Draw(m_dme,                     true, 0.0f,    3.5f *  m_aspect_ratio, 1.0f);
            glPopMatrix();
            glPushMatrix();
               glTranslatef( 0.46f, 0.80f, 0.0f);
               ils.Draw(m_ils,                     true, 0.0f,    4.5f *  m_aspect_ratio, 1.0f);
            glPopMatrix();

            glPushMatrix();
               glTranslatef(-0.66f, 0.35f, 0.0f);
               vor.Draw(m_vor,                     true, 0.0f,    3.5f *  m_aspect_ratio, 1.0f);
            glPopMatrix();
            glPushMatrix();
               glTranslatef( 0.00f, 0.35f, 0.0f);
               vordme.Draw(m_vordme,               true, 0.0f,    3.5f *  m_aspect_ratio, 1.0f);
            glPopMatrix();
            glPushMatrix();
               glTranslatef( 0.66f, 0.35f, 0.0f);
               vortac.Draw(m_vortac,               true, 0.0f,    3.5f *  m_aspect_ratio, 1.0f);
            glPopMatrix();

            glPushMatrix();
               glTranslatef(-0.66f, -0.10f, 0.0f);
               wpt.Draw(m_wpt,                     true, 0.0f,    3.5f *  m_aspect_ratio, 1.0f);
            glPopMatrix();
            glPushMatrix();
               glTranslatef( 0.00f, -0.10f, 0.0f);
               airport.Draw(m_airport,             true, 0.0f,    3.5f *  m_aspect_ratio, 1.0f);
            glPopMatrix();
            glPushMatrix();
               glTranslatef( 0.66f, -0.10f, 0.0f);
               ndb.Draw(m_ndb,                     true, 0.0f,    3.5f *  m_aspect_ratio, 1.0f);
            glPopMatrix();

            glPushMatrix();
               glTranslatef(-0.66f, -0.55f, 0.0f);
               glRotatef(90.0f, 0.0f, 0.0f, 1.0f);
               om.Draw(m_om,                       true, 0.0f,    3.5f *  m_aspect_ratio, 1.0f);
            glPopMatrix();
            glPushMatrix();
               glTranslatef( 0.00f, -0.55f, 0.0f);
               glRotatef(90.0f, 0.0f, 0.0f, 1.0f);
               im.Draw(m_im,                       true, 0.0f,    3.5f *  m_aspect_ratio, 1.0f);
            glPopMatrix();
            glPushMatrix();
               glTranslatef( 0.66f, -0.55f, 0.0f);
               glRotatef(90.0f, 0.0f, 0.0f, 1.0f);
               mm.Draw(m_mm,                       true, 0.0f,    3.5f *  m_aspect_ratio, 1.0f);
            glPopMatrix();
         }
         glPopMatrix();
      }
      glPopMatrix();
   }
   glEndList();
}

void  CAreaMapLegend::Render(void)
{
   BeginDraw();

   glPushMatrix();
   {
       glCallList(m_list);
   }
   glPopMatrix();

   EndDraw();
}


CWidget* CAreaMapLegend::CreateObject()
{
   return new CAreaMapLegend();
}

void CAreaMapLegend::ChangeValue(const CString& rstrElementVar, CChangeValue* pCV)
{
   if (pCV == NULL)
   {
       return;
   }
   CVariant* pVariant = pCV->Variant();

}
