// AreaMap.h: interface for the CAreaMap class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_AREAMAP_H__1D2FF182_AFB5_11D2_AD62_006008B0E0C3__INCLUDED_)
#define AFX_AREAMAP_H__1D2FF182_AFB5_11D2_AD62_006008B0E0C3__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "..\general\OpenGLWidget.h"
#include "OpenGLMap.h"
#include "..\core\OpenGLtext.h"
#include "AircraftTrack.h"
#include "..\core\OpenGLCircle.h"
#include "NavaidShared.h"

// Global to the RadioDatabase DLL helper functions...
bool  GetAirportLatLon(CString &id, double &latitude, double &longitude);
bool  GetNavaidLatLon(CString &id, double &latitude, double &longitude, float &magvar);

enum  
{
   SPIDER_WEB_OFF =  0,
   SPIDER_WEB_AIRCRAFT,
   SPIDER_WEB_CURSOR,
   SPIDER_WEB_AIRPORT,
   SPIDER_WEB_ACTIVE_AIRPORT,
   SPIDER_WEB_NAVAID
};

class CAreaMap : 	public COpenGLWidget,   public COpenGLMap,   public CNavaidShared
{
public:
	CAreaMap();
	virtual ~CAreaMap();
   static CWidget* CreateObject();

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAreaMap)
	//}}AFX_VIRTUAL

   void  Setup(void);
   void  Render(void);
   void  DrawLatitudeLongitudeGrid(void);
   void  DrawMousePosition(void);
   void  CreateNewSpiderWeb(void);
   void  DrawSpiderWeb(void);
   void  AdjustMapCenterOrScale(void);
   void  CenterSpiderWebOnAirport(CString &id);
   void  CenterSpiderWebOnNavaid(CString &id);
   void  DrawWeatherAreas(void);
   void  LookupCustomData(void);
   void  InitAreaMapCenterAirport(void);
   virtual void  InitSpiderWebCenterAirport(void);
   void  LoadTacanChannelData(void);

   virtual void ChangeValue(const CString& rstrElementVar, CChangeValue* pCV);
   virtual CVariant* GetValue(const CString &rstrValue);
   virtual bool UpdateRenderVariables();

   virtual void BeginDrawing(void);
   virtual void DrawSymbols(void);
   virtual void DrawLeadAircraft(void);
   virtual void DrawWingAircraft(void);
   virtual void DrawStorm();
   virtual void DrawLeadTrack(void);
   virtual void DrawWingTrack(void);
   virtual void SetupPerspective(void);
   virtual void MoveViewingPosition(void);
   virtual void DrawEarth(void);
   virtual void EndDrawing(void);

   double      m_projMatrix[16];
   int         m_viewport[4];

   CString     m_active_airport_id;
   CString     m_active_airport_id_cv;

   CString     m_active_runway_id;
   CString     m_active_runway_id_cv;

   COpenGLtext aircraftLead;
   CString     m_aircraft_lead;

   COpenGLtext aircraftWing;
   CString     m_aircraft_wing;

   double      spider_web_airport_center_latitude;
   double      spider_web_airport_center_longitude;
   double      spider_web_navaid_center_latitude;
   double      spider_web_navaid_center_longitude;


   COpenGLtext mouse_position;
   CString     m_cursor_position;
   
   CVariant    m_mouse_latitude;
   CVariant    m_mouse_longitude;

   bool        m_touch_reposition_requested;
   bool        m_touch_storm_location_requested;
   bool        m_spider_web_at_cursor_requested;
   bool        m_map_center_at_cursor_requested;
   bool        m_map_center_at_aircraft_requested;

   bool        m_active_airport_defaulted;

   COpenGLtext latitudeLabel;
   COpenGLtext longitudeLabel;
   CString     m_latitude;
   CString     m_longitude;

   COpenGLtext webLabel;
   CString     m_webLabel;
   CString     m_webChevron;

   COpenGLtext symbol;
   CString     m_symbol;

   float    m_scale;
   float    m_scale_cv;
   double   m_area_map_latitude_center;
   double   m_area_map_latitude_center_cv;
   double   m_area_map_longitude_center;
   double   m_area_map_longitude_center_cv;
   float    m_spider_web_scale;

   CString  m_airport_id;

   bool     m_area_map_auto_center;
   bool     m_area_map_auto_center_cv;
   bool     m_area_map_auto_scale;
   bool     m_area_map_auto_scale_cv;

   bool     m_area_map_center_on_airport;


   double   m_spider_web_latitude_center;
   double   m_spider_web_latitude_center_cv;
   double   m_spider_web_longitude_center;
   double   m_spider_web_longitude_center_cv;
   float    m_spider_web_magvar;
   float    m_spider_web_magvar_cv;

   CVariant m_CVar_magvar_latitude;
   CVariant m_CVar_magvar_longitude;
   double   m_double_magvar_latitude;
   double   m_double_magvar_longitude;
   bool     m_bool_new_magvar_needed;

   double   m_lead_ac_latitude;
   double   m_lead_ac_latitude_cv;
   double   m_lead_ac_longitude;
   double   m_lead_ac_longitude_cv;
   float    m_ac_heading_lead;
   float    m_ac_heading_lead_cv;
   float    m_lead_ac_altitude;
   float    m_lead_ac_altitude_cv;

   double   m_ac_latitude;
   double   m_ac_latitude_cv;
   double   m_ac_longitude;
   double   m_ac_longitude_cv;
   float    m_ac_heading_wing;
   float    m_ac_heading_wing_cv;
   float    m_ac_altitude;
   float    m_ac_altitude_cv;

   bool     m_storm_active;
   bool     m_storm_active_cv;
   double   m_storm_latitude;
   float    m_storm_latitude_cv;
   double   m_storm_longitude;
   float    m_storm_longitude_cv;
   double   m_storm_length;
   float    m_storm_length_cv;
   double   m_storm_width;
   float    m_storm_width_cv;
   double   m_storm_heading;
   float    m_storm_heading_cv;
   CString  m_storm_name;
   CString  m_storm_name_cv;

   bool     m_sym_disp_ils_on;
   bool     m_sym_disp_ils_on_cv;
   bool     m_sym_disp_vor_on;
   bool     m_sym_disp_vor_on_cv;
   bool     m_sym_disp_markers_on;
   bool     m_sym_disp_markers_on_cv;
   bool     m_sym_disp_ndb_on;
   bool     m_sym_disp_ndb_on_cv;
   bool     m_sym_disp_victor_routes_on;
   bool     m_sym_disp_victor_routes_on_cv;
   bool     m_sym_disp_jet_routes_on;
   bool     m_sym_disp_jet_routes_on_cv;
   bool     m_sym_disp_waypoints_on;
   bool     m_sym_disp_waypoints_on_cv;
   bool     m_sym_disp_airports_on;
   bool     m_sym_disp_airports_on_cv;

   bool     m_sym_disp_ils_text_on;
   bool     m_sym_disp_ils_text_on_cv;
   bool     m_sym_disp_vor_text_on;
   bool     m_sym_disp_vor_text_on_cv;
   bool     m_sym_disp_ndb_text_on;
   bool     m_sym_disp_ndb_text_on_cv;
   bool     m_sym_disp_airport_text_on;
   bool     m_sym_disp_airport_text_on_cv;
   bool     m_sym_disp_waypoints_text_on;
   bool     m_sym_disp_waypoints_text_on_cv;

   bool     m_sym_disp_lead_ac_track_on;
   bool     m_sym_disp_lead_ac_track_on_cv;
   bool     m_sym_disp_wing_ac_track_on;
   bool     m_sym_disp_wing_ac_track_on_cv;
   bool     m_sym_disp_lat_long_grid_on;
   bool     m_sym_disp_lat_long_grid_on_cv;
   bool     m_sym_disp_mouse_lat_long_on;
   bool     m_sym_disp_mouse_lat_long_on_cv;
   bool     m_sym_disp_mouse_lat_long_decimal_degree;
   bool     m_sym_disp_mouse_lat_long_decimal_degree_cv;
   bool     m_sym_disp_weather_areas_on;
   bool     m_sym_disp_weather_areas_on_cv;
   bool     m_sym_disp_custom_obstacles_on;
   bool     m_sym_disp_custom_obstacles_on_cv;
   bool     m_sym_disp_custom_obstacles_text_on;
   bool     m_sym_disp_custom_obstacles_text_on_cv;
   bool     m_sym_disp_custom_practice_areas_on;
   bool     m_sym_disp_custom_practice_areas_on_cv;
   bool     m_sym_disp_custom_practice_areas_text_on;
   bool     m_sym_disp_custom_practice_areas_text_on_cv;
   bool     m_sym_disp_storm_on;
   bool     m_sym_disp_storm_on_cv;
   bool     m_sym_disp_storm_text_on;
   bool     m_sym_disp_storm_text_on_cv;
   bool     m_sym_disp_custom_lines_on;
   bool     m_sym_disp_custom_lines_on_cv;
   bool     m_sym_disp_custom_lines_text_on;
   bool     m_sym_disp_custom_lines_text_on_cv;


   long     m_area_map_spider_web;
   long     m_area_map_spider_web_cv;

   bool     m_spider_web_center_on_active_airport;

   CString  m_spider_web_center_airport_id;
   CString  m_spider_web_center_airport_id_cv;
   CString  m_spider_web_center_navaid_id;
   CString  m_spider_web_center_navaid_id_cv;


   typedef  struct   identWindowInfo
   {
      CString  ident;
      CRect    rectangle;
   }  IdentWindowInfo;

   typedef  struct   symbolInfo
   {
      CPosition3D    position;
      CPosition3D    position_next;
      double         heading;
      CString        symbol;
      float          length;
      float          width;   
      int            type;
      bool           active_airport_and_runway;
   }  SymbolInfo;

   typedef  struct   symbolLabelInfo
   {
      CPosition3D    position;
      double         heading;
      CString        symbol_label;
      float          height;
      float          width;   
      int            type;
      bool           active_airport_and_runway;
   }  SymbolLabelInfo;

   CAircraftTrack    m_aircraftLeadTrack;
   CAircraftTrack    m_aircraftWingTrack;

   SymbolInfo        m_symbolInfo;
   CList <SymbolInfo,         SymbolInfo>          m_symbolInfoList;
   CList <SymbolInfo,         SymbolInfo>          m_custom_symbolInfoList;

   SymbolLabelInfo   m_symbolLabelInfo;
   CList <SymbolLabelInfo,    SymbolLabelInfo>     m_symbolLabelInfoList;
   CList <SymbolLabelInfo,    SymbolLabelInfo>     m_custom_symbolLabelInfoList;

   IdentWindowInfo   m_identWindowInfo;
   CList <IdentWindowInfo,    IdentWindowInfo>     m_identWindowInfoList;

// Attributes
public:
  	enum { IDB = IDB_AREA_MAP};

private:
   bool              m_bClearLead;
   bool              m_bClearWing;

   CVariant          m_station_to_kill;
   bool              m_station_kill_requested;
   CVariant          m_varDisplayStationKill;

   bool              m_new_scale_value;
   CVariant          m_scale_value;

   CVariant          m_varDisplaySlews;

   CVariant          m_varDisplayStorms;

   CVariant          m_reposition_select;

   CVariant          m_storm_location_select;

   COpenGLCircle     m_circle;

   int               m_mouse_x_position;
   int               m_mouse_y_position;

   enum  
   {
      BIG_UNUSUAL_BOX_OUTLINE,
      SMALL_UNUSUAL_BOX_OUTLINE,
      SPIDER_WEB,
      MAX_NUMBER_OF_LISTS
   };
   int               m_int_lists[MAX_NUMBER_OF_LISTS];

   COpenGLtext weatherAreaLabel;
   COpenGLtext stormLabel;

   double   m_weather_area_1_latitude;
   double   m_weather_area_1_latitude_cv;
   double   m_weather_area_1_longitude;
   double   m_weather_area_1_longitude_cv;
   float    m_weather_area_1_radius;
   float    m_weather_area_1_radius_cv;
   bool     m_weather_area_1_loaded;
   bool     m_weather_area_1_loaded_cv;
   bool     m_weather_area_1_active;
   bool     m_weather_area_1_active_cv;

   double   m_weather_area_2_latitude;
   double   m_weather_area_2_latitude_cv;
   double   m_weather_area_2_longitude;
   double   m_weather_area_2_longitude_cv;
   float    m_weather_area_2_radius;
   float    m_weather_area_2_radius_cv;
   bool     m_weather_area_2_loaded;
   bool     m_weather_area_2_loaded_cv;
   bool     m_weather_area_2_active;
   bool     m_weather_area_2_active_cv;

   double   m_weather_area_3_latitude;
   double   m_weather_area_3_latitude_cv;
   double   m_weather_area_3_longitude;
   double   m_weather_area_3_longitude_cv;
   float    m_weather_area_3_radius;
   float    m_weather_area_3_radius_cv;
   bool     m_weather_area_3_loaded;
   bool     m_weather_area_3_loaded_cv;
   bool     m_weather_area_3_active;
   bool     m_weather_area_3_active_cv;

   double   m_weather_area_4_latitude;
   double   m_weather_area_4_latitude_cv;
   double   m_weather_area_4_longitude;
   double   m_weather_area_4_longitude_cv;
   float    m_weather_area_4_radius;
   float    m_weather_area_4_radius_cv;
   bool     m_weather_area_4_loaded;
   bool     m_weather_area_4_loaded_cv;
   bool     m_weather_area_4_active;
   bool     m_weather_area_4_active_cv;

   CString  m_theDataToCopy;

   //Panning variables.
   bool     m_bLeftMouseDown;
   int      m_mouse_x_position_lpv;
   int      m_mouse_y_position_lpv;

protected:
	//{{AFX_MSG(CAreaMap)
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg BOOL OnMouseWheel(UINT nFlags, short zDelta, CPoint pt);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
   afx_msg LRESULT OnMouseLeave(WPARAM,LPARAM);

   CMap<CString, LPCTSTR, CString, LPCTSTR> m_TacanChannel;
};

#endif // !defined(AFX_AREAMAP_H__1D2FF182_AFB5_11D2_AD62_006008B0E0C3__INCLUDED_)
