/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : ApproachTrack.h
//
// Date             : 09 August 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.4 $
//
// Description      : ApproachTrack.h contains the definition of the 
//                    CApproachTrack class. This class is used in 
//                    conjunction with the approach plot to show the 
//                    top, side, and vref data.  Rather than using
//                    OpenGL's transformation methods, an R1 R2 T1 R3 T2
//                    matrix is precomputed.  The rotations rely on data
//                    that only changes when the runway changes.  And, T1
//                    has a fixed translation.  The values that don't change
//                    are member variables with accessors and mutators.  As
//                    these members changes, a number of sin and cos variables
//                    are also updated.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : math.h
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: approachtrack.h $                                                                   
// Revision 1.4  2000/01/27 19:55:01  billyb                                                                   
// Corrected possible memory leaks/corruption with copy                                                                   
// constructor.  Changed memcpy to non-byte by byte copy.                                                                   
// Changed list types to match new type in CVariant.                                                                   
// Revision 1.3  1999/11/26 21:02:56  billyb                                                                   
// Changed signature of UpdateData.  Changed UpdateData                                                                   
// to work with the new format for the persistant CVariant data.                                                                   
// Revision 1.2  1999/10/11 19:53:13  billyb                                                                   
/////////////////////////////////////////////////////////////////////////////
#if !defined(_APPROACHTRACK_H_)
#define _APPROACHTRACK_H_

#include <gl\gl.h>
#include <math.h>
#include "..\core\OpenGLText.h"
#include "..\core\Variant.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CApproachTrack  
{
private:
    // The sin_of_loc_hdg and cos_of_loc_hdg values used more than once,
    // but computed only once.
    double          sin_of_loc_hdg;
    double          cos_of_loc_hdg;

    double          m_dTouchdownLon;
    double          m_dTouchdownLat;
    double          m_dLocalizerLon;
    double          m_dLocalizerLat;
    float           m_fLocalizerHeading;
    float           m_fLocalizerDeviation;
    float           m_fLocalizerToGlideslopeDistance;
    float           m_fScale;

    float           m_fElevation;
    float           m_fVRef;
    float           m_fMaxVrefDeviationShown;
    float           m_fAspectRatioForVrefPlot;

    float           m_fNMToGlideslope;
    float           m_fNMToTouchdown;

    int             m_nApproachType;

    unsigned long int    m_ulVerticesAdded;
    unsigned long int    m_ulArraySize;
 
   // The time data for each vertice as well as
   // the value of time for the lasted added vertice.
   unsigned long int    m_ulLastTimeValue;
   unsigned long int*   m_times;

    GLfloat*        m_vertices;

    HWND            m_hWnd;

    // Type of track - should always be ApproachPlot
    enum TolDataClients  m_eTDC;

    int              m_nApproachViewType;

    void AddVertice(struct TolData& td, unsigned long ulCurIndex);

public:
	CApproachTrack();
	virtual ~CApproachTrack();

    // Copy constructor
    CApproachTrack(const CApproachTrack& rApproachTrack);

    // Assignment overload
    CApproachTrack& operator=(const CApproachTrack& rApproachTrack);
    
    // Equals overload
    bool operator==(const CApproachTrack& rApproachTrack);

    // Accessors
    double TouchdownLon();
    double TouchdownLat();
    double LocalizerLon();
    double LocalizerLat();
    float  LocalizerHeading();
    float  LocalizerDeviation();
    float  LocalizerToGlideslopeDistance();
    int    ApproachType();
    float  Scale();
    unsigned long int ArraySize();
    float  NMToGS();
    float  NMToTouchdown();

    float  Elevation();
    float  VRef();
    float  MaxVrefDeviationShown();
    float  AspectRatioForVrefPlot();
    unsigned long int VerticesAdded();
    HWND   Hwnd();
    enum TolDataClients TypeOfTrack();
    int ApproachViewType();

    // Mutators
    void TouchdownLon(const double dTouchdownLon);
    void TouchdownLat(const double dTouchdownLat);
    void LocalizerLon(const double dLocalizerLon);
    void LocalizerLat(const double dLocalizerLat);
    void LocalizerHeading(const float fLocalizerHeading);
    void LocalizerToGlideslopeDistance(const float fLocalizerToGlideslopeDistance);
    void ApproachType(const int nApproachType);
    void Scale(const float fScale);
    void ArraySize(const unsigned long int ulArraySize);

    void Elevation(const float fElevation);
    void VRef(const float fVRef);
    void MaxVrefDeviationShown(const float fMaxVrefDeviationShown);
    void AspectRatioForVrefPlot(const float fAspectRatioForVrefPlot);

    void Hwnd(HWND hWnd);
    void TypeOfTrack(enum TolDataClients eTDC);
    void ApproachViewType(const int nViewType);

    void Draw();

    void UpdateData();

    void RecomputeOnAirportRunwayChange();

    void Clear();
};

#endif // !defined(_APPROACHTRACK_H_)
