// ApproachPlot.h: interface for the CApproachPlot class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_APPROACHPLOT_H__51B33FA1_396E_11D3_ADDC_006008B0E0C3__INCLUDED_)
#define AFX_APPROACHPLOT_H__51B33FA1_396E_11D3_ADDC_006008B0E0C3__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "..\general\OpenGLWidget.h"
#include "OpenGLMap.h"
#include "..\core\OpenGLtext.h"
#include "..\core\Ticks.h"
#include "ApproachTrack.h"

const float ALTITUDE_SCALE_FACTOR   =  5.0f;

enum  to_from_type
{
   GOING_TOWARD   =  0,
   GOING_AWAY     =  1
};

enum  approach_view_type
{
   TOP_VIEW    =  0,
   SIDE_VIEW   =  1,
   VREF_VIEW   =  2
};

enum
{
   NON_PRECISION              =  0x00000000,
   LOCALIZER_ONLY             =  0x00000001,
   GLIDESLOPE_ONLY            =  0x00000002,
   FULL_PRECISION             =  0x00000003,
   LOCALIZER_DIRECTIONAL_AID  =  0x00000004
};

typedef struct indicator
{
    float       fX;
    float       fY;
    CString     strLabel;
    COpenGLtext label;
    CColor      color;
} ScaleIndicator;

class CApproachPlot  :  public COpenGLWidget, public COpenGLMap
{
public:
   CApproachPlot();
   virtual  ~CApproachPlot();
   static   CWidget  *CreateObject();

   void  Setup(void);
   void  Render(void);

   virtual void ChangeValue(const CString& rstrElementVar, CChangeValue* pCV);
   virtual bool UpdateRenderVariables();

private:
   void  DrawLookedUpData(void);
   void  DrawTopView(void);
   void  DrawCalculatedData(void);
   void  DrawSideView(void);
   void  DrawVrefPlot(void);

   void  DrawLocalizerBeam(void);
   void  DrawGlideslopeBeam(void);
   void  DrawAimingPointMarkers(void);
   void  DrawHorizontalScale(enum approach_view_type which_view);
   void  DrawVerticalScale(enum approach_view_type which_view);
   void  DrawRunway(enum approach_view_type which_view);
   void  AdjustTheView(void);
   bool  LimitHorizontalRange(float real_world_distance_to_ac, float glideslope_distance, float &final_horizontal_offset,  COpenGLtext &icon);

   CTicks      compass;

   CApproachTrack   m_track;
   CApproachTrack   m_altitude_track;
   CApproachTrack   m_airspeed_track;

   _FSI_STL::map<enum approach_view_type, _FSI_STL::list<ScaleIndicator> > m_mapHorzIndicators;
   _FSI_STL::map<enum approach_view_type, _FSI_STL::list<ScaleIndicator> > m_mapVertIndicators;

   _FSI_STL::map<enum approach_view_type, bool> m_mapHorzRecompute;
   _FSI_STL::map<enum approach_view_type, bool> m_mapVertRecompute;

   bool           m_bClear;

   COpenGLtext airplane;
   CString     m_airplane;

   COpenGLtext airplane_side_view;
   CString     m_airplane_side_view;

   COpenGLtext vRefIndicator;
   float       m_vRef;
   float       m_max_ias_delta;
   float       m_max_deviation_shown;
   float       m_max_airspeed_shown;
   float       m_min_airspeed_shown;

   float       m_vRef_cv;


   // These variables are associated with the items drawn by   DrawTopView() and DrawSideView().
   COpenGLtext inner_marker;
   CString     m_inner_marker;
   CString     m_inner_marker_side_view;

   COpenGLtext middle_marker;
   CString     m_middle_marker;
   CString     m_middle_marker_side_view;
   
   COpenGLtext outer_marker;
   CString     m_outer_marker;
   CString     m_outer_marker_side_view;
   
   // These variables are associated with the items drawn by   DrawLookedUpData().
   COpenGLtext airportName;
   CString     m_airport_name;
   CString     m_airport_name_title;

   COpenGLtext airportId;
   CString     m_active_airport_id;
   CString     m_active_airport_id_cv;
   CString     m_active_airport_id_title;

   COpenGLtext runwayId;
   CString     m_active_runway_id;
   CString     m_active_runway_id_cv;
   CString     m_active_runway_id_title;

   COpenGLtext localizerId;
   CString     m_active_localizer_id;
   CString     m_active_localizer_id_title;
   
   COpenGLtext localizerFreq;
   CString     m_active_localizer_freq;
   CString     m_active_localizer_freq_title;
   
   COpenGLtext locHdg;
   CString     m_loc_hdg;
   CString     m_loc_hdg_title;

   COpenGLtext runwayHdg;
   CString     m_runway_hdg;
   CString     m_runway_hdg_title;


   // These variables are associated with the items drawn by   DrawCalculatedData().
   COpenGLtext nmToTd;
   CString     m_nm_to_td;
   CString     m_nm_to_td_title;
   float       m_nm_to_td_value;
   float       m_nm_to_td_value_cv;
   float       m_nm_to_gs;
   float       m_nm_to_gs_cv;

   COpenGLtext ftAboveTouchdown;
   CString     m_ft_above_touchdown;
   CString     m_ft_above_touchdown_title;
   float       m_ft_above_touchdown_value;

   COpenGLtext vRefDeviation;
   CString     m_vref_deviation;
   CString     m_vref_deviation_title;
   float       m_vref_deviation_value;

   COpenGLtext localizerDeviation;
   CString     m_localizer_deviation;
   CString     m_localizer_deviation_title;
   float       m_localizer_deviation_value;
   float       m_localizer_deviation_value_cv;

   COpenGLtext glideslopeDeviation;
   CString     m_glideslope_deviation;
   CString     m_glideslope_deviation_title;


   // These variables are for general use.

   to_from_type   m_going_away;

   bool     m_data_available;

   double   m_touchdown_latitude;
   double   m_touchdown_longitude;

   float    m_scale;
   float    m_scale_cv;
   float    m_maximum_NM_shown;
   float    m_maximum_NM_shown_cv;

   double   m_ac_latitude;
   double   m_ac_longitude;
   float    m_ac_altitude;
   float    m_ac_heading;
   float    m_pitch;
   float    m_ias;

   double   m_ac_latitude_cv;
   double   m_ac_longitude_cv;
   float    m_ac_altitude_cv;
   float    m_ac_heading_cv;
   float    m_pitch_cv;
   float    m_ias_cv;

   float    m_elevation;

   double   m_runway_latitude;
   double   m_runway_longitude;
   float    m_runway_heading;
   float    m_runway_length;
   float    m_runway_width;
   float    m_runway_displaced_threshold;

   double   m_localizer_latitude;
   double   m_localizer_longitude;
   float    m_localizer_heading;
   float    m_localizer_width_angle;
   float    m_localizer_to_glideslope_distance;

   double   m_glideslope_latitude;
   double   m_glideslope_longitude;
   float    m_glideslope_distance;
   float    m_glideslope_angle_from_ground;
   float    m_glideslope_width_angle;

   double   m_inner_marker_latitude;
   double   m_inner_marker_longitude;
   float    m_inner_marker_heading;
   
   double   m_middle_marker_latitude;
   double   m_middle_marker_longitude;
   float    m_middle_marker_heading;
   
   double   m_outer_marker_latitude;
   double   m_outer_marker_longitude;
   float    m_outer_marker_heading;

   int      m_approach_type;

   bool     m_bool_nose_gear_down;
   bool     m_bool_left_gear_down;
   bool     m_bool_right_gear_down;

   bool		m_bool_fake_ils;

// Attributes
public:
  	enum { IDB = IDB_APPROACH_PLOT   };
};

#endif // !defined(AFX_APPROACHPLOT_H__51B33FA1_396E_11D3_ADDC_006008B0E0C3__INCLUDED_)
