/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : AircraftTrack.h
//
// Date             : 14 September 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.5 $
//
// Description      : AircraftTrack.h contains the definition of 
//                    the CAircraftTrack class.  This class is to be 
//                    used with the areamap to plot the lat/lon of the 
//                    aircraft(s).  It is similar to CApproachTrack.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : _FSI_STL::deque, math.h, Core::CVariant, .
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: aircrafttrack.h $                                                                     
// Revision 1.5  2000/01/27 19:53:42  billyb                                                                     
// Corrected possible memory leaks/corruption with copy                                                                     
// constructor.  Changed memcpy to non-byte by byte copy.                                                                     
// Changed list types to match new type in CVariant.                                                                     
// Revision 1.4  1999/11/26 21:01:42  billyb                                                                     
// Changed signature of UpdateData.  Changed UpdateData                                                                     
// to work with the new format of the data lists for CVariant                                                                     
// persistant data.                                                                     
// Revision 1.3  1999/10/19 05:28:32  billyb                                                                     
// Changed float f's to double d's.                                                                     
// Revision 1.2  1999/09/14 19:20:22  billyb                                                                     
// Added comments.  Added VerticesAdded accessor                                                                      
// for m_ulVerticesAdded which is used with                                                                      
// a full list after a clear.                                                                     
/////////////////////////////////////////////////////////////////////////////
#if !defined(_AIRCRAFTTRACK_H_)
#define _AIRCRAFTTRACK_H_

#include "ToleranceData.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class __declspec(dllexport) CAircraftTrack
{
public:
   // The area map scale.
   double               m_dScale;

   // The number of vertices in the array to plot.
   unsigned long int    m_ulVerticesAdded;

   // The maximum number of vertices to plot.
   unsigned long int    m_ulArraySize;

   // The time data for each vertice as well as
   // the value of time for the lasted added vertice.
   unsigned long int    m_ulLastTimeValue;
   unsigned long int*   m_times;

   // pointer to hold the address of dynamic memory for an
   // array of vertices to plot.
   float*               m_vertices;

   // Track color
   int                  m_red;
   int                  m_green;
   int                  m_blue;

   // Type of track - lead or wing
   enum TolDataClients  m_eTDC;

   // HWND to main frame on which the track will be drawn
   HWND                 m_hWnd;

   CVariant*            m_pHeightOfTerrain;
   float                m_fElevation;

   // Whether to use the altitude data.
   bool                 m_bUseAlt;

private:
   // Helper to cut down on bloated code.  Called from UpdateData.
   void AddVertice(struct TolData& td, unsigned long ulCurIndex);

public:
   CAircraftTrack();
   virtual ~CAircraftTrack();

   // Copy constructor
   CAircraftTrack(const CAircraftTrack& rAircraftTrack);

   // Assignment overload
   CAircraftTrack& operator=(const CAircraftTrack& rAircraftTrack);
    
   // Equals overload
   bool operator==(const CAircraftTrack& rAircraftTrack);

   void  Draw(void);

   void  UpdateData();

   void  Clear();

   // Accessors
   double   Scale();
   unsigned long int ArraySize();
   unsigned long int VerticesAdded();
   HWND     Hwnd();
   enum TolDataClients TypeOfTrack();
   bool UseAltitude();

   // Mutators
   void Scale(const double dScale);
   void ArraySize(const unsigned long int ulArraySize);
   void SetColor(int red, int green, int blue);
   void Hwnd(HWND hWnd);
   void TypeOfTrack(enum TolDataClients eTDC);
   void UseAltitude(bool bUseAlt);

   float *GetVertices(void)
   {
      return   m_vertices;
   }
};

#endif // !defined(_AIRCRAFTTRACK_H_)
