/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : CommUtils.cpp
//
// Date             : 1 May 2000
//
// Engineer         : Michael F Lawson
//
// Revision         : $
//
// Description      : A collection of utilities to read and write host labels
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : 

// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
//
//
/////////////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "CommUtils.h"
#include "..\comms\CommsShared.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif



CCommUtils::HostRateFromRegistry()
{
    int nRate;

    CString strValue = "15"; // Default value

    HKEY hKey;
    RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\Comms"), 0, KEY_READ, &hKey);

    if (hKey != NULL)
    {
		DWORD dwType, dwCount;

		LONG lResult = RegQueryValueEx(hKey, _T("HostRate"), 
                                       NULL, &dwType, NULL, &dwCount);
		if (lResult == ERROR_SUCCESS)
		{
			ASSERT(dwType == REG_SZ);
			lResult = RegQueryValueEx(hKey, _T("HostRate"), NULL, &dwType,
				            (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                      &dwCount);
			strValue.ReleaseBuffer();
		}
    }
        nRate = (int)atoi((LPCSTR)strValue);

        ASSERT(nRate > 0);
        ASSERT(nRate <= 60);

        return nRate;
}


// Here's a variation on the SetHostValue from Autotest.

void CCommUtils::SetHostValue(char *VarName, CVariant &rVariant,  unsigned long ulOffset = 0)
{
   
   _FSI_STL::string rstlStrVarName(VarName);

   CVariableData* pVarData = CCommsShared::FindVariableData(rstlStrVarName);

   if (pVarData == NULL)
        return;

   unsigned long ulCurrentOffset = pVarData->ArrayOffset();
   pVarData->ArrayOffset(ulOffset);
   CCommsShared::m_pCommsSystemInterface->WriteData(&rVariant, pVarData);

   pVarData->ArrayOffset(ulCurrentOffset);
}


void CCommUtils::SetLocalValue(char *VarName, CVariant &rVariant)
{
   _FSI_STL::string stlStrVarName(VarName);

   CVariableData* pVarData = CCommsShared::FindLocalVariableData(stlStrVarName);

   if (pVarData == NULL)
      return;

   if (pVarData->ScreenDependent() == false)
   {
      CCommsShared::m_pLocalCommsSystemInterface->WriteData(&rVariant, pVarData, 
                                              INDEPENDENT_VARIABLE);
   }
   else
   {
      // Nothing
   }
   
}



void CCommUtils::SetVariable(comm_mode dest, char *var_name, bool   value)
{
   CVariant variant;
   variant.Value(value);
   if (dest == HostComms)
      CCommUtils::SetHostValue(var_name, variant);
   else if (dest == LocalComms)
      CCommUtils::SetLocalValue(var_name, variant);
}


void CCommUtils::SetVariable(comm_mode dest, char *var_name, float  value)
{
   CVariant variant;
   variant.Value(value);
   if (dest == HostComms)
      CCommUtils::SetHostValue(var_name, variant);
   else if (dest == LocalComms)
      CCommUtils::SetLocalValue(var_name, variant);
}


void CCommUtils::SetVariable(comm_mode dest, char *var_name, long   value)
{
   CVariant variant;
   variant.Value(value);
   if (dest == HostComms)
      CCommUtils::SetHostValue(var_name, variant);
   else if (dest == LocalComms)
      CCommUtils::SetLocalValue(var_name, variant);
}


void CCommUtils::SetVariable(comm_mode dest, char *var_name, double value)
{
   CVariant variant;
   variant.Value(value);
   if (dest == HostComms)
      CCommUtils::SetHostValue(var_name, variant);
   else if (dest == LocalComms)
      CCommUtils::SetLocalValue(var_name, variant);
}


void CCommUtils::SetVariable(comm_mode dest, char *var_name, char * value, int offset)
{
   CVariant variant;
   variant.Value((_FSI_STL::string)value);
   if (dest == HostComms)
      CCommUtils::SetHostValue(var_name, variant, offset);
   else if (dest == LocalComms)
      CCommUtils::SetLocalValue(var_name, variant);
}

// **************************************************************************************


void CCommUtils::GetVariable(comm_mode dest, char *var_name, char *value, int offset)
{
   if (dest == LocalComms)
   {
     CVariant *pVariant = CCommsShared::FindLocalVariant(var_name);
     ASSERT(pVariant != NULL);
     if (pVariant != NULL)
        strcpy(value, (char *)((_FSI_STL::string)(*pVariant)).c_str());
   }
}


void CCommUtils::GetVariable(comm_mode dest, char *var_name, bool& value, int offset)
{
   if (dest == LocalComms)
   {
     CVariant *pVariant = CCommsShared::FindLocalVariant(var_name);
     ASSERT(pVariant != NULL);
     if (pVariant != NULL)
         value = (bool)(*pVariant);
   }
}


void CCommUtils::GetVariable(comm_mode dest, char *var_name, double& value, int offset)
{
   if (dest == LocalComms)
   {
     CVariant *pVariant = CCommsShared::FindLocalVariant(var_name);
     ASSERT(pVariant != NULL);
     if (pVariant != NULL)
         value = (double)(*pVariant);
   }
}


void CCommUtils::GetVariable(comm_mode dest, char *var_name, float& value, int offset)
{
   if (dest == LocalComms)
   {
     CVariant *pVariant = CCommsShared::FindLocalVariant(var_name);
     ASSERT(pVariant != NULL);
     if (pVariant != NULL)
         value = (float)(*pVariant);
   }
}


void CCommUtils::GetVariable(comm_mode dest, char *var_name, long& value, int offset)
{
   if (dest == LocalComms)
   {
     CVariant *pVariant = CCommsShared::FindLocalVariant(var_name);
     ASSERT(pVariant != NULL);
     if (pVariant != NULL)
         value = (long)(*pVariant);
   }
}