// AircraftTrackRaw.cpp: implementation of the CAircraftTrackRaw class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "AircraftTrackRaw.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CAircraftTrackRaw::CAircraftTrackRaw()
:m_pCallback(NULL)
{

}

CAircraftTrackRaw::~CAircraftTrackRaw()
{

}


void CAircraftTrackRaw::UpdateData()
{
   if (m_ulArraySize < 1)
      return;

   // Get the pointers for start of new data and last clear.
   bool bOk;
   _FSI_STL::list<struct TolData>::iterator itStart;
   _FSI_STL::list<struct TolData>::iterator itClear;

   CToleranceData::ClearIt(m_hWnd, m_eTDC, bOk, itClear);
   if (!bOk)
      return;

   CToleranceData::StartIt(m_hWnd, m_eTDC, bOk, itStart);

   if (!bOk)
      return;

   if (CToleranceData::ClearSinceLastUpdate(m_hWnd, m_eTDC))
      m_ulVerticesAdded = 0;

   unsigned short usAdded      = CToleranceData::Added(m_hWnd, m_eTDC);

   bool bAddClears = false;
   // See if we need to add data starting at the last clear.
   if (m_ulVerticesAdded == 0 && itClear != itStart)
   {
      bAddClears = true;
   }

   unsigned long ulCurIndex    = 3 * m_ulVerticesAdded;
   unsigned long ulLoop        = usAdded;
   struct TolData td;

   // Add data since last clear.  Should occur if the vertices currently added
   // is 0 and the clear pointer is not at the same point as the start pointer.
   if (bAddClears)
   {
      while (itClear != itStart)
      {
         td = (*itClear);

         AddVertice(td, ulCurIndex);

         ulCurIndex += 3;

         ++itClear;
         ++m_ulVerticesAdded;

         // Check to see if the maximum number of vertices have been
         // added and there is still more clear data to add.  If so,
         // then decrease the number of vertices added by one and move all
         // of the data down.  Also, move the current index back down 3.
         if (m_ulVerticesAdded == m_ulArraySize && itClear != itStart)
         {
            ulCurIndex -= 3;

            --m_ulVerticesAdded;

            int i = 0;
            int j = 3;
            int k = m_ulVerticesAdded * 3;
            int nTimeIndex1 = 0;
            int nTimeIndex2 = 1;
            while (i < k)
            {
               m_vertices[i]  = m_vertices[j];
               m_vertices[i+1] = m_vertices[j+1];
               m_vertices[i+2] = m_vertices[j+2];

               m_times[nTimeIndex1]    = m_times[nTimeIndex2];

               j += 3;
               i += 3;

               ++nTimeIndex1;
               ++nTimeIndex2;
            }
         }
      }
   }

   // Max number of vertices added and more need to be added.
   // Move the data down the number of vertices that need to
   // be added.
   if ((m_ulVerticesAdded + usAdded) >= m_ulArraySize && usAdded > 0)
   {
      int nNumberOfVerticesBeyondMax = (m_ulVerticesAdded + usAdded - m_ulArraySize);

      // If greater than the max size, then all of the data will get replaced
      // and a move is not necessary.
      if (nNumberOfVerticesBeyondMax < m_ulArraySize)
      {
         // Make sure that VerticesAdded stays non-negative.
         // To go negative would mean that the amount beyond the
         // end is greater than the number already in the array.  Thus,
         // all of the vertices in the array will get removed and the
         // number added would be zero.
         if (nNumberOfVerticesBeyondMax < m_ulVerticesAdded)
         {
            m_ulVerticesAdded -= nNumberOfVerticesBeyondMax;
            int i = 0;
            int j = nNumberOfVerticesBeyondMax * 3;
            int k = m_ulVerticesAdded * 3;
            int nTimeIndex1 = 0;
            int nTimeIndex2 = 1;
            while (i < k)
            {
               m_vertices[i]  = m_vertices[j];
               m_vertices[i+1] = m_vertices[j+1];
               m_vertices[i+2] = m_vertices[j+2];

               m_times[nTimeIndex1]    = m_times[nTimeIndex2];

               j += 3;
               i += 3;

               ++nTimeIndex1;
               ++nTimeIndex2;
            }
         }
         else
         {
            m_ulVerticesAdded = 0;
            if (usAdded > m_ulArraySize)
            {
               usAdded = m_ulArraySize;
               ulLoop = usAdded;
            }
         }

         ulCurIndex = 3 * m_ulVerticesAdded;
      }
      else
      {
         while (nNumberOfVerticesBeyondMax > m_ulArraySize)
         {
            --usAdded;
            ++itStart;
            --nNumberOfVerticesBeyondMax;
         }

         if (usAdded > m_ulArraySize)
            usAdded -= m_ulArraySize;

         m_ulVerticesAdded = 0;
         ulCurIndex        = 0;
         ulLoop            = m_ulArraySize;
      }
   }

   // All deques are assumed to have single element arrays as data.
   while (ulLoop)
   {
      td = (*itStart);

      AddVertice(td, ulCurIndex);

      ulCurIndex += 3;

      ++itStart;
      --ulLoop;
   }

   if (usAdded > 0)
      m_ulVerticesAdded += usAdded;

   // If the last time value minus the fist time value in
   // the array of times is greater than or equal to the
   // array size which should be the maximum time distance
   // between points then move all of the data down one.
   int nTimeIndex = 0;
   while (nTimeIndex < m_ulVerticesAdded &&
         (m_ulLastTimeValue - m_times[nTimeIndex]) >= m_ulArraySize)
   {
      ++nTimeIndex;
   }

   m_ulVerticesAdded -= nTimeIndex;

   int i = 0;
   int j = nTimeIndex * 3;
   int k = m_ulVerticesAdded * 3;
   int nTimeIndex1 = 0;
   int nTimeIndex2 = nTimeIndex;
   while (i < k)
   {
      m_vertices[i]  = m_vertices[j];
      m_vertices[i+1] = m_vertices[j+1];
      m_vertices[i+2] = m_vertices[j+2];

      m_times[nTimeIndex1]    = m_times[nTimeIndex2];

      j += 3;
      i += 3;

      ++nTimeIndex1;
      ++nTimeIndex2;
   }
}


void CAircraftTrackRaw::AddVertice(struct TolData& td, unsigned long ulCurIndex)
{
   m_ulLastTimeValue          =  td.s_ulTime;
   m_times[ulCurIndex / 3]    =  m_ulLastTimeValue;

   m_vertices[ulCurIndex]     =  td.s_dLat; 
   m_vertices[ulCurIndex + 1] =  td.s_dLon, 
   m_vertices[ulCurIndex + 2] =  td.s_fAlt;
}


int   CAircraftTrackRaw::Added(void)
{
   return   CToleranceData::Added(m_hWnd, m_eTDC);
}


void  CAircraftTrackRaw::SetCallback(void *pCallback)
{
   m_pCallback =  pCallback;
}
