// 3DPlayback.h: interface for the C3DPlayback class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_3DPLAYBACK_H__618902E1_B9EE_11D2_AD64_006008B0E0C3__INCLUDED_)
#define AFX_3DPLAYBACK_H__618902E1_B9EE_11D2_AD64_006008B0E0C3__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "..\general\OpenGLWidget.h"
#include "OpenGLMap.h"
#include "..\core\OpenGLtext.h"
#include "Texan_Model.h"
#include "AircraftTrack.h"


class C3DPlayback : 	public COpenGLWidget,   public COpenGLMap
{
public:
	C3DPlayback();
	virtual ~C3DPlayback();

   static CWidget* CreateObject();

   void  Setup(void);
   void  Render(void);
   virtual bool UpdateRenderVariables();
   virtual void ChangeValue(const CString& rstrElementVar, CChangeValue* pCV);

private:

   static   bool  m_get_initial_lead_position;
   static   bool  m_get_initial_position;

   double   m_initial_ac_latitude;
   double   m_initial_ac_longitude;
   float    m_initial_ac_altitude;

   double   m_initial_ac_latitude_cv;
   double   m_initial_ac_longitude_cv;
   float    m_initial_ac_altitude_cv;

   double   m_initial_lead_ac_latitude;
   double   m_initial_lead_ac_longitude;
   float    m_initial_lead_ac_altitude;

   double   m_initial_lead_ac_latitude_cv;
   double   m_initial_lead_ac_longitude_cv;
   float    m_initial_lead_ac_altitude_cv;


   COpenGLtext axisLabel;
   CString     m_axisLabel;
   
   COpenGLtext altitudeLabel;
   CString     m_altitudeLabel;
   COpenGLtext latitudeLabel;
   CString     m_latitudeLabel;
   COpenGLtext longitudeLabel;
   CString     m_longitudeLabel;

   Texan_Model leadModel;
   Texan_Model wingModel;

   float    m_scale;
   float    m_x_rotation;
   float    m_y_rotation;
   float    m_viewer_distance;
   float    m_pitch_angle;
   float    m_roll_angle;
   float    m_yaw_angle;

   float    m_delta_altitude;
   float    m_delta_latitude;
   float    m_delta_longitude;
   float    m_ac_altitude;
   double   m_ac_latitude;
   double   m_ac_longitude;
   float    m_ac_heading;

   float    m_lead_delta_altitude;
   float    m_lead_delta_latitude;
   float    m_lead_delta_longitude;
   float    m_lead_ac_altitude;
   double   m_lead_ac_latitude;
   double   m_lead_ac_longitude;
   float    m_lead_ac_heading;


   float    m_scale_cv;
   float    m_x_rotation_cv;
   float    m_y_rotation_cv;
   float    m_viewer_distance_cv;
   float    m_pitch_angle_cv;
   float    m_roll_angle_cv;
   float    m_yaw_angle_cv;

   float    m_delta_altitude_cv;
   float    m_delta_latitude_cv;
   float    m_delta_longitude_cv;
   float    m_ac_altitude_cv;
   double   m_ac_latitude_cv;
   double   m_ac_longitude_cv;
   float    m_ac_heading_cv;


   float    m_lead_delta_altitude_cv;
   float    m_lead_delta_latitude_cv;
   float    m_lead_delta_longitude_cv;
   float    m_lead_ac_altitude_cv;
   double   m_lead_ac_latitude_cv;
   double   m_lead_ac_longitude_cv;
   float    m_lead_ac_heading_cv;

   CAircraftTrack       m_aircraftTrack;


// Attributes
public:
  	enum { IDB = IDB_3D_PLAYBACK  };
};

#endif // !defined(AFX_3DPLAYBACK_H__618902E1_B9EE_11D2_AD64_006008B0E0C3__INCLUDED_)
