// 3DPlayback.cpp: implementation of the C3DPlayback class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "3DPlayback.h"
#include <gl\glaux.h>

//#define  VERTICAL_GRID
//#define  LIGHTING

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

bool  C3DPlayback::m_get_initial_lead_position  =  true;
bool  C3DPlayback::m_get_initial_position       =  true;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

C3DPlayback::C3DPlayback()
{
   m_exPtUpperLeft            =  CExtentsPoint(CPoint(0,0));
   m_exPtLowerRight           =  CExtentsPoint(CPoint(320,320));
   m_stlStrWidgetName         =  _FSI_STL::string("Playback");

   m_scale                    =  1.0f;
   m_x_rotation               =  0.0f;
   m_y_rotation               =  0.0f;
   m_viewer_distance          =  -5.15f;

   m_delta_altitude           =  0.0f;
   m_delta_latitude           =  0.0f;
   m_delta_longitude          =  0.0f;
   m_lead_delta_altitude      =  0.0f;
   m_lead_delta_latitude      =  0.0f;
   m_lead_delta_longitude     =  0.0f;

   m_scale_cv                 =  m_scale;
   m_x_rotation_cv            =  m_x_rotation;
   m_y_rotation_cv            =  m_y_rotation;
   m_viewer_distance_cv       =  m_viewer_distance;

   m_delta_altitude_cv        =  m_delta_altitude;
   m_delta_latitude_cv        =  m_delta_latitude;
   m_delta_longitude_cv       =  m_delta_longitude;
   m_lead_delta_altitude_cv   =  m_lead_delta_altitude;
   m_lead_delta_latitude_cv   =  m_lead_delta_latitude;
   m_lead_delta_longitude_cv  =  m_lead_delta_longitude;


   m_pitch_angle  =  0.0f;
   m_roll_angle   =  0.0f;
   m_yaw_angle    =  0.0f;


   m_listGraphicalElementVars.clear();
   m_listGraphicalElementVars.push_back("map_scale");
   m_listGraphicalElementVars.push_back("x_rotation");
   m_listGraphicalElementVars.push_back("y_rotation");
   m_listGraphicalElementVars.push_back("delta_altitude");
   m_listGraphicalElementVars.push_back("delta_latitude");
   m_listGraphicalElementVars.push_back("delta_longitude");
   m_listGraphicalElementVars.push_back("viewer_distance");
   m_listGraphicalElementVars.push_back("Pitch");
   m_listGraphicalElementVars.push_back("roll");
   m_listGraphicalElementVars.push_back("yaw");
   m_listGraphicalElementVars.push_back("ac_latitude");
   m_listGraphicalElementVars.push_back("ac_longitude");
   m_listGraphicalElementVars.push_back("ac_altitude");
   m_listGraphicalElementVars.push_back("ac_heading");
   m_listGraphicalElementVars.push_back("lead_ac_latitude");
   m_listGraphicalElementVars.push_back("lead_ac_longitude");
   m_listGraphicalElementVars.push_back("lead_ac_altitude");
   m_listGraphicalElementVars.push_back("lead_ac_heading");

   m_get_initial_lead_position   =  true;
   m_get_initial_position        =  true;
}


C3DPlayback::~C3DPlayback()
{
   m_get_initial_lead_position   =  false;
   m_get_initial_position        =  false;
}


void  C3DPlayback::Setup(void)
{
   COpenGLMap::Initialize(GetSafeHwnd());

   axisLabel.SetForegroundColor(192,   192,  192); // Light gray.
   axisLabel.SetBackgroundColor(true,  0, 0, 0);

   leadModel.Initialize(NOT_ANY);
   leadModel.SetGearPosition(NOSE_GEAR,    0.0f);
   leadModel.SetGearPosition(LEFT_GEAR,    0.0f);
   leadModel.SetGearPosition(RIGHT_GEAR,   0.0f);

   wingModel.Initialize(NAVY);
   wingModel.SetGearPosition(NOSE_GEAR,    0.0f);
   wingModel.SetGearPosition(LEFT_GEAR,    0.0f);
   wingModel.SetGearPosition(RIGHT_GEAR,   0.0f);
}


void  C3DPlayback::Render(void)
{
   BeginDraw();

   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();

   if (m_aspect_ratio  <= 1.0f)
      glScalef(m_aspect_ratio, 1.0f, 1.0f);
   else if (m_aspect_ratio != 0.0f)
      glScalef(1.0f, 1.0f  /  m_aspect_ratio, 1.0f);

   float nRange   =  20.0f *  NMI_FT;
//   gluPerspective(80.0f, 1.0f, 1.0f, nRange);
   gluPerspective(80.0f, 1.0f, 0.0001f, nRange);
   glTranslatef(0.0f, 0.0f, -2.15f);

   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();

   glPushMatrix();
   {
      glTranslatef(0.0f, 0.0f, m_viewer_distance);

      GLUquadricObj  *pquad   =  gluNewQuadric();

      glRotatef(m_x_rotation, 1.0f, 0.0f, 0.0f);
      glRotatef(m_y_rotation, 0.0f, 1.0f, 0.0f);

#ifdef   LIGHTING
	   // Light values and coordinates
      GLfloat  ambientLight[] =  {  0.3f,    0.3f,    0.3f,    1.0f };
      GLfloat  diffuseLight[] =  {  0.7f,    0.7f,    0.7f,    1.0f };
      GLfloat  lightPos[]     =  {  0.0f,    0.0f,    1.0f,    0.0f };

	   // Enable lighting
      glEnable(GL_LIGHTING);
	   // Setup and enable light 0
      glLightfv(GL_LIGHT0, GL_AMBIENT,    ambientLight);
      glLightfv(GL_LIGHT0, GL_DIFFUSE,    diffuseLight);
      glLightfv(GL_LIGHT0, GL_POSITION,   lightPos);
	   glEnable(GL_LIGHT0);
      // Enable color tracking
      glEnable(GL_COLOR_MATERIAL);
	   
      // Set Material properties to follow glColor values
      glColorMaterial(GL_FRONT, GL_AMBIENT_AND_DIFFUSE);
#endif


      // Draw the sky and the ground.
      glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
      glBegin(GL_QUADS);
         glRGB(64, 144, 255);       // Sky blue.
         // Back
         glVertex3f(-10.0f /  m_aspect_ratio,   -1.0f  /  m_aspect_ratio,  -10.0f);
         glVertex3f( 10.0f /  m_aspect_ratio,   -1.0f  /  m_aspect_ratio,  -10.0f);
         glVertex3f( 10.0f /  m_aspect_ratio,   10.0f /  m_aspect_ratio,  -10.0f);
         glVertex3f(-10.0f /  m_aspect_ratio,   10.0f /  m_aspect_ratio,  -10.0f);

         glRGB(0, 128, 0);          // Green grass
         glVertex3f(-10.0f /  m_aspect_ratio,   -1.0f /  m_aspect_ratio,  -10.0f);
         glVertex3f( 10.0f /  m_aspect_ratio,   -1.0f /  m_aspect_ratio,  -10.0f);
         glVertex3f( 10.0f /  m_aspect_ratio,   -1.0f /  m_aspect_ratio,   10.0f);
         glVertex3f(-10.0f /  m_aspect_ratio,   -1.0f /  m_aspect_ratio,   10.0f);
      glEnd();
      glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);


      glPushMatrix();
      {
         float ii;
         int   jj;

         for (ii = -10.0f, jj = 1; ii <= 10.01f; ii += 0.25f, jj++)
         {
            if (jj % 2  == 0)
            {
               glRGB(64, 64, 64);
               axisLabel.SetForegroundColor(128,   128,  128); // Medium gray.
            }
            else
            {
               glRGB(92, 92, 92);
               axisLabel.SetForegroundColor(192,   192,  192); // Light gray.
            }

            // Draw the lines that make up bottom and right side - along the z-axis.
            glBegin(GL_LINES);
               // Grid at bottom of the scene.
               glVertex3f( 10.0f,   -1.0f,   ii);
               glVertex3f(-10.0f,   -1.0f,   ii);

#ifdef   VERTICAL_GRID
               // Vertical Grid at right of the scene.
               glVertex3f( 1.0f, 10.0f,   ii);
               glVertex3f( 1.0f, -1.0f,   ii);
#endif   // VERTICAL_GRID
            glEnd();
         }


         for (ii = -10.0f, jj = 1; ii <= 10.01f; ii += 0.25f, jj++)
         {
            if (jj % 2  == 0)
            {
               glRGB(64, 64, 64);
               axisLabel.SetForegroundColor(128,   128,  128); // Medium gray.
            }
            else
            {
               glRGB(92, 92, 92);
               axisLabel.SetForegroundColor(192,   192,  192); // Light gray.
            }

            // Draw the lines that make up bottom and right side - along the z-axis.
            glBegin(GL_LINES);
               glVertex3f(ii, -1.0f,   -10.0f);
               glVertex3f(ii, -1.0f,    10.0f);

#ifdef   VERTICAL_GRID
//               glVertex3f(1.0f, ii,   -1.0f);
//               glVertex3f(1.0f, ii,    10.0f);
#endif   // VERTICAL_GRID
            glEnd();
         }

/*
            float label_value =  ROUND((25.0f * ii / m_scale), 10.0f);   // Round to the nearest 0.1.

            // Label the x-axis.
            m_axisLabel.Format("%2.1f%c", fabs(label_value), ((label_value   >  0) ?  'F'   :  (label_value   <  0) ?  'A'   :  'E'));
            glPushMatrix();
               glTranslatef(ii,  -1.0f,   0.0f);
               glRotatef(-m_y_rotation, 0.0f, 1.0f, 0.0f);
               glRotatef(-m_x_rotation, 1.0f, 0.0f, 0.0f);
               axisLabel.Draw(m_axisLabel, true, 0.0f, 1.0f, 1.0f);
            glPopMatrix();
            // Label the y-axis.
            m_axisLabel.Format("%2.1f%c", fabs(label_value), ((label_value   >  0) ?  'A'   :  (label_value   <  0) ?  'B'   :  'E'));
            glPushMatrix();
               glTranslatef(1.0f,   ii,   1.0f);
               glRotatef(-m_y_rotation, 0.0f, 1.0f, 0.0f);
               glRotatef(-m_x_rotation, 1.0f, 0.0f, 0.0f);
               axisLabel.Draw(m_axisLabel, true, 0.0f, 1.0f, 1.0f);
            glPopMatrix();
            glPushMatrix();
               glTranslatef(1.0f,   ii,  -1.0f);
               glRotatef(-m_y_rotation, 0.0f, 1.0f, 0.0f);
               glRotatef(-m_x_rotation, 1.0f, 0.0f, 0.0f);
               axisLabel.Draw(m_axisLabel, true, 0.0f, 1.0f, 1.0f);
            glPopMatrix();
            // Label the z-axis.
            m_axisLabel.Format("%2.1f%c", fabs(label_value), ((label_value   >  0) ?  'R'   :  (label_value   <  0) ?  'L'   :  'E'));
            glPushMatrix();
               glTranslatef(0.0f,   -1.0f,   ii);
               glRotatef(-m_y_rotation, 0.0f, 1.0f, 0.0f);
               glRotatef(-m_x_rotation, 1.0f, 0.0f, 0.0f);
               axisLabel.Draw(m_axisLabel, true, 0.0f, 1.0f, 1.0f);
            glPopMatrix();
*/
      }
      glPopMatrix();


      glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);

//      glScalef(m_scale,   m_scale,   m_scale);

      glPushMatrix();
      {
         // Move to the correct offset.
         glTranslatef(m_lead_delta_longitude, m_lead_delta_altitude, m_lead_delta_latitude);

         glRGB(64, 255, 64);
         // Draw Drop-Shadow (small sphere) of Lead Aircraft.
         glPushMatrix();
//            glTranslatef(0.0f,   ((-1.0f   /  m_scale)  /  m_aspect_ratio) -  m_lead_delta_altitude, 0.0f);
//            gluSphere(pquad,  0.025f   /  m_scale,  36,   18);
            glTranslatef(0.0f,   (-1.0f   /  m_aspect_ratio) -  m_lead_delta_altitude, 0.0f);
            gluSphere(pquad,  0.025f,  36,   18);
         glPopMatrix();


#ifdef   VERTICAL_GRID
         // Draw Fore-Shadow (small sphere) of Lead Aircraft.
         glPushMatrix();
            glTranslatef(((1.0f   /  m_scale)  /  m_aspect_ratio) -  m_lead_delta_longitude,   0.0f, 0.0f);
            gluSphere(pquad,  0.025f   /  m_scale,  36,   18);
         glPopMatrix();
#endif   // VERTICAL_GRID

         glRotatef(m_lead_ac_heading   -  270.0f,  0.0f, 1.0f, 0.0f);
         glRotatef(m_roll_angle,       1.0f, 0.0f, 0.0f);
         glRotatef(m_yaw_angle,        0.0f, 1.0f, 0.0f);
         glRotatef(m_pitch_angle,      0.0f, 0.0f, 1.0f);
         glRotatef(90.0f,  0.0f, 1.0f, 0.0f);
//         glScalef(1.0f  /  640.0f   /  m_scale,  1.0f  /  640.0f   /  m_scale,  1.0f  /  640.0f   /  m_scale);
//         glScalef(1.0f  /  640.0f,  1.0f  /  640.0f,  1.0f  /  640.0f);
         glScalef(1.0f  /  800.0f,  1.0f  /  800.0f,  1.0f  /  800.0f);

         glEnable(GL_DEPTH_TEST);
         glEnable(GL_CULL_FACE);

         glClear(GL_DEPTH_BUFFER_BIT);
         leadModel.Render();

         glDisable(GL_DEPTH_TEST);
         glDisable(GL_CULL_FACE);
      }
      glPopMatrix();

      glPushMatrix();
      {
         // Move to the correct offset.
         glTranslatef(m_delta_longitude, m_delta_altitude, m_delta_latitude);

         glRGB(64, 64, 255);
         // Draw Drop-Shadow (small sphere) of Wing Aircraft.
         glPushMatrix();
//            glTranslatef(0.0f,   ((-1.0f   /  m_scale)  /  m_aspect_ratio) -  m_delta_altitude, 0.0f);
//            gluSphere(pquad,   0.025f   /  m_scale, 36, 18);
            glTranslatef(0.0f,   (-1.0f   /  m_aspect_ratio) -  m_delta_altitude, 0.0f);
            gluSphere(pquad,   0.025f, 36, 18);
         glPopMatrix();

#ifdef   VERTICAL_GRID
         // Draw Fore-Shadow (small sphere) of Wing Aircraft.
         glPushMatrix();
            glTranslatef(((1.0f   /  m_scale)  /  m_aspect_ratio) -  m_delta_longitude,   0.0f, 0.0f);
            gluSphere(pquad,  0.025f   /  m_scale,  36,   18);
         glPopMatrix();
#endif   // VERTICAL_GRID
         glRotatef(m_ac_heading  -  270.0f,  0.0f, 1.0f, 0.0f);
         glRotatef(m_roll_angle,    1.0f, 0.0f, 0.0f);
         glRotatef(m_yaw_angle,     0.0f, 1.0f, 0.0f);
         glRotatef(m_pitch_angle,   0.0f, 0.0f, 1.0f);
         glRotatef(90.0f,  0.0f, 1.0f, 0.0f);
//         glScalef(1.0f  /  640.0f   /  m_scale,  1.0f  /  640.0f   /  m_scale,  1.0f  /  640.0f   /  m_scale);
//         glScalef(1.0f  /  640.0f,  1.0f  /  640.0f,  1.0f  /  640.0f);
         glScalef(1.0f  /  800.0f,  1.0f  /  800.0f,  1.0f  /  800.0f);

         glEnable(GL_DEPTH_TEST);
         glEnable(GL_CULL_FACE);

         glClear(GL_DEPTH_BUFFER_BIT);
         wingModel.Render();

         glDisable(GL_DEPTH_TEST);
         glDisable(GL_CULL_FACE);
      }
      glPopMatrix();


      // Aircraft Track information display.
//      m_aircraftTrack.Scale(m_scale);
//      m_aircraftTrack.Draw();


#ifdef   LIGHTING
   glDisable(GL_LIGHTING);
   glDisable(GL_COLOR_MATERIAL);
	glDisable(GL_LIGHT0);
#endif

      gluDeleteQuadric(pquad);
   }
   glPopMatrix();


   EndDraw();

   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();

   glMatrixMode(GL_MODELVIEW);
   glLoadIdentity();
}


CWidget* C3DPlayback::CreateObject()
{
   return new C3DPlayback();
}


void C3DPlayback::ChangeValue(const CString& rstrElementVar, CChangeValue* pCV)
{
   if (pCV == NULL)
   {
       return;
   }
   CVariant* pVariant = pCV->Variant();

   static   bool  altitude_changed     =  false;
   static   bool  latitude_changed     =  false;
   static   bool  longitude_changed    =  false;

   if (rstrElementVar   == CString("map_scale"))
   {
      if ((float)(*pVariant) == 0.0f)
         m_scale_cv  =  1.0f;
      else
         m_scale_cv =  *pVariant;
   }
   else if (rstrElementVar == CString("x_rotation"))
   {
      m_x_rotation_cv   =  *pVariant;
   }
   else if (rstrElementVar == CString("y_rotation"))
   {
      m_y_rotation_cv   =  *pVariant;
   }
   else if (rstrElementVar == CString("delta_altitude"))
   {
      m_delta_altitude_cv  =  *pVariant;
      m_delta_altitude_cv  =  (m_delta_altitude_cv    /  5.0f) *  0.20f;
   }
   else if (rstrElementVar == CString("delta_latitude"))
   {
      m_delta_latitude_cv  =  *pVariant;
      m_delta_latitude_cv  =  (m_delta_latitude_cv    /  5.0f) *  0.20f;
   }
   else if (rstrElementVar == CString("delta_longitude"))
   {
      m_delta_longitude_cv =  *pVariant;
      m_delta_longitude_cv =  (m_delta_longitude_cv   /  5.0f) *  0.20f;
   }
   else if (rstrElementVar == CString("viewer_distance"))
   {
      m_viewer_distance_cv =  *pVariant;
   }
   else if (rstrElementVar == CString("Pitch"))       // Pitch
   {
      m_pitch_angle_cv  =  *pVariant;
   }
   else if (rstrElementVar == CString("roll"))        // roll
   {
      m_roll_angle_cv   =  *pVariant;
   }
   else if (rstrElementVar == CString("yaw"))        // yaw
   {
      m_yaw_angle_cv    =  *pVariant;
   }
   else if (rstrElementVar == CString("ac_altitude"))
   {
      m_ac_altitude_cv     =  *pVariant;
      if (m_get_initial_position)
      {
         m_initial_ac_altitude_cv   =  m_ac_altitude_cv;
      }
      altitude_changed     =  true;
   }
   else if (rstrElementVar == CString("ac_latitude"))
   {
      m_ac_latitude_cv     =  *pVariant;
      if (m_get_initial_position)
      {
         m_initial_ac_latitude_cv   =  m_ac_latitude_cv;
      }
      latitude_changed     =  true;
   }
   else if (rstrElementVar == CString("ac_longitude"))
   {
      m_ac_longitude_cv    =  *pVariant;
      if (m_get_initial_position)
      {
         m_initial_ac_longitude_cv  =  m_ac_longitude_cv;
      }
      longitude_changed    =  true;
   }
   else if (rstrElementVar == CString("lead_ac_altitude"))
   {
      m_lead_ac_altitude_cv   =  *pVariant;
      if (m_get_initial_lead_position)
      {
         m_initial_lead_ac_altitude_cv   =  m_lead_ac_altitude_cv;
      }
      altitude_changed  =  true;
   }
   else if (rstrElementVar == CString("lead_ac_latitude"))
   {
      m_lead_ac_latitude_cv   =  *pVariant;
      if (m_get_initial_lead_position)
      {
         m_initial_lead_ac_latitude_cv   =  m_lead_ac_latitude_cv;
      }
      latitude_changed  =  true;
   }
   else if (rstrElementVar == CString("lead_ac_longitude"))
   {
      m_lead_ac_longitude_cv  =  *pVariant;
      if (m_get_initial_lead_position)
      {
         m_initial_lead_ac_longitude_cv  =  m_lead_ac_longitude_cv;
      }
      longitude_changed =  true;
   }
   else if (rstrElementVar == CString("ac_heading"))
   {
      m_ac_heading_cv      =  *pVariant;
   }
   else if (rstrElementVar == CString("lead_ac_heading"))
   {
      m_lead_ac_heading_cv =  *pVariant;
   }


   if (altitude_changed && latitude_changed  && longitude_changed)
   {
      CPosition3D    position;
      position.m_altitude   =  m_ac_altitude_cv;
      position.m_latitude   =  m_ac_latitude_cv;
      position.m_longitude  =  m_ac_longitude_cv;
//      m_aircraftTrack.AddTail(position);

      altitude_changed  =  false;
      latitude_changed  =  false;
      longitude_changed =  false;
   }
}

/////////////////////////////////////////////////////////////////////////////
//
// bool C3DPlayback::UpdateRenderVariables()
//
// Inputs           : None.
//
// Return Values    : success value of the update of the rendering variables.
//
// Date             : 16 June 1999
//
// Engineer         : Billy Baker
//
// Description      : Override of the parent's UpdateRenderVariables.  
//                    If the class is being destroyed while in this method,
//                    then the return value should be false. This method is
//                    called by the COMMS layer before it tells the mainframe
//                    that a screen update is needed.
//
/////////////////////////////////////////////////////////////////////////////
bool C3DPlayback::UpdateRenderVariables()
{
   m_scale                 =  m_scale_cv;
   m_x_rotation            =  m_x_rotation_cv;
   m_y_rotation            =  m_y_rotation_cv;
   m_viewer_distance       =  m_viewer_distance_cv;

   m_pitch_angle           =  m_pitch_angle_cv;
   m_roll_angle            =  m_roll_angle_cv;
   m_yaw_angle             =  m_yaw_angle_cv;


   m_delta_altitude              =  m_delta_altitude_cv;
   m_delta_latitude              =  m_delta_latitude_cv;
   m_delta_longitude             =  m_delta_longitude_cv;

   m_lead_delta_altitude         =  m_lead_delta_altitude_cv;
   m_lead_delta_latitude         =  m_lead_delta_latitude_cv;
   m_lead_delta_longitude        =  m_lead_delta_longitude_cv;

   m_ac_altitude                 =  m_ac_altitude_cv;
   m_ac_latitude                 =  m_ac_latitude_cv;
   m_ac_longitude                =  m_ac_longitude_cv;
   m_ac_heading                  =  -m_ac_heading_cv;

   m_lead_ac_altitude            =  m_lead_ac_altitude_cv;
   m_lead_ac_latitude            =  m_lead_ac_latitude_cv;
   m_lead_ac_longitude           =  m_lead_ac_longitude_cv;
   m_lead_ac_heading             =  -m_lead_ac_heading_cv;

   m_initial_lead_ac_altitude    =  m_initial_lead_ac_altitude_cv;
   m_initial_lead_ac_latitude    =  m_initial_lead_ac_latitude_cv;
   m_initial_lead_ac_longitude   =  m_initial_lead_ac_longitude_cv;


   m_initial_ac_altitude         =  m_initial_ac_altitude_cv;
   m_initial_ac_latitude         =  m_initial_ac_latitude_cv;
   m_initial_ac_longitude        =  m_initial_ac_longitude_cv;

   float    initial_avg_altitude    =  (m_initial_lead_ac_altitude   +  m_initial_ac_altitude)  /  2.0f; 
   double   initial_avg_latitude    =  (m_initial_lead_ac_latitude   +  m_initial_ac_latitude)  /  2.0f; 
   double   initial_avg_longitude   =  (m_initial_lead_ac_longitude  +  m_initial_ac_longitude) /  2.0f; 
   
   m_get_initial_lead_position   =  false;
   m_get_initial_position        =  false;

/*
   m_lead_delta_altitude   =  (m_initial_lead_ac_altitude_cv   -  m_lead_ac_altitude_cv)  /  25.0f;
   m_lead_delta_latitude   =  -(m_initial_lead_ac_latitude_cv  -  m_lead_ac_latitude_cv)  *  NM_PER_DEGREE  *  NMI_FT   /  25.0;
   m_lead_delta_longitude  =  (m_initial_lead_ac_longitude_cv  -  m_lead_ac_longitude_cv) *  cos(((m_initial_lead_ac_latitude_cv +  m_lead_ac_latitude_cv)  /  2.0)  *  DEG_TO_RAD) *  NM_PER_DEGREE  *  NMI_FT   /  25.0;

   m_delta_altitude        =  (m_initial_ac_altitude_cv        -  m_ac_altitude_cv)       /  25.0f;
   m_delta_latitude        =  -(m_initial_ac_latitude_cv       -  m_ac_latitude_cv)       *  NM_PER_DEGREE  *  NMI_FT   /  25.0;
   m_delta_longitude       =  (m_initial_ac_longitude_cv       -  m_ac_longitude_cv)      *  cos(((m_initial_ac_latitude_cv      +  m_ac_latitude_cv)       /  2.0)  *  DEG_TO_RAD) *  NM_PER_DEGREE  *  NMI_FT   /  25.0;
*/
/*
   m_lead_delta_altitude   =  (m_lead_ac_altitude_cv  -  initial_avg_altitude)   /  25.0f;
   m_lead_delta_latitude   =  -(m_lead_ac_latitude_cv -  initial_avg_latitude)   *  NM_PER_DEGREE  *  NMI_FT   /  100.0;
   m_lead_delta_longitude  =  (m_lead_ac_longitude_cv -  initial_avg_longitude)  *  cos(((initial_avg_latitude +  m_lead_ac_latitude_cv)  /  2.0)  *  DEG_TO_RAD) *  NM_PER_DEGREE  *  NMI_FT   /  100.0;

   m_delta_altitude        =  (m_ac_altitude_cv       -  initial_avg_altitude)   /  25.0f;
   m_delta_latitude        =  -(m_ac_latitude_cv      -  initial_avg_latitude)   *  NM_PER_DEGREE  *  NMI_FT   /  100.0;
   m_delta_longitude       =  (m_ac_longitude_cv      -  initial_avg_longitude)  *  cos(((initial_avg_latitude +  m_ac_latitude_cv)       /  2.0)  *  DEG_TO_RAD) *  NM_PER_DEGREE  *  NMI_FT   /  100.0;
*/
   m_lead_ac_heading =  -90.0f;
   m_ac_heading      =  -90.0f;

   m_lead_delta_altitude   =  0.0;
   m_lead_delta_latitude   =  0.0;
   m_lead_delta_longitude  =  0.0;

   m_delta_altitude        =  0.0;
   m_delta_latitude        =  0.0;
   m_delta_longitude       =  0.875;

   return CWidget::UpdateRenderVariables();
}
